/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.reloc.com.google.common.base.Strings;
import com.crashlytics.reloc.com.google.common.collect.ImmutableMap;
import com.crashlytics.reloc.com.google.common.collect.Lists;
import com.crashlytics.reloc.org.apache.commons.io.IOUtils;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.EmptyOnboarder;
import com.crashlytics.tools.android.onboard.Kit;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.OnboardingConstants;
import com.crashlytics.tools.android.onboard.StringManifestProvider;
import com.crashlytics.tools.android.onboard.StubCode;
import com.crashlytics.tools.android.project.DefaultManifestData;
import com.crashlytics.tools.android.project.ManifestData;
import com.crashlytics.tools.android.project.ManifestProvider;
import com.crashlytics.tools.utils.FileUtils;
import com.crashlytics.tools.utils.xml.ElementOffsetFinder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.Locator;

public class ManifestOnboarder
extends EmptyOnboarder {
    private final ManifestProvider _manifestProvider;
    private final Optional<Kit> _kit;
    private final boolean _injectInternetPermission;
    protected final Optional<String> _apiKeyToInject;

    public ManifestOnboarder(ManifestProvider manifestProvider, Optional<String> apiKeyToInject, Optional<Kit> kit, boolean injectInternetPermission) {
        this._manifestProvider = manifestProvider;
        this._apiKeyToInject = apiKeyToInject;
        this._kit = kit;
        this._injectInternetPermission = injectInternetPermission;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<CodeChange> getCodeChanges() throws OnboardException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<CodeChange> getCodeChangeDirections() {
        try {
            InputStream manifestStream = ManifestOnboarder.class.getClassLoader().getResourceAsStream("examples/AndroidManifest.xml.txt");
            Optional<String> manifestContents = Optional.fromNullable(FileUtils.streamToString(manifestStream));
            if (!manifestContents.isPresent()) {
                throw new IOException("Could not find example manifest: examples/AndroidManifest.xml.txt");
            }
            String manifestString = manifestContents.get();
            String permissionSearchContent = "android:targetSdkVersion=\"15\" />";
            int permissionOffset = manifestString.indexOf(permissionSearchContent) + permissionSearchContent.length();
            String apiSearchContent = "</activity>";
            int applicationOffset = manifestString.indexOf(apiSearchContent) + apiSearchContent.length();
            String lineSeparator = "\n";
            String applicationIndent = "  ";
            DefaultManifestData manifestData = DefaultManifestData.createManifest(new StringManifestProvider("AndroidManifest.xml", manifestString));
            LinkedList<CodeChange.BlockChange> changes = Lists.newLinkedList();
            changes.addAll(this.getCommonChanges(manifestData, manifestString, permissionOffset, applicationOffset, lineSeparator, applicationIndent));
            changes.addAll(this.getKitChanges(manifestData, permissionOffset, applicationOffset, lineSeparator, applicationIndent));
            return Collections.singletonList(new CodeChange("AndroidManifest.xml", new StubCode(manifestContents.get()), changes));
        }
        catch (IOException e) {
            DeveloperTools.logE("Could not get code directions for example manifest", e);
            return Collections.singletonList(CodeChange.createEmptyChange("AndroidManifest.xml"));
        }
    }

    protected String getLineSeparator(String contents) {
        return FileUtils.getLineSeparator(contents);
    }

    private List<CodeChange.BlockChange> getCommonChanges(ManifestData manifestData, String manifestString, int permissionOffset, int applicationOffset, String lineSeparator, String applicationIndent) throws IOException {
        ArrayList<CodeChange.BlockChange> changes = Lists.newArrayList();
        if (!manifestData.hasPermission("android.permission.INTERNET") && this._injectInternetPermission) {
            changes.add(this.getPermissionChange("android.permission.INTERNET", permissionOffset, lineSeparator + lineSeparator, applicationIndent));
        }
        if (this._apiKeyToInject.isPresent()) {
            Optional<String> manifestApiKey = manifestData.getApiKey();
            if (manifestApiKey.isPresent()) {
                if (!manifestApiKey.get().equals(this._apiKeyToInject.get())) {
                    try {
                        changes.addAll(this.getApiKeyUpdateChanges(manifestApiKey.get(), this._apiKeyToInject.get(), manifestString));
                    }
                    catch (Exception e) {
                        DeveloperTools.logE("Failed to update manifest API key", e);
                    }
                }
            } else {
                changes.add(this.getApiKeyMetaDataChange(applicationOffset, lineSeparator, applicationIndent));
            }
        }
        return changes;
    }

    private List<CodeChange.BlockChange> getApiKeyUpdateChanges(String manifestApiKey, String updatedApiKey, String manifestString) throws Exception {
        int pos;
        LinkedList<CodeChange.BlockChange> changes = Lists.newLinkedList();
        InputStream manifestStream = null;
        try {
            manifestStream = this._manifestProvider.getManifestStream();
            ImmutableMap<String, String> attributes = ImmutableMap.of("android:name", "com.crashlytics.ApiKey");
            ElementOffsetFinder apiKeyOffset = ElementOffsetFinder.getElementOffset(manifestStream, "meta-data", attributes);
            Locator locator = apiKeyOffset.getStartOffsetLocator();
            pos = FileUtils.locatorCharacterOffset(manifestStream, locator);
            if (pos == -1) {
                throw new OnboardException("Unexpected: API Key was not present in XML, failed");
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to get Crashlytics api key update injection", e);
        }
        finally {
            IOUtils.closeQuietly(manifestStream);
        }
        int startDelete = manifestString.indexOf(manifestApiKey, pos);
        int endDelete = manifestApiKey.length() + startDelete;
        changes.add(new CodeChange.Deletion(startDelete, endDelete));
        changes.add(new CodeChange.Insertion(endDelete, updatedApiKey));
        return changes;
    }

    private CodeChange.BlockChange getApiKeyMetaDataChange(int applicationOffset, String lineSeparator, String applicationIndent) {
        String metadataElementStr = lineSeparator + this.createMetadataElement(applicationIndent);
        return new CodeChange.Insertion(applicationOffset, metadataElementStr);
    }

    private List<CodeChange.BlockChange> getKitChanges(ManifestData manifestData, int permissionOffset, int applicationOffset, String lineSeparator, String applicationIndent) {
        ArrayList<CodeChange.BlockChange> changes = Lists.newArrayList();
        if (this._kit.isPresent() && OnboardingConstants.MOPUB_KIT.isSameArtifact(this._kit.get())) {
            changes.addAll(this.getMoPubChanges(manifestData, permissionOffset, applicationOffset, lineSeparator, applicationIndent));
        }
        return changes;
    }

    private List<CodeChange.BlockChange> getMoPubChanges(ManifestData manifestData, int permissionOffset, int applicationOffset, String lineSeparator, String applicationIndent) {
        ArrayList<CodeChange.BlockChange> changes = Lists.newArrayList();
        if (!manifestData.hasPermission("android.permission.ACCESS_NETWORK_STATE")) {
            changes.add(this.getPermissionChange("android.permission.ACCESS_NETWORK_STATE", permissionOffset, lineSeparator, applicationIndent));
        }
        for (String activity : ManifestData.BASE_MOPUB_ACTIVITIES) {
            if (manifestData.hasActivity(activity)) continue;
            String activityElement = lineSeparator + this.createActivityElement(activity, applicationIndent);
            changes.add(new CodeChange.Insertion(applicationOffset, activityElement));
        }
        return changes;
    }

    private CodeChange.BlockChange getPermissionChange(String permission, int permissionOffset, String lineSeparator, String applicationIndent) {
        String internetPermission = lineSeparator + applicationIndent + String.format("<uses-permission android:name=\"%s\"/>", permission);
        return new CodeChange.Insertion(permissionOffset, internetPermission);
    }

    private String createMetadataElement(String indent) {
        return indent + indent + String.format("<meta-data android:name=\"com.crashlytics.ApiKey\" android:value=\"%s\"/>", this._apiKeyToInject.get());
    }

    private String createActivityElement(String activity, String indent) {
        String extraIndent = Strings.repeat(" ", "<activity ".length());
        return indent + indent + String.format("<activity android:name=\"%s\"\n%sandroid:configChanges=\"keyboardHidden|orientation\"/>", activity, indent + indent + extraIndent);
    }

    private void logLineSeparator(String lineSep) {
        if (lineSep.equals("\r")) {
            DeveloperTools.logD("Crashlytics identified line separator: r (Mac 9 and below)");
        } else if (lineSep.equals("\r\n")) {
            DeveloperTools.logD("Crashlytics identified line separator: rn (Windows)");
        } else if (lineSep.equals("\n\r")) {
            DeveloperTools.logD("Crashlytics identified line separator: nr (Unexpected)");
        } else if (lineSep.equals("\n")) {
            DeveloperTools.logD("Crashlytics identified line separator: n (Unix)");
        } else {
            DeveloperTools.logD("Crashlytics identified line separator: [" + lineSep + "] (Unknown)");
        }
    }
}

