/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics;

import com.crashlytics.tools.android.DeveloperTools;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeveloperToolsUtils {
    private final String _projectPath;
    private final String _androidResPath;
    private final String _androidAssetsPath;
    private final String _androidManifestPath;
    private final String _propertiesPath;
    private final String _requireUploadSuccess;
    private final boolean _proguardDetected;
    private final String _mappingPath;
    private final String _renamedPackage;
    private final String _apkFilePath;
    private final String _betaDistributionEmails;
    private final String _betaDistributionGroupShortNames;
    private final String _betaDistributionReleaseNotes;
    private final String _betaDistributionEmailsFilePath;
    private final String _betaDistributionGroupShortNamesFilePath;
    private final String _betaDistributionReleaseNotesFilePath;

    @Deprecated
    public DeveloperToolsUtils(String projectPath, String androidResPath, String androidAssetsPath, String androidManifestPath, String propertiesPath, String requireUploadSuccess, boolean proguardDetected, String mappingPath, String renamedPackage, String apkFilePath) {
        this._projectPath = projectPath;
        this._androidResPath = androidResPath;
        this._androidAssetsPath = androidAssetsPath;
        this._androidManifestPath = androidManifestPath;
        this._propertiesPath = propertiesPath;
        this._requireUploadSuccess = requireUploadSuccess;
        this._proguardDetected = proguardDetected;
        this._mappingPath = mappingPath;
        this._renamedPackage = renamedPackage;
        this._apkFilePath = apkFilePath;
        this._betaDistributionEmails = null;
        this._betaDistributionGroupShortNames = null;
        this._betaDistributionReleaseNotes = null;
        this._betaDistributionEmailsFilePath = null;
        this._betaDistributionGroupShortNamesFilePath = null;
        this._betaDistributionReleaseNotesFilePath = null;
    }

    private DeveloperToolsUtils(Builder builder) {
        this._projectPath = builder.projectPath;
        this._androidResPath = builder.androidResPath;
        this._androidAssetsPath = builder.androidAssetsPath;
        this._androidManifestPath = builder.androidManifestPath;
        this._propertiesPath = builder.propertiesPath;
        this._requireUploadSuccess = builder.requireUploadSuccess;
        this._proguardDetected = builder.proguardDetected;
        this._mappingPath = builder.mappingPath;
        this._renamedPackage = builder.renamedPackage;
        this._apkFilePath = builder.apkFilePath;
        this._betaDistributionEmails = builder.betaDistributionEmails;
        this._betaDistributionGroupShortNames = builder.betaDistributionGroupShortNames;
        this._betaDistributionReleaseNotes = builder.betaDistributionReleaseNotes;
        this._betaDistributionEmailsFilePath = builder.betaDistributionEmailsFilePath;
        this._betaDistributionGroupShortNamesFilePath = builder.betaDistributionGroupShortNamesFilePath;
        this._betaDistributionReleaseNotesFilePath = builder.betaDistributionReleaseNotesFilePath;
    }

    public void storeDeobsFile() {
        ArrayList<String> args = new ArrayList<String>();
        this.appendDefaultArgs(args);
        this.appendValueArgTo(args, "-storeDeobs", this._mappingPath);
        if (this._proguardDetected) {
            this.appendArgTo(args, "-obfuscating");
            this.appendValueArgTo(args, "-obfuscator", "proguard");
            this.appendValueArgTo(args, "-obVer", "4.7");
        }
        DeveloperTools.processArgs(args.toArray(new String[args.size()]));
    }

    public void cleanupResourceFile() {
        ArrayList<String> args = new ArrayList<String>();
        this.appendDefaultArgs(args);
        this.appendArgTo(args, "-cleanupResourceFile");
        DeveloperTools.processArgs(args.toArray(new String[args.size()]));
    }

    public void uploadDeobsFiles() {
        ArrayList<String> args = new ArrayList<String>();
        this.appendDefaultArgs(args);
        if (Boolean.valueOf(this._requireUploadSuccess).booleanValue()) {
            this.appendArgTo(args, "-requireUploadSuccess");
        }
        this.appendArgTo(args, "-uploadDeobs");
        DeveloperTools.processArgs(args.toArray(new String[args.size()]));
    }

    public void generateResourceFile() {
        ArrayList<String> args = new ArrayList<String>();
        this.appendDefaultArgs(args);
        this.appendArgTo(args, "-buildEvent");
        this.appendOptionalArgTo(args, "-tool", DeveloperToolsUtils.class.getPackage().getImplementationTitle());
        this.appendOptionalArgTo(args, "-version", DeveloperToolsUtils.class.getPackage().getImplementationVersion());
        this.appendArgTo(args, "-generateResourceFile");
        DeveloperTools.processArgs(args.toArray(new String[args.size()]));
    }

    public void uploadDistribution() {
        ArrayList<String> args = new ArrayList<String>();
        this.appendDefaultArgs(args);
        this.appendArgTo(args, "-uploadDist");
        this.appendArgTo(args, this._apkFilePath);
        this.appendOptionalArgTo(args, "-betaDistributionEmails", this._betaDistributionEmails);
        this.appendOptionalArgTo(args, "-betaDistributionGroupShortNames", this._betaDistributionGroupShortNames);
        this.appendOptionalArgTo(args, "-betaDistributionReleaseNotes", this._betaDistributionReleaseNotes);
        this.appendOptionalArgTo(args, "-betaDistributionEmailsFilePath", this._betaDistributionEmailsFilePath);
        this.appendOptionalArgTo(args, "-betaDistributionGroupShortNamesFilePath", this._betaDistributionGroupShortNamesFilePath);
        this.appendOptionalArgTo(args, "-betaDistributionReleaseNotesFilePath", this._betaDistributionReleaseNotesFilePath);
        DeveloperTools.processArgs(args.toArray(new String[args.size()]));
    }

    private void appendDefaultArgs(List<String> args) {
        this.appendOptionalArgTo(args, "-projectPath", this._projectPath);
        this.appendOptionalArgTo(args, "-androidRes", this._androidResPath);
        this.appendOptionalArgTo(args, "-androidAssets", this._androidAssetsPath);
        this.appendOptionalArgTo(args, "-androidManifest", this._androidManifestPath);
        this.appendOptionalArgTo(args, "-renamedPackage", this._renamedPackage);
        if (this._propertiesPath != null && new File(this._propertiesPath).exists()) {
            this.appendOptionalArgTo(args, "-properties", this._propertiesPath);
        }
    }

    private void appendOptionalArgTo(List<String> args, String paramName, String paramValue) {
        if (paramValue != null) {
            args.add(paramName);
            args.add(paramValue);
        }
    }

    private void appendValueArgTo(List<String> args, String paramName, String paramValue) {
        args.add(paramName);
        args.add(paramValue);
    }

    private void appendArgTo(List<String> args, String paramName) {
        args.add(paramName);
    }

    public static class Builder {
        String projectPath;
        String androidResPath;
        String androidAssetsPath;
        String androidManifestPath;
        String propertiesPath;
        String requireUploadSuccess;
        boolean proguardDetected;
        String mappingPath;
        String renamedPackage;
        String apkFilePath;
        String betaDistributionEmails;
        String betaDistributionGroupShortNames;
        String betaDistributionReleaseNotes;
        String betaDistributionEmailsFilePath;
        String betaDistributionGroupShortNamesFilePath;
        String betaDistributionReleaseNotesFilePath;

        public Builder setProjectPath(String projectPath) {
            this.projectPath = projectPath;
            return this;
        }

        public Builder setAndroidResPath(String androidResPath) {
            this.androidResPath = androidResPath;
            return this;
        }

        public Builder setAndroidAssetsPath(String androidAssetsPath) {
            this.androidAssetsPath = androidAssetsPath;
            return this;
        }

        public Builder setAndroidManifestPath(String androidManifestPath) {
            this.androidManifestPath = androidManifestPath;
            return this;
        }

        public Builder setPropertiesPath(String propertiesPath) {
            this.propertiesPath = propertiesPath;
            return this;
        }

        public Builder setRequireUploadSuccess(String requireUploadSuccess) {
            this.requireUploadSuccess = requireUploadSuccess;
            return this;
        }

        public Builder setProguardDetected(boolean proguardDetected) {
            this.proguardDetected = proguardDetected;
            return this;
        }

        public Builder setMappingPath(String mappingPath) {
            this.mappingPath = mappingPath;
            return this;
        }

        public Builder setRenamedPackage(String renamedPackage) {
            this.renamedPackage = renamedPackage;
            return this;
        }

        public Builder setApkFilePath(String apkFilePath) {
            this.apkFilePath = apkFilePath;
            return this;
        }

        public Builder setBetaDistributionEmails(String betaDistributionEmails) {
            this.betaDistributionEmails = betaDistributionEmails;
            return this;
        }

        public Builder setBetaDistributionGroupShortNames(String betaDistributionGroupShortNames) {
            this.betaDistributionGroupShortNames = betaDistributionGroupShortNames;
            return this;
        }

        public Builder setBetaDistributionReleaseNotes(String betaDistributionReleaseNotes) {
            this.betaDistributionReleaseNotes = betaDistributionReleaseNotes;
            return this;
        }

        public Builder setBetaDistributionEmailsFilePath(String betaDistributionEmailsFilePath) {
            this.betaDistributionEmailsFilePath = betaDistributionEmailsFilePath;
            return this;
        }

        public Builder setBetaDistributionGroupShortNamesFilePath(String betaDistributionGroupShortNamesFilePath) {
            this.betaDistributionGroupShortNamesFilePath = betaDistributionGroupShortNamesFilePath;
            return this;
        }

        public Builder setBetaDistributionReleaseNotesFilePath(String betaDistributionReleaseNotesFilePath) {
            this.betaDistributionReleaseNotesFilePath = betaDistributionReleaseNotesFilePath;
            return this;
        }

        public DeveloperToolsUtils build() {
            return new DeveloperToolsUtils(this);
        }
    }
}

