/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.sdklib.internal.repository;

import com.crashlytics.reloc.com.android.sdklib.NullSdkLog;
import com.crashlytics.reloc.com.android.sdklib.SdkManager;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.Archive;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.IMinApiLevelDependency;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.LocalSdkParser;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.MinToolsPackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.NullTaskMonitor;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.Package;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.SdkSource;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.XmlParserUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtraPackage
extends MinToolsPackage
implements IMinApiLevelDependency {
    private final String mDisplayName;
    private final String mVendorId;
    private final String mVendorDisplay;
    private final String mPath;
    private final String mOldPaths;
    private final int mMinApiLevel;
    private final String[] mProjectFiles;

    ExtraPackage(SdkSource sdkSource, Node node, String string, Map<String, String> map) {
        super(sdkSource, node, string, map);
        this.mPath = XmlParserUtils.getXmlString(node, "path");
        String string2 = XmlParserUtils.getXmlString(node, "name-display");
        String string3 = XmlParserUtils.getXmlString(node, "vendor-display");
        String string4 = XmlParserUtils.getXmlString(node, "vendor-id");
        if (string4.length() == 0) {
            String string5 = XmlParserUtils.getXmlString(node, "vendor");
            string4 = this.sanitizeLegacyVendor(string5);
            if (string3.length() == 0) {
                string3 = string5;
            }
        }
        if (string3.length() == 0) {
            string3 = string4;
        }
        this.mVendorDisplay = string3.trim();
        this.mVendorId = string4.trim();
        if (string2.length() == 0) {
            string2 = this.getPrettyName();
        }
        this.mDisplayName = string2.trim();
        this.mMinApiLevel = XmlParserUtils.getXmlInt(node, "min-api-level", 0);
        this.mProjectFiles = this.parseProjectFiles(XmlParserUtils.getFirstChild(node, "project-files"));
        this.mOldPaths = XmlParserUtils.getXmlString(node, "old-paths");
    }

    private String[] parseProjectFiles(Node node) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (node != null) {
            String string = node.getNamespaceURI();
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                String string2;
                if (node2.getNodeType() != 1 || !string.equals(node2.getNamespaceURI()) || !"path".equals(node2.getLocalName()) || (string2 = node2.getTextContent()) == null || (string2 = string2.trim()).length() <= 0) continue;
                arrayList.add(string2);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static Package create(SdkSource sdkSource, Properties properties, String string, String string2, int n, String string3, String string4, String string5, Archive.Os os, Archive.Arch arch, String string6) {
        ExtraPackage extraPackage = new ExtraPackage(sdkSource, properties, string, string2, n, string3, string4, string5, os, arch, string6);
        return extraPackage;
    }

    protected ExtraPackage(SdkSource sdkSource, Properties properties, String string, String string2, int n, String string3, String string4, String string5, Archive.Os os, Archive.Arch arch, String string6) {
        super(sdkSource, properties, n, string3, string4, string5, os, arch, string6);
        String string7;
        String string8;
        this.mPath = string2 != null ? string2 : ExtraPackage.getProperty(properties, "Extra.Path", string2);
        String string9 = ExtraPackage.getProperty(properties, "Extra.NameDisplay", "");
        String string10 = ExtraPackage.getProperty(properties, "Extra.VendorDisplay", "");
        String string11 = string8 = string != null ? string : ExtraPackage.getProperty(properties, "Extra.VendorId", "");
        if (string8.length() == 0) {
            string7 = ExtraPackage.getProperty(properties, "Extra.Vendor", "");
            string8 = this.sanitizeLegacyVendor(string7);
            if (string10.length() == 0) {
                string10 = string7;
            }
        }
        if (string10.length() == 0) {
            string10 = string8;
        }
        this.mVendorDisplay = string10.trim();
        this.mVendorId = string8.trim();
        if (string9.length() == 0) {
            string9 = this.getPrettyName();
        }
        this.mDisplayName = string9.trim();
        this.mOldPaths = ExtraPackage.getProperty(properties, "Extra.OldPaths", null);
        this.mMinApiLevel = Integer.parseInt(ExtraPackage.getProperty(properties, "Extra.MinApiLevel", Integer.toString(0)));
        string7 = ExtraPackage.getProperty(properties, "Extra.ProjectFiles", null);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string7 != null && string7.length() > 0) {
            for (String string12 : string7.split(Pattern.quote(File.pathSeparator))) {
                if ((string12 = string12.trim()).length() <= 0) continue;
                arrayList.add(string12);
            }
        }
        this.mProjectFiles = arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    void saveProperties(Properties properties) {
        super.saveProperties(properties);
        properties.setProperty("Extra.Path", this.mPath);
        properties.setProperty("Extra.NameDisplay", this.mDisplayName);
        properties.setProperty("Extra.VendorDisplay", this.mVendorDisplay);
        properties.setProperty("Extra.VendorId", this.mVendorId);
        if (this.getMinApiLevel() != 0) {
            properties.setProperty("Extra.MinApiLevel", Integer.toString(this.getMinApiLevel()));
        }
        if (this.mProjectFiles.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.mProjectFiles.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(File.pathSeparatorChar);
                }
                stringBuilder.append(this.mProjectFiles[i]);
            }
            properties.setProperty("Extra.ProjectFiles", stringBuilder.toString());
        }
        if (this.mOldPaths != null && this.mOldPaths.length() > 0) {
            properties.setProperty("Extra.OldPaths", this.mOldPaths);
        }
    }

    @Override
    public int getMinApiLevel() {
        return this.mMinApiLevel;
    }

    public String[] getProjectFiles() {
        return this.mProjectFiles;
    }

    public String[] getOldPaths() {
        if (this.mOldPaths == null || this.mOldPaths.length() == 0) {
            return new String[0];
        }
        return this.mOldPaths.split(";");
    }

    public String getPath() {
        String string = this.mPath.replaceAll("[^a-zA-Z0-9-]+", "_");
        if (string.length() == 0 || string.equals("_")) {
            int n = string.hashCode();
            string = String.format("extra%08x", n);
        }
        return string;
    }

    public String getVendorId() {
        return this.mVendorId;
    }

    public String getVendorDisplay() {
        return this.mVendorDisplay;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    private String sanitizeLegacyVendor(String string) {
        if (string != null && string.length() > 0) {
            String string2 = string.trim();
            if ((string2 = string2.replaceAll("[^a-zA-Z0-9-]+", "_")).equals("_")) {
                int n = string2.hashCode();
                string2 = String.format("vendor%08x", n);
            }
            return string2;
        }
        return "";
    }

    private String getPrettyName() {
        String string = this.mPath;
        if (this.mVendorDisplay != null && this.mVendorDisplay.length() > 0 && string.startsWith(this.mVendorDisplay + "-")) {
            string = string.substring(this.mVendorDisplay.length() + 1);
        }
        if (string != null) {
            string = string.replaceAll("[ _\t\f-]+", " ").trim();
        }
        if (string == null || string.length() == 0) {
            string = "Unknown Extra";
        }
        if (this.mVendorDisplay != null && this.mVendorDisplay.length() > 0) {
            string = this.mVendorDisplay + " " + string;
            string = string.replaceAll("[ _\t\f-]+", " ").trim();
        }
        boolean bl = false;
        char[] cArray = string.toCharArray();
        int n = cArray.length - 1;
        for (int i = 0; i < n; ++i) {
            if (!Character.isLowerCase(cArray[i]) || i != 0 && cArray[i - 1] != ' ') continue;
            cArray[i] = Character.toUpperCase(cArray[i]);
            bl = true;
        }
        if (bl) {
            string = new String(cArray);
        }
        string = string.replaceAll(" Usb ", " USB ");
        string = string.replaceAll(" Api ", " API ");
        return string;
    }

    @Override
    public String installId() {
        return String.format("extra-%1$s-%2$s", this.getVendorId(), this.getPath());
    }

    @Override
    public String getListDescription() {
        String string = String.format("%1$s%2$s", this.getDisplayName(), this.isObsolete() ? " (Obsolete)" : "");
        return string;
    }

    @Override
    public String getShortDescription() {
        String string = String.format("%1$s, revision %2$d%3$s", this.getDisplayName(), this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
        return string;
    }

    @Override
    public String getLongDescription() {
        File file;
        String string = String.format("%1$s, revision %2$d%3$s\nBy %4$s", this.getDisplayName(), this.getRevision(), this.isObsolete() ? " (Obsolete)" : "", this.getVendorDisplay());
        String string2 = this.getDescription();
        if (string2 != null && string2.length() > 0) {
            string = string + '\n' + string2;
        }
        if (this.getMinToolsRevision() != 0) {
            string = string + String.format("\nRequires tools revision %1$d", this.getMinToolsRevision());
        }
        if (this.getMinApiLevel() != 0) {
            string = string + String.format("\nRequires SDK Platform Android API %1$s", this.getMinApiLevel());
        }
        string = (file = this.getLocalArchivePath()) != null ? string + String.format("\nLocation: %1$s", file.getAbsolutePath()) : string + String.format("\nInstall path: %1$s", this.getInstallSubFolder(null).getPath());
        return string;
    }

    @Override
    public File getInstallFolder(String string, SdkManager sdkManager) {
        Package[] packageArray;
        LocalSdkParser localSdkParser = new LocalSdkParser();
        for (Package package_ : packageArray = localSdkParser.parseSdk(string, sdkManager, 1024, new NullTaskMonitor(new NullSdkLog()))) {
            File file;
            if (!this.sameItemAs(package_) || !(package_ instanceof ExtraPackage) || (file = ((ExtraPackage)package_).getLocalArchivePath()) == null) continue;
            return file;
        }
        return this.getInstallSubFolder(string);
    }

    private File getInstallSubFolder(String string) {
        String string2;
        File file = new File(string, "extras");
        String string3 = this.getVendorId();
        if (string3 != null && string3.length() > 0) {
            file = new File(file, string3);
        }
        if ((string2 = this.getPath()) != null && string2.length() > 0) {
            file = new File(file, string2);
        }
        return file;
    }

    @Override
    public boolean sameItemAs(Package package_) {
        if (package_ instanceof ExtraPackage) {
            ExtraPackage extraPackage = (ExtraPackage)package_;
            String[] stringArray = extraPackage.getOldPaths();
            int n = stringArray.length;
            for (int i = -1; i < n; ++i) {
                if (!ExtraPackage.sameVendorAndPath(this.mVendorId, this.mPath, extraPackage.mVendorId, i < 0 ? extraPackage.mPath : stringArray[i])) continue;
                return true;
            }
            String[] stringArray2 = this.getOldPaths();
            int n2 = stringArray2.length;
            for (int i = -1; i < n2; ++i) {
                if (!ExtraPackage.sameVendorAndPath(this.mVendorId, i < 0 ? this.mPath : stringArray2[i], extraPackage.mVendorId, extraPackage.mPath)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean sameVendorAndPath(String string, String string2, String string3, String string4) {
        if (string4 != null && string2 != null && string != null && string4.equals(string + '-' + string2) && (string3 == null || string3.length() == 0 || string3.equals(string))) {
            return true;
        }
        if (string2 != null && string4 != null && string3 != null && string2.equals(string3 + '-' + string4) && (string == null || string.length() == 0 || string.equals(string3))) {
            return true;
        }
        return string2 != null && string2.equals(string4) && (string == null && string3 == null || string != null && string.equals(string3));
    }

    @Override
    protected String comparisonKey() {
        String string = super.comparisonKey();
        int n = string.indexOf("|r:");
        assert (n > 0);
        string = string.substring(0, n) + "|ve:" + this.getVendorId() + "|pa:" + this.getPath() + string.substring(n);
        return string;
    }

    private File getLocalArchivePath() {
        File file;
        Archive[] archiveArray = this.getArchives();
        if (archiveArray.length == 1 && archiveArray[0].isLocal() && (file = new File(archiveArray[0].getLocalOsPath())).isDirectory()) {
            return file;
        }
        return null;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.mMinApiLevel;
        n = 31 * n + (this.mPath == null ? 0 : this.mPath.hashCode());
        n = 31 * n + Arrays.hashCode(this.mProjectFiles);
        n = 31 * n + (this.mVendorDisplay == null ? 0 : this.mVendorDisplay.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof ExtraPackage)) {
            return false;
        }
        ExtraPackage extraPackage = (ExtraPackage)object;
        if (this.mMinApiLevel != extraPackage.mMinApiLevel) {
            return false;
        }
        if (this.mPath == null ? extraPackage.mPath != null : !this.mPath.equals(extraPackage.mPath)) {
            return false;
        }
        if (!Arrays.equals(this.mProjectFiles, extraPackage.mProjectFiles)) {
            return false;
        }
        return !(this.mVendorDisplay == null ? extraPackage.mVendorDisplay != null : !this.mVendorDisplay.equals(extraPackage.mVendorDisplay));
    }
}

