/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.Onboarder;
import com.crashlytics.tools.android.onboard.WorkspaceChange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChainedOnboarder
implements Onboarder {
    private final List<Onboarder> _onboarders;

    public ChainedOnboarder(List<Onboarder> onboarders) {
        this._onboarders = onboarders;
    }

    public ChainedOnboarder(Onboarder ... onboarders) {
        this(Arrays.asList(onboarders));
    }

    @Override
    public List<CodeChange> getCodeChanges() throws OnboardException {
        ArrayList<CodeChange> changes = new ArrayList<CodeChange>();
        for (Onboarder o : this._onboarders) {
            changes.addAll(o.getCodeChanges());
        }
        return changes;
    }

    @Override
    public List<CodeChange> getCodeChangeDirections() throws OnboardException {
        ArrayList<CodeChange> changes = new ArrayList<CodeChange>();
        for (Onboarder o : this._onboarders) {
            changes.addAll(o.getCodeChangeDirections());
        }
        return changes;
    }

    @Override
    public List<WorkspaceChange> getWorkspaceChanges() {
        ArrayList<WorkspaceChange> changes = new ArrayList<WorkspaceChange>();
        for (Onboarder o : this._onboarders) {
            changes.addAll(o.getWorkspaceChanges());
        }
        return changes;
    }
}

