/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.EmptyOnboarder;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.StubCode;
import com.crashlytics.tools.android.project.ManifestData;
import com.crashlytics.tools.utils.FileUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class ClassOnboarder
extends EmptyOnboarder {
    @Override
    public abstract List<CodeChange> getCodeChanges() throws OnboardException;

    @Override
    public List<CodeChange> getCodeChangeDirections() {
        String content = this.getDefaultJavaActivityContents();
        if (content == null) {
            return Collections.singletonList(CodeChange.createEmptyChange("Start Activity"));
        }
        return Collections.singletonList(ClassOnboarder.createDefaultJavaChanges("Start Activity", content));
    }

    public String getDefaultJavaActivityContents() {
        InputStream manifestStream = ClassOnboarder.class.getClassLoader().getResourceAsStream("examples/MainActivity.java.txt");
        String content = FileUtils.streamToString(manifestStream);
        return content;
    }

    public static CodeChange createDefaultJavaChanges(String panelName, String javaContents) {
        LinkedList<CodeChange.BlockChange> changes = new LinkedList<CodeChange.BlockChange>();
        String importSearchContent = "import android.app.Activity;";
        int importOffset = javaContents.indexOf(importSearchContent) + importSearchContent.length() + 1;
        changes.add(new CodeChange.Insertion(importOffset, "import com.crashlytics.android.Crashlytics;\n"));
        String startSearchContent = "super.onCreate(savedInstanceState);";
        int startOffset = javaContents.indexOf(startSearchContent) + startSearchContent.length() + 1;
        changes.add(new CodeChange.Insertion(startOffset, "    Crashlytics.start(this);\n\n"));
        return new CodeChange(panelName, new StubCode(javaContents), changes);
    }

    protected static String getStartClassName(ManifestData data) {
        String startClass = data.getMainActivity();
        if (startClass == null) {
            startClass = data.getApplicationClass();
        }
        return startClass;
    }
}

