/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.tools.android.onboard.KitClass;
import com.crashlytics.tools.utils.GradleUtils;

public class Kit {
    private final String _groupId;
    private final String _artifactId;
    private final String _version;
    private final String _prettyName;
    private final String _description;
    private final KitClass _kitClass;
    private final boolean _isAar;
    private final Optional<String> _imagePath;
    private final Optional<String> _learnMoreUrl;

    public static Kit createLegacyKit(String groupId, String artifactId, String version, KitClass kitClass, String prettyName) {
        return new Kit(groupId, artifactId, version, prettyName, null, kitClass, Optional.<String>absent(), Optional.<String>absent(), false);
    }

    public Kit(String groupId, String artifactId, String version, String prettyName, String description, KitClass kitClass, Optional<String> imagePath, Optional<String> learnMoreUrl, boolean isAar) {
        this._groupId = groupId;
        this._artifactId = artifactId;
        this._version = version;
        this._prettyName = prettyName;
        this._description = description;
        this._kitClass = kitClass;
        this._imagePath = imagePath;
        this._learnMoreUrl = learnMoreUrl;
        this._isAar = isAar;
    }

    public String getGroupId() {
        return this._groupId;
    }

    public String getArtifactId() {
        return this._artifactId;
    }

    public String getVersion() {
        return this._version;
    }

    public String getPrettyName() {
        return this._prettyName;
    }

    public String getDescription() {
        return this._description;
    }

    public Optional<String> getImagePath() {
        return this._imagePath;
    }

    public Optional<String> getLearnMoreUrl() {
        return this._learnMoreUrl;
    }

    public KitClass getKitClass() {
        return this._kitClass;
    }

    public String getGradleDependencyString(String lineSeparator) {
        return Kit.wrap(this.getBareGradleDependencyString(), lineSeparator, this._isAar);
    }

    private static String wrap(String bareGradleDependencyString, String lineSeparator, boolean isAar) {
        return !isAar ? "compile '" + bareGradleDependencyString + "'" : "compile('" + bareGradleDependencyString + "') {" + lineSeparator + GradleUtils.getTabs(1) + "transitive = true;" + lineSeparator + "}";
    }

    public String getBareGradleDependencyString() {
        return this._groupId + ":" + this._artifactId + ":" + this._version + (this._isAar ? "@aar" : "");
    }

    public boolean isSameArtifact(Kit other) {
        return this.getArtifactId().equals(other.getArtifactId()) && this.getGroupId().equals(other.getGroupId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Kit)) {
            return false;
        }
        Kit kit = (Kit)o;
        return this._artifactId.equals(kit._artifactId) && this._groupId.equals(kit._groupId) && this._version.equals(kit._version);
    }

    public int hashCode() {
        int result = this._groupId.hashCode();
        result = 31 * result + this._artifactId.hashCode();
        result = 31 * result + this._version.hashCode();
        return result;
    }
}

