/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.reloc.com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;

public class AndroidProjectStructure {
    public static String EXISTS = "Exists";
    public static String DOES_NOT_EXIST = "Doesn't Exist";
    private final File _projectRootDir;
    private final File _manifestFile;
    private final File _resDir;
    private final File _assetsDir;
    private final File _dataPath;
    private final File _propertyFile;
    private final Optional<File> _mainLayoutFile;

    public AndroidProjectStructure(File projectRootDir, File manifestFile, File resDir, File assetsDir, File dataPath, File propertyFile, Optional<File> mainLayoutFile) {
        this._projectRootDir = projectRootDir;
        this._manifestFile = manifestFile;
        this._resDir = resDir;
        this._assetsDir = assetsDir;
        this._dataPath = dataPath;
        this._propertyFile = propertyFile;
        this._mainLayoutFile = mainLayoutFile;
    }

    public File getManifestFile() {
        return this._manifestFile;
    }

    public Optional<File> getMainLayoutFile() {
        return this._mainLayoutFile;
    }

    public File getProjectRootDir() {
        return this._projectRootDir;
    }

    public File getResourceDir() {
        return this._resDir;
    }

    public File getAssetsDir() {
        return this._assetsDir;
    }

    public boolean allExists() {
        return this._projectRootDir.exists() && this._manifestFile.exists() && this._resDir.exists();
    }

    public String toString() {
        return String.format("Root: %s (%s), Manifest: %s (%s), Res: %s (%s), Assets: %s (%s), Data: %s (%s)", this._projectRootDir, this.existsString(this._projectRootDir.exists()), this._manifestFile, this.existsString(this._manifestFile.exists()), this._resDir, this.existsString(this._resDir.exists()), this._assetsDir, this.existsString(this._assetsDir.exists()), this._dataPath, this.existsString(this._dataPath.exists()));
    }

    public String existsString(boolean exists) {
        return exists ? EXISTS : DOES_NOT_EXIST;
    }

    public File getProjectDataPath() throws IOException {
        return this._dataPath;
    }

    public File getPropertyFile() {
        return this._propertyFile;
    }
}

