/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.BuildIdManager;
import com.crashlytics.tools.android.project.DeobfuscationManager;
import com.crashlytics.tools.android.project.DeobsMetadata;
import com.crashlytics.tools.utils.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class DataDirDeobsManager
implements DeobfuscationManager {
    static final String OBFUSCATOR_ID_PROGUARD = "proguard";
    private final File _deobsPath;
    private final File _deobsStoragePath;
    private final BuildIdManager _buildIDManager;
    private final File _manifestFile;
    protected static final FilenameFilter DEOBS_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".zip");
        }
    };

    public DataDirDeobsManager(AndroidProject project, BuildIdManager buildIdManager) {
        this(buildIdManager, project.getManifestFile(), new File(project.getDataDirectory(), "deobs"), new File(project.getDataDirectory(), "deobs_uploaded"));
    }

    public DataDirDeobsManager(BuildIdManager buildIdManager, File manifestFile, File deobsPath, File deobsStoragePath) {
        this._buildIDManager = buildIdManager;
        this._manifestFile = manifestFile;
        this._deobsPath = deobsPath;
        this._deobsStoragePath = deobsStoragePath;
    }

    @Override
    public void storeDeobfuscationFile(File deobsFile, String obfuscatorId, String obfuscatorVersion) throws IOException {
        if (!deobsFile.isFile()) {
            throw new IllegalArgumentException("Invalid deobfuscation file: " + deobsFile);
        }
        FileUtils.verifyDirectory(this._deobsPath);
        UUID buildId = this._buildIDManager.getBuildId();
        File cachedDeobsFile = new File(this._deobsPath, buildId.toString() + ".zip");
        if (cachedDeobsFile.exists()) {
            DeveloperTools.logI("Crashlytics has already stored this deobs file.");
            return;
        }
        if (deobsFile.getName().equals("mapping.txt")) {
            DeveloperTools.logD("Crashlytics is caching deobs file at " + cachedDeobsFile);
            FileUtils.zip(deobsFile, cachedDeobsFile, false);
        } else {
            File deobsFileCopy = new File(this._deobsPath, "mapping.txt");
            DeveloperTools.logI("Crashlytics is caching deobs file at " + cachedDeobsFile + " via copying " + deobsFile + " to " + deobsFileCopy);
            FileUtils.copyFile(deobsFile, deobsFileCopy);
            FileUtils.zip(deobsFileCopy, cachedDeobsFile, false);
            deobsFileCopy.delete();
        }
        DeobsMetadata deobs = new DeobsMetadata(buildId.toString(), this._manifestFile);
        deobs.setObfuscatorId(obfuscatorId);
        File deobsDataFile = new File(this._deobsPath, buildId.toString() + ".meta");
        deobs.store(deobsDataFile);
    }

    @Override
    public boolean hasCachedDeobfuscationFiles() {
        return this._deobsPath.exists() && this._deobsPath.list(DEOBS_FILTER).length > 0;
    }

    @Override
    public List<File> getDeobfuscationFiles() throws IOException {
        if (!this._deobsPath.exists()) {
            return Collections.emptyList();
        }
        FileUtils.verifyDirectory(this._deobsPath);
        LinkedList<File> deobsFiles = new LinkedList<File>();
        for (String deobsFileName : this._deobsPath.list(DEOBS_FILTER)) {
            deobsFiles.add(new File(this._deobsPath, deobsFileName));
        }
        return deobsFiles;
    }

    @Override
    public File getDeobfuscationDirectory() {
        return this._deobsPath;
    }

    @Override
    public File getDeobfuscationStorageDirectory() {
        return this._deobsStoragePath;
    }
}

