/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils;

import com.crashlytics.tools.android.DeveloperTools;
import java.io.File;
import java.util.Comparator;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarUtils {
    private static final String VERSION_ATTRIBUTE = "Specification-Version";
    public static final Comparator<String> VERSION_STRING_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String v1, String v2) {
            String[] v1parts = v1.split("\\.", 4);
            String[] v2parts = v2.split("\\.", 4);
            for (int i = 0; i < 3; ++i) {
                int v2x;
                int v1x = Integer.parseInt(v1parts[i]);
                if (v1x < (v2x = Integer.parseInt(v2parts[i]))) {
                    return -1;
                }
                if (v1x <= v2x) continue;
                return 1;
            }
            String v1q = v1parts.length > 3 ? v1parts[3] : "";
            String v2q = v2parts.length > 3 ? v2parts[3] : "";
            return v1q.compareTo(v2q);
        }
    };

    public static final Comparator<Manifest> getVersionComparator(final String attributeKey) {
        return new Comparator<Manifest>(){

            @Override
            public int compare(Manifest m1, Manifest m2) {
                return VERSION_STRING_COMPARATOR.compare(JarUtils.getVersion(m1, attributeKey), JarUtils.getVersion(m2, attributeKey));
            }
        };
    }

    public static String getVersion(Manifest manifest, String attributesKey) {
        Attributes attrs = manifest.getAttributes(attributesKey);
        if (attrs != null) {
            return attrs.getValue(VERSION_ATTRIBUTE);
        }
        return null;
    }

    public static String extractManifestVersion(File jarFile, String attributesKey) {
        String thisVersion = null;
        if (jarFile != null && jarFile.exists()) {
            try {
                thisVersion = JarUtils.getVersion(new JarFile(jarFile).getManifest(), attributesKey);
            }
            catch (Exception e) {
                DeveloperTools.logW("Exception while retrieving version from " + jarFile + ".", e);
                thisVersion = null;
            }
        }
        return thisVersion;
    }

    public static Manifest getMaybeManifest(File jarFile) {
        try {
            if (jarFile.exists()) {
                return new JarFile(jarFile).getManifest();
            }
        }
        catch (Exception e) {
            DeveloperTools.logW("Could not read manifest from " + jarFile, e);
        }
        return null;
    }
}

