/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics;

import com.crashlytics.AbstractCrashlyticsMojo;
import com.crashlytics.DeveloperToolsUtils;
import com.crashlytics.MojoLogger;
import com.crashlytics.reloc.com.google.common.base.Strings;
import com.crashlytics.tools.android.DeveloperTools;
import java.io.File;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@org.apache.maven.plugins.annotations.Mojo(name="UploadDistribution")
public class CrashlyticsUploadDistributionMojo
extends AbstractCrashlyticsMojo {
    private static final String APK = ".apk";
    @Parameter
    private String projectPath;
    @Parameter
    private String androidResPath;
    @Parameter
    private String androidAssetsPath;
    @Parameter
    private String androidManifestPath;
    @Parameter(defaultValue="crashlytics.properties", alias="properties_path")
    private String propertiesPath;
    @Parameter
    private String betaDistributionEmailsFilePath;
    @Parameter
    private String betaDistributionGroupAliasesFilePath;
    @Parameter
    private String betaDistributionReleaseNotesFilePath;
    @Parameter
    private String betaDistributionEmails;
    @Parameter
    private String betaDistributionGroupAliases;
    @Parameter
    private String betaDistributionReleaseNotes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String apkFileName = this.getApkFileName();
        String renamedPackage = this.getRenamedPackage();
        this.getLog().info((CharSequence)"Crashlytics - UploadDistribution");
        this.getLog().info((CharSequence)("Uploading " + apkFileName + " to Crashlytics..."));
        if (!Strings.isNullOrEmpty(this.betaDistributionEmails)) {
            this.getLog().info((CharSequence)("betaDistributionEmails: " + this.betaDistributionEmails));
        }
        if (!Strings.isNullOrEmpty(this.betaDistributionGroupAliases)) {
            this.getLog().info((CharSequence)("betaDistributionGroupAliases: " + this.betaDistributionGroupAliases));
        }
        if (!Strings.isNullOrEmpty(this.betaDistributionReleaseNotes)) {
            this.getLog().info((CharSequence)("betaDistributionReleaseNotes: " + this.betaDistributionReleaseNotes));
        }
        if (!Strings.isNullOrEmpty(this.betaDistributionEmailsFilePath)) {
            this.getLog().info((CharSequence)("betaDistributionEmailsFilePath: " + this.betaDistributionEmailsFilePath));
        }
        if (!Strings.isNullOrEmpty(this.betaDistributionGroupAliasesFilePath)) {
            this.getLog().info((CharSequence)("betaDistributionGroupAliasesFilePath: " + this.betaDistributionGroupAliasesFilePath));
        }
        if (!Strings.isNullOrEmpty(this.betaDistributionReleaseNotesFilePath)) {
            this.getLog().info((CharSequence)("betaDistributionReleaseNotesFilePath: " + this.betaDistributionReleaseNotesFilePath));
        }
        this.getLog().debug((CharSequence)("projectPath: " + this.projectPath));
        if (this.projectPath == null) {
            this.projectPath = this.getDefaultProjectPath();
            this.getLog().debug((CharSequence)("projectPath set to Maven project basedir: " + this.projectPath));
        }
        this.getLog().debug((CharSequence)("androidResPath: " + this.androidResPath));
        this.getLog().debug((CharSequence)("androidAssetsPath: " + this.androidAssetsPath));
        this.getLog().debug((CharSequence)("androidManifestPath: " + this.androidManifestPath));
        this.getLog().debug((CharSequence)("propertiesPath: " + this.propertiesPath));
        this.getLog().debug((CharSequence)("renamedPackage: " + renamedPackage));
        DeveloperTools.setLogger(new MojoLogger((Mojo)this));
        new DeveloperToolsUtils.Builder().setProjectPath(this.projectPath).setAndroidResPath(this.androidResPath).setAndroidAssetsPath(this.androidAssetsPath).setAndroidManifestPath(this.androidManifestPath).setPropertiesPath(this.propertiesPath).setRenamedPackage(renamedPackage).setApkFilePath(apkFileName).setBetaDistributionEmails(this.betaDistributionEmails).setBetaDistributionGroupAliases(this.betaDistributionGroupAliases).setBetaDistributionReleaseNotes(this.betaDistributionReleaseNotes).setBetaDistributionEmailsFilePath(this.betaDistributionEmailsFilePath).setBetaDistributionGroupAliasesFilePath(this.betaDistributionGroupAliasesFilePath).setBetaDistributionReleaseNotesFilePath(this.betaDistributionReleaseNotesFilePath).build().uploadDistribution();
    }

    private String getApkFileName() {
        MavenProject project = this.getMavenProject();
        File apkFile = new File(project.getBuild().getDirectory(), project.getBuild().getFinalName() + APK);
        return apkFile.getAbsolutePath();
    }
}

