/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.ota;

import com.crashlytics.api.ota.Person;
import com.crashlytics.api.ota.PersonGroup;
import com.crashlytics.api.ota.ReleaseSummary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Release {
    public final ReleaseSummary summary;
    public final List<String> authorizedDevices;
    public final List<Person> people;
    public final List<PersonGroup> groups;

    public Release(ReleaseSummary summary, List<String> authorizedDevices, List<Person> entries, List<PersonGroup> groups) {
        this.summary = summary;
        this.authorizedDevices = Collections.unmodifiableList(new ArrayList<String>(authorizedDevices));
        this.people = Collections.unmodifiableList(new ArrayList<Person>(entries));
        this.groups = Collections.unmodifiableList(new ArrayList<PersonGroup>(groups));
    }

    public long getPeopleCount() {
        return this.summary.getPeopleCount();
    }

    public long getAcceptedCount() {
        long count = 0L;
        for (Person p : this.people) {
            if (!p.isStatusAccepted()) continue;
            ++count;
        }
        return count + this.getInstalledCount();
    }

    public long getInstalledCount() {
        return this.summary.testerWithInstallCount;
    }
}

