/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.io;

import com.crashlytics.reloc.com.android.io.FileWrapper;
import com.crashlytics.reloc.com.android.io.IAbstractFile;
import com.crashlytics.reloc.com.android.io.IAbstractFolder;
import com.crashlytics.reloc.com.android.io.IAbstractResource;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;

public class FolderWrapper
extends File
implements IAbstractFolder {
    private static final long serialVersionUID = 1L;

    public FolderWrapper(File file, String string) {
        super(file, string);
    }

    public FolderWrapper(String string) {
        super(string);
    }

    public FolderWrapper(String string, String string2) {
        super(string, string2);
    }

    public FolderWrapper(URI uRI) {
        super(uRI);
    }

    public FolderWrapper(File file) {
        super(file.getAbsolutePath());
    }

    public IAbstractResource[] listMembers() {
        File[] fileArray = this.listFiles();
        int n = fileArray == null ? 0 : fileArray.length;
        IAbstractResource[] iAbstractResourceArray = new IAbstractResource[n];
        if (fileArray != null) {
            for (int i = 0; i < n; ++i) {
                File file = fileArray[i];
                if (file.isFile()) {
                    iAbstractResourceArray[i] = new FileWrapper(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                iAbstractResourceArray[i] = new FolderWrapper(file);
            }
        }
        return iAbstractResourceArray;
    }

    public boolean hasFile(final String string) {
        String[] stringArray = this.list(new IAbstractFolder.FilenameFilter(){

            public boolean accept(IAbstractFolder iAbstractFolder, String string2) {
                return string.equals(string2);
            }
        });
        return stringArray.length > 0;
    }

    public IAbstractFile getFile(String string) {
        return new FileWrapper(this, string);
    }

    public IAbstractFolder getFolder(String string) {
        return new FolderWrapper(this, string);
    }

    public IAbstractFolder getParentFolder() {
        String string = this.getParent();
        if (string == null) {
            return null;
        }
        return new FolderWrapper(string);
    }

    public String getOsLocation() {
        return this.getAbsolutePath();
    }

    public boolean exists() {
        return this.isDirectory();
    }

    public String[] list(IAbstractFolder.FilenameFilter filenameFilter) {
        File[] fileArray = this.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (File file : fileArray) {
                if (!filenameFilter.accept(this, file.getName())) continue;
                arrayList.add(file.getName());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return new String[0];
    }
}

