/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.resources;

import com.crashlytics.reloc.com.android.resources.ResourceFolderType;
import com.crashlytics.reloc.com.android.resources.ResourceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FolderTypeRelationship {
    private static final Map<ResourceType, List<ResourceFolderType>> mTypeToFolderMap = new HashMap<ResourceType, List<ResourceFolderType>>();
    private static final Map<ResourceFolderType, List<ResourceType>> mFolderToTypeMap = new HashMap<ResourceFolderType, List<ResourceType>>();

    public static List<ResourceType> getRelatedResourceTypes(ResourceFolderType resourceFolderType) {
        List<ResourceType> list = mFolderToTypeMap.get((Object)resourceFolderType);
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public static List<ResourceFolderType> getRelatedFolders(ResourceType resourceType) {
        List<ResourceFolderType> list = mTypeToFolderMap.get((Object)resourceType);
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public static boolean match(ResourceType resourceType, ResourceFolderType resourceFolderType) {
        List<ResourceFolderType> list = mTypeToFolderMap.get((Object)resourceType);
        if (list != null) {
            return list.contains((Object)resourceFolderType);
        }
        return false;
    }

    private static void add(ResourceType resourceType, ResourceFolderType resourceFolderType) {
        List<ResourceType> list;
        List<ResourceFolderType> list2 = mTypeToFolderMap.get((Object)resourceType);
        if (list2 == null) {
            list2 = new ArrayList<ResourceFolderType>();
            mTypeToFolderMap.put(resourceType, list2);
        }
        if (list2.indexOf((Object)resourceFolderType) == -1) {
            list2.add(resourceFolderType);
        }
        if ((list = mFolderToTypeMap.get((Object)resourceFolderType)) == null) {
            list = new ArrayList<ResourceType>();
            mFolderToTypeMap.put(resourceFolderType, list);
        }
        if (list.indexOf((Object)resourceType) == -1) {
            list.add(resourceType);
        }
    }

    private static void makeSafe() {
        List<Enum> list;
        for (ResourceType enum_ : ResourceType.values()) {
            list = mTypeToFolderMap.get((Object)enum_);
            if (list == null) continue;
            mTypeToFolderMap.put(enum_, Collections.unmodifiableList(list));
        }
        for (Enum enum_ : ResourceFolderType.values()) {
            list = mFolderToTypeMap.get(enum_);
            if (list == null) continue;
            mFolderToTypeMap.put((ResourceFolderType)enum_, Collections.unmodifiableList(list));
        }
    }

    static {
        FolderTypeRelationship.add(ResourceType.ANIM, ResourceFolderType.ANIM);
        FolderTypeRelationship.add(ResourceType.ANIMATOR, ResourceFolderType.ANIMATOR);
        FolderTypeRelationship.add(ResourceType.ARRAY, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.ATTR, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.BOOL, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.COLOR, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.COLOR, ResourceFolderType.COLOR);
        FolderTypeRelationship.add(ResourceType.DECLARE_STYLEABLE, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.DIMEN, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.DRAWABLE, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.DRAWABLE, ResourceFolderType.DRAWABLE);
        FolderTypeRelationship.add(ResourceType.FRACTION, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.ID, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.INTEGER, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.INTERPOLATOR, ResourceFolderType.INTERPOLATOR);
        FolderTypeRelationship.add(ResourceType.LAYOUT, ResourceFolderType.LAYOUT);
        FolderTypeRelationship.add(ResourceType.ID, ResourceFolderType.LAYOUT);
        FolderTypeRelationship.add(ResourceType.MENU, ResourceFolderType.MENU);
        FolderTypeRelationship.add(ResourceType.ID, ResourceFolderType.MENU);
        FolderTypeRelationship.add(ResourceType.MIPMAP, ResourceFolderType.MIPMAP);
        FolderTypeRelationship.add(ResourceType.PLURALS, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.PUBLIC, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.RAW, ResourceFolderType.RAW);
        FolderTypeRelationship.add(ResourceType.STRING, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.STYLE, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.STYLEABLE, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.XML, ResourceFolderType.XML);
        FolderTypeRelationship.makeSafe();
    }
}

