/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.sdklib.internal.build;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sun.misc.BASE64Encoder;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

public class SignedJarBuilder {
    private static final String DIGEST_ALGORITHM = "SHA1";
    private static final String DIGEST_ATTR = "SHA1-Digest";
    private static final String DIGEST_MANIFEST_ATTR = "SHA1-Digest-Manifest";
    private JarOutputStream mOutputJar;
    private PrivateKey mKey;
    private X509Certificate mCertificate;
    private Manifest mManifest;
    private BASE64Encoder mBase64Encoder;
    private MessageDigest mMessageDigest;
    private byte[] mBuffer = new byte[4096];

    public SignedJarBuilder(OutputStream outputStream, PrivateKey privateKey, X509Certificate x509Certificate) throws IOException, NoSuchAlgorithmException {
        this.mOutputJar = new JarOutputStream(outputStream);
        this.mOutputJar.setLevel(9);
        this.mKey = privateKey;
        this.mCertificate = x509Certificate;
        if (this.mKey != null && this.mCertificate != null) {
            this.mManifest = new Manifest();
            Attributes attributes = this.mManifest.getMainAttributes();
            attributes.putValue("Manifest-Version", "1.0");
            attributes.putValue("Created-By", "1.0 (Android)");
            this.mBase64Encoder = new BASE64Encoder();
            this.mMessageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(File file, String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            JarEntry jarEntry = new JarEntry(string);
            jarEntry.setTime(file.lastModified());
            this.writeEntry(fileInputStream, jarEntry);
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeZip(InputStream inputStream, IZipEntryFilter iZipEntryFilter) throws IOException, IZipEntryFilter.ZipAbortException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string = zipEntry.getName();
                if (zipEntry.isDirectory() || string.startsWith("META-INF/") || iZipEntryFilter != null && !iZipEntryFilter.checkEntry(string)) continue;
                JarEntry jarEntry = zipEntry.getMethod() == 0 ? new JarEntry(zipEntry) : new JarEntry(string);
                this.writeEntry(zipInputStream, jarEntry);
                zipInputStream.closeEntry();
            }
        }
        finally {
            zipInputStream.close();
        }
    }

    public void close() throws IOException, GeneralSecurityException {
        if (this.mManifest != null) {
            this.mOutputJar.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
            this.mManifest.write(this.mOutputJar);
            Signature signature = Signature.getInstance("SHA1with" + this.mKey.getAlgorithm());
            signature.initSign(this.mKey);
            this.mOutputJar.putNextEntry(new JarEntry("META-INF/CERT.SF"));
            this.writeSignatureFile(new SignatureOutputStream(this.mOutputJar, signature));
            this.mOutputJar.putNextEntry(new JarEntry("META-INF/CERT." + this.mKey.getAlgorithm()));
            this.writeSignatureBlock(signature, this.mCertificate, this.mKey);
        }
        this.mOutputJar.close();
    }

    private void writeEntry(InputStream inputStream, JarEntry jarEntry) throws IOException {
        int n;
        this.mOutputJar.putNextEntry(jarEntry);
        while ((n = inputStream.read(this.mBuffer)) != -1) {
            this.mOutputJar.write(this.mBuffer, 0, n);
            if (this.mMessageDigest == null) continue;
            this.mMessageDigest.update(this.mBuffer, 0, n);
        }
        this.mOutputJar.closeEntry();
        if (this.mManifest != null) {
            Attributes attributes = this.mManifest.getAttributes(jarEntry.getName());
            if (attributes == null) {
                attributes = new Attributes();
                this.mManifest.getEntries().put(jarEntry.getName(), attributes);
            }
            attributes.putValue(DIGEST_ATTR, this.mBase64Encoder.encode(this.mMessageDigest.digest()));
        }
    }

    private void writeSignatureFile(SignatureOutputStream signatureOutputStream) throws IOException, GeneralSecurityException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Signature-Version", "1.0");
        attributes.putValue("Created-By", "1.0 (Android)");
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        PrintStream printStream = new PrintStream((OutputStream)new DigestOutputStream(new ByteArrayOutputStream(), messageDigest), true, "UTF-8");
        this.mManifest.write(printStream);
        printStream.flush();
        attributes.putValue(DIGEST_MANIFEST_ATTR, bASE64Encoder.encode(messageDigest.digest()));
        Map<String, Attributes> map = this.mManifest.getEntries();
        for (Map.Entry<String, Attributes> entry : map.entrySet()) {
            printStream.print("Name: " + entry.getKey() + "\r\n");
            for (Map.Entry<Object, Object> entry2 : entry.getValue().entrySet()) {
                printStream.print(entry2.getKey() + ": " + entry2.getValue() + "\r\n");
            }
            printStream.print("\r\n");
            printStream.flush();
            Attributes attributes2 = new Attributes();
            attributes2.putValue(DIGEST_ATTR, bASE64Encoder.encode(messageDigest.digest()));
            manifest.getEntries().put(entry.getKey(), attributes2);
        }
        manifest.write(signatureOutputStream);
        if (signatureOutputStream.size() % 1024 == 0) {
            signatureOutputStream.write(13);
            signatureOutputStream.write(10);
        }
    }

    private void writeSignatureBlock(Signature signature, X509Certificate x509Certificate, PrivateKey privateKey) throws IOException, GeneralSecurityException {
        SignerInfo signerInfo = new SignerInfo(new X500Name(x509Certificate.getIssuerX500Principal().getName()), x509Certificate.getSerialNumber(), AlgorithmId.get(DIGEST_ALGORITHM), AlgorithmId.get(privateKey.getAlgorithm()), signature.sign());
        PKCS7 pKCS7 = new PKCS7(new AlgorithmId[]{AlgorithmId.get(DIGEST_ALGORITHM)}, new ContentInfo(ContentInfo.DATA_OID, null), new X509Certificate[]{x509Certificate}, new SignerInfo[]{signerInfo});
        pKCS7.encodeSignedData(this.mOutputJar);
    }

    public static interface IZipEntryFilter {
        public boolean checkEntry(String var1) throws ZipAbortException;

        public static class ZipAbortException
        extends Exception {
            private static final long serialVersionUID = 1L;

            public ZipAbortException() {
            }

            public ZipAbortException(String string, Object ... objectArray) {
                super(String.format(string, objectArray));
            }

            public ZipAbortException(Throwable throwable, String string, Object ... objectArray) {
                super(String.format(string, objectArray), throwable);
            }

            public ZipAbortException(Throwable throwable) {
                super(throwable);
            }
        }
    }

    private static class SignatureOutputStream
    extends FilterOutputStream {
        private Signature mSignature;
        private int mCount = 0;

        public SignatureOutputStream(OutputStream outputStream, Signature signature) {
            super(outputStream);
            this.mSignature = signature;
        }

        public void write(int n) throws IOException {
            try {
                this.mSignature.update((byte)n);
            }
            catch (SignatureException signatureException) {
                throw new IOException("SignatureException: " + signatureException);
            }
            super.write(n);
            ++this.mCount;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.mSignature.update(byArray, n, n2);
            }
            catch (SignatureException signatureException) {
                throw new IOException("SignatureException: " + signatureException);
            }
            super.write(byArray, n, n2);
            this.mCount += n2;
        }

        public int size() {
            return this.mCount;
        }
    }
}

