/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.tools.utils.GradleParser;
import java.util.List;

public class AndroidGradlePropertyReader {
    private static final String[] DEFAULT_MANIFEST_PROPERTY_NAMESPACE = new String[]{"android", "sourceSets", "main", "manifest", "srcFile"};
    private static final String[] DEFAULT_RES_PROPERTY_NAMESPACE = new String[]{"android", "sourceSets", "main", "res", "srcDirs"};
    private static final String[] DEFAULT_ASSETS_PROPERTY_NAMESPACE = new String[]{"android", "sourceSets", "main", "assets", "srcDirs"};
    private static final String[] CRASHLYTICS_RES_OVERRIDE = new String[]{"crashlytics", "resPath"};
    private final GradleParser _parser;

    public AndroidGradlePropertyReader(GradleParser parser) {
        this._parser = parser;
    }

    public String getManifestPath() {
        return this._parser.getStringProperty(DEFAULT_MANIFEST_PROPERTY_NAMESPACE);
    }

    public String getResPath() {
        String overrideResPath = this._parser.getStringProperty(CRASHLYTICS_RES_OVERRIDE);
        if (overrideResPath == null) {
            List<String> resPath = this._parser.getStringListProperty(DEFAULT_RES_PROPERTY_NAMESPACE);
            if (resPath == null || resPath.size() == 0) {
                return null;
            }
            return resPath.get(0);
        }
        return overrideResPath;
    }

    public String getAssetsPath() {
        List<String> assetsPath = this._parser.getStringListProperty(DEFAULT_ASSETS_PROPERTY_NAMESPACE);
        if (assetsPath == null || assetsPath.isEmpty()) {
            return null;
        }
        return assetsPath.get(assetsPath.size() - 1);
    }
}

