/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.reloc.com.google.common.collect.Sets;
import com.crashlytics.tools.android.onboard.Kit;
import com.crashlytics.tools.android.onboard.KitClass;
import com.crashlytics.tools.android.onboard.MoPubAdType;
import com.crashlytics.tools.android.onboard.Repository;
import com.crashlytics.tools.android.onboard.TwitterFeature;
import java.util.Arrays;
import java.util.List;

public class OnboardingConstants {
    public static final String TWITTERSDK_REPOSITORY_USER_PROPERTY = "TWITTERSDK_REPOSITORY_USER";
    public static final String TWITTERSDK_REPOSITORY_PASSWORD_PROPERTY = "TWITTERSDK_REPOSITORY_PASSWORD";
    public static final String TWITTERSDK_REPOSITORY_URL_PROPERTY = "TWITTERSDK_REPOSITORY_URL";
    private static final String TWITTERSDK_AUTH_USERNAME = "sdk-user";
    private static final String TWITTERSDK_AUTH_PASSWORD = "5Y|3-ViTSt*8Hxu7Jj*97zzaC6+RUK9MPw_4kqbPMfWe4Iwc^$";
    private static final String TWITTERSDK_AUTH_DEFAULT_URL = "https://android-sdk.crashlytics.com/twittersdk/repo";
    private static final String TWITTERSDK_AUTH_URL;
    public static final Repository TWITTER_SDK_REPOSITORY;
    public static final Repository TWITTER_REPOSITORY_WITH_PROPERTIES;
    public static final String SDK_PACKAGE = "com.twitter.sdk.android";
    public static final String CRASHLYTICS_PACKAGE = "com.crashlytics.android";
    public static final String MOPUB_PACKAGE = "com.mopub";
    public static final String CRASHLYTICS_FULLY_QUALIFIED = "com.crashlytics.android.Crashlytics";
    public static final String SDK_FULLY_QUALIFIED = "com.twitter.sdk.android.Sdk";
    private static final KitClass CRASHLYTICS_CLASS;
    private static final KitClass TWITTER_SOCIAL_CLASS;
    private static final KitClass TWITTER_CORE_CLASS;
    private static final KitClass MOPUB_CLASS;
    private static final String CRASHLYTICS_ID = "com.twitter.sdk.android.crashlytics";
    private static final String TWITTER_SOCIAL_ID = "com.twitter.sdk.android.twittersocial";
    private static final String TWITTER_CORE_ID = "com.twitter.sdk.android.twittercore";
    private static final String MOPUB_ID = "com.mopub.common";
    public static final Kit LEGACY_CRASHLYTICS_KIT;
    private static final String TWITTER_SDK_GROUP_ID = "com.twitter.sdk.android";
    public static final Kit CRASHLYTICS_KIT;
    public static final Kit TWITTER_CORE_KIT;
    public static final Kit TWITTER_SOCIAL_KIT;
    public static final Kit MOPUB_KIT;
    public static final List<Kit> DEFAULT_KITS;
    public static final String BUILDSCRIPT_REPOSITORY_URL = "http://download.crashlytics.com/maven";
    public static final Repository BUILDSCRIPT_REPOSITORY;
    public static final String BUILDSCRIPT_DEPENDENCY_BARE = "com.crashlytics.tools.gradle:crashlytics-gradle:";
    public static final String BUILDSCRIPT_DEPENDENCY = "classpath 'com.crashlytics.tools.gradle:crashlytics-gradle:1.+'";
    public static final String APPLY_CRASHLYTICS = "apply plugin: 'crashlytics'";
    public static final Repository CRASHLYTICS_REPOSITORY;
    public static final String EXAMPLE_SRC_PATH = "examples/";
    public static final String MANIFEST_TITLE = "AndroidManifest.xml";
    public static final String MAIN_LAYOUT_TITLE = "activity_main.xml";
    public static final String BUILD_GRADLE_TITLE = "build.gradle";
    public static final String EXAMPLE_MANIFEST_FILE_NAME = "AndroidManifest.xml.txt";
    public static final String EXAMPLE_MANIFEST_FILE = "examples/AndroidManifest.xml.txt";
    public static final String EXAMPLE_MAIN_LAYOUT_FILE_NAME = "activity_main.xml.txt";
    public static final String EXAMPLE_MAIN_LAYOUT_FILE = "examples/activity_main.xml.txt";
    public static final String JAVA_MAIN_ACTIVITY_NAME = "Start Activity";
    public static final String SRC_ACTIVITY = "MainActivity.java.txt";
    public static final String FILE_EXAMPLE_SRC_ACTIVITY = "examples/MainActivity.java.txt";
    public static final String FILE_EXAMPLE_MAIN_LAYOUT = "examples/activity_main.xml.txt";
    public static final String BUILD_GRADLE_ACTIVITY = "build.gradle.txt";
    public static final String FILE_EXAMPLE_BUILD_GRADLE_ACTIVITY = "examples/build.gradle.txt";
    public static final String PERMISSION_FORMAT = "<uses-permission android:name=\"%s\"/>";
    public static final String METADATA_ELEMENT_FORMAT = "<meta-data android:name=\"com.crashlytics.ApiKey\" android:value=\"%s\"/>";
    public static final String ACTIVITY_ELEMENT_FORMAT = "<activity android:name=\"%s\"\n%sandroid:configChanges=\"keyboardHidden|orientation\"/>";
    public static final String GRADLE_PROPERTIES_TITLE = "gradle.properties";
    public static final String KITS_PROPERTIES_TITLE = "kits.properties";

    public static boolean isCrashlyticsKit(Kit kit) {
        return kit != null && (kit.isSameArtifact(CRASHLYTICS_KIT) || kit.isSameArtifact(LEGACY_CRASHLYTICS_KIT));
    }

    public static String startClass(boolean hasKitsEnabled) {
        return hasKitsEnabled ? "Sdk" : "Crashlytics";
    }

    public static String startClassFullyQualified(boolean hasKitsEnabled) {
        return hasKitsEnabled ? SDK_FULLY_QUALIFIED : CRASHLYTICS_FULLY_QUALIFIED;
    }

    static {
        String URL_OVERRIDE = System.getProperty("crashlytics.artifactory_url");
        TWITTERSDK_AUTH_URL = URL_OVERRIDE == null ? TWITTERSDK_AUTH_DEFAULT_URL : URL_OVERRIDE;
        TWITTER_SDK_REPOSITORY = Repository.createAuthenticatedRepository(TWITTERSDK_AUTH_URL, TWITTERSDK_AUTH_USERNAME, TWITTERSDK_AUTH_PASSWORD);
        TWITTER_REPOSITORY_WITH_PROPERTIES = Repository.createAuthenticatedRepository(TWITTERSDK_REPOSITORY_URL_PROPERTY, TWITTERSDK_REPOSITORY_USER_PROPERTY, TWITTERSDK_REPOSITORY_PASSWORD_PROPERTY);
        CRASHLYTICS_CLASS = new KitClass(CRASHLYTICS_FULLY_QUALIFIED, "Crashlytics");
        TWITTER_SOCIAL_CLASS = new KitClass("com.twitter.sdk.android.twittersocial.TwitterSocial", "TwitterSocial");
        TWITTER_CORE_CLASS = new KitClass("com.twitter.sdk.android.twittercore.identity.Twitter", "Twitter");
        MOPUB_CLASS = new KitClass("com.mopub.common.MoPub", "MoPub");
        LEGACY_CRASHLYTICS_KIT = Kit.createLegacyKit(CRASHLYTICS_ID, CRASHLYTICS_PACKAGE, "crashlytics", "1.+", CRASHLYTICS_CLASS, "Crashlytics");
        CRASHLYTICS_KIT = new Kit(CRASHLYTICS_ID, "com.twitter.sdk.android", "crashlytics", "+", "Crashlytics", "The world's best crash reporting", CRASHLYTICS_CLASS, Kit.Feature.featureless(), Optional.of("resources/images/kit.crashlytics.png"), Optional.of("https://try.crashlytics.com"), Optional.of("The most powerful, yet lightest weight crash reporting solution for iOS and Android developers."), true);
        TWITTER_CORE_KIT = new Kit(TWITTER_CORE_ID, "com.twitter.sdk.android", "twittercore", "+", "Twitter Core", "Login with Twitter", TWITTER_CORE_CLASS, Kit.Feature.featureless(), Optional.<String>absent(), Optional.<String>absent(), Optional.<String>absent(), true);
        TWITTER_SOCIAL_KIT = new Kit(TWITTER_SOCIAL_ID, "com.twitter.sdk.android", "twittersocial", "+", "Twitter Social", "Embed native, interactive tweets", TWITTER_SOCIAL_CLASS, Sets.newHashSet(new Kit.Feature<TwitterFeature>(TwitterFeature.Identity), new Kit.Feature<TwitterFeature>(TwitterFeature.Syndication)), Optional.of("resources/images/kit.twitter.logo.2.png"), Optional.of("https://dev.twitter.com"), Optional.of("Drive downloads and engagement while distributing you app's content to the world."), true);
        MOPUB_KIT = new Kit(MOPUB_ID, "com.twitter.sdk.android", "mopub", "+", "MoPub", "Drive more mobile ad revenue", MOPUB_CLASS, Sets.newHashSet(new Kit.Feature<MoPubAdType>(MoPubAdType.Banner), new Kit.Feature<MoPubAdType>(MoPubAdType.Interstitial)), Optional.of("resources/images/kit.mopub.2.png"), Optional.of("https://app.mopub.com"), Optional.of("MoPub is a hosted ad serving solution built specifically for mobile publishers.<br><br>Grow your mobile advertising business with powerful ad management, optimization and reporting capabilities, and earn revenue by connecting to the world's largest mobile ad exchange."), true);
        DEFAULT_KITS = Arrays.asList(CRASHLYTICS_KIT, TWITTER_SOCIAL_KIT, MOPUB_KIT);
        CRASHLYTICS_REPOSITORY = BUILDSCRIPT_REPOSITORY = Repository.createPublicRepository(BUILDSCRIPT_REPOSITORY_URL);
    }
}

