/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.com.google.common.base.Joiner;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.StubCode;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class TwitterSyndicationCodeBlockFactory {
    public static Collection<? extends String> getImports() {
        return Arrays.asList("com.twitter.sdk.android.twittercore.TwitterAuthConfig");
    }

    public static String getOnCreateFragment(String key, String secret) {
        return "TwitterAuthConfig mAuthConfig =  new TwitterAuthConfig(\"" + key + "\", \"" + secret + "\");\n" + "TwitterSocial.getInstance().setAuthConfig(mAuthConfig);";
    }

    public static String getViewXML(String indent) {
        Joiner joiner = Joiner.on(indent);
        return joiner.join("        <ScrollView xmlns:android=\"http://schemas.android.com/apk/res/android\"", "xmlns:twittersdk=\"http://schemas.android.com/apk/res-auto\"", "android:layout_width=\"match_parent\"", "android:layout_height=\"match_parent\">", "    <LinearLayout", "    android:layout_width=\"match_parent\"", "    android:layout_height=\"wrap_content\"", "    android:orientation=\"vertical\">", "", "    <com.twitter.sdk.android.twittersocial.TweetView", "    android:id=\"@+id/photo_default_tweet\"", "    android:layout_width=\"match_parent\"", "    android:layout_height=\"wrap_content\"", "    twittersdk:tweet_id=\"266031293945503744\"", "    twittersdk:theme=\"tw__light_theme\"/>", "", "    </LinearLayout>", "</ScrollView>");
    }

    private static String createImports(Collection<? extends String> imports) {
        StringBuilder builder = new StringBuilder();
        for (String string : imports) {
            builder.append("import ");
            builder.append(string);
            builder.append(";\n");
        }
        return builder.toString();
    }

    private static CodeChange.BlockChange injectAfter(String searched, String contents, String toAdd) {
        int offset = contents.indexOf(searched);
        if (offset == -1) {
            DeveloperTools.logW("Could not find " + searched + " to add: " + toAdd, new IOException("Crashlytics failed to find item"));
            return new CodeChange.Insertion(0, toAdd);
        }
        return new CodeChange.Insertion(offset + searched.length() + 1, toAdd);
    }

    public static CodeChange getManualClassDirections(String javaFileContents, String key, String secret) {
        LinkedList<CodeChange.BlockChange> changes = new LinkedList<CodeChange.BlockChange>();
        changes.add(TwitterSyndicationCodeBlockFactory.injectAfter("import android.app.Activity;", javaFileContents, TwitterSyndicationCodeBlockFactory.createImports(TwitterSyndicationCodeBlockFactory.getImports())));
        changes.add(TwitterSyndicationCodeBlockFactory.injectAfter("setContentView(R.layout.activity_main);", javaFileContents, TwitterSyndicationCodeBlockFactory.getOnCreateFragment(key, secret)));
        return new CodeChange("View Class", new StubCode(javaFileContents), changes);
    }

    public static CodeChange getManualViewDirections(String viewFileContents) {
        String layoutElementcontent = "android:layout_height=\"wrap_content\" />";
        return new CodeChange("View XML", new StubCode(viewFileContents), Collections.singletonList(TwitterSyndicationCodeBlockFactory.injectAfter(layoutElementcontent, viewFileContents, TwitterSyndicationCodeBlockFactory.getViewXML("\n        "))));
    }
}

