/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.internal.repository.IDescription;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.io.FileOp;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Archive
implements IDescription,
Comparable<Archive> {
    private static final String PROP_OS = "Archive.Os";
    private static final String PROP_ARCH = "Archive.Arch";
    private final Os mOs;
    private final Arch mArch;
    private final String mUrl;
    private final long mSize;
    private final String mChecksum;
    private final ChecksumType mChecksumType = ChecksumType.SHA1;
    private final Package mPackage;
    private final String mLocalOsPath;
    private final boolean mIsLocal;

    Archive(Package package_, Os os, Arch arch, String string, long l, String string2) {
        this.mPackage = package_;
        this.mOs = os;
        this.mArch = arch;
        this.mUrl = string == null ? null : string.trim();
        this.mLocalOsPath = null;
        this.mSize = l;
        this.mChecksum = string2;
        this.mIsLocal = false;
    }

    protected Archive(Package package_, Properties properties, Os os, Arch arch, String string) {
        this.mPackage = package_;
        this.mOs = properties == null ? os : Os.valueOf(properties.getProperty(PROP_OS, os.toString()));
        this.mArch = properties == null ? arch : Arch.valueOf(properties.getProperty(PROP_ARCH, arch.toString()));
        this.mUrl = null;
        this.mLocalOsPath = string;
        this.mSize = 0L;
        this.mChecksum = "";
        this.mIsLocal = string != null;
    }

    void saveProperties(Properties properties) {
        properties.setProperty(PROP_OS, this.mOs.toString());
        properties.setProperty(PROP_ARCH, this.mArch.toString());
    }

    public boolean isLocal() {
        return this.mIsLocal;
    }

    public Package getParentPackage() {
        return this.mPackage;
    }

    public long getSize() {
        return this.mSize;
    }

    public String getChecksum() {
        return this.mChecksum;
    }

    public ChecksumType getChecksumType() {
        return this.mChecksumType;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public String getLocalOsPath() {
        return this.mLocalOsPath;
    }

    public Os getOs() {
        return this.mOs;
    }

    public Arch getArch() {
        return this.mArch;
    }

    public String getOsDescription() {
        String string = this.mOs == null ? "unknown OS" : (this.mOs == Os.ANY ? "any OS" : this.mOs.getUiName());
        String string2 = "";
        if (this.mArch != null && this.mArch != Arch.ANY) {
            string2 = this.mArch.getUiName();
        }
        return String.format("%1$s%2$s%3$s", string, string2.length() > 0 ? " " : "", string2);
    }

    public String toString() {
        String string = this.getShortDescription();
        if (string != null) {
            return string;
        }
        return super.toString();
    }

    @Override
    public String getShortDescription() {
        return String.format("Archive for %1$s", this.getOsDescription());
    }

    @Override
    public String getLongDescription() {
        return String.format("%1$s\n%2$s\n%3$s", this.getShortDescription(), this.getSizeDescription(), this.getSha1Description());
    }

    public String getSizeDescription() {
        long l = this.getSize();
        String string = l < 1024L ? String.format("%d Bytes", l) : (l < 0x100000L ? String.format("%d KiB", Math.round((double)l / 1024.0)) : (l < 0x40000000L ? String.format("%.1f MiB", (double)Math.round(10.0 * (double)l / 1048576.0) / 10.0) : String.format("%.1f GiB", (double)Math.round(10.0 * (double)l / 1.073741824E9) / 10.0)));
        return String.format("Size: %1$s", string);
    }

    public String getSha1Description() {
        return String.format("SHA1: %1$s", this.getChecksum());
    }

    public boolean isCompatible() {
        return this.getOs().isCompatible() && this.getArch().isCompatible();
    }

    public void deleteLocal() {
        if (this.isLocal()) {
            new FileOp().deleteFileOrFolder(new File(this.getLocalOsPath()));
        }
    }

    @Override
    public int compareTo(Archive archive) {
        if (this.mPackage != null && archive != null) {
            return this.mPackage.compareTo(archive.getParentPackage());
        }
        return 0;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.mArch == null ? 0 : this.mArch.hashCode());
        n = 31 * n + (this.mChecksum == null ? 0 : this.mChecksum.hashCode());
        n = 31 * n + (this.mChecksumType == null ? 0 : this.mChecksumType.hashCode());
        n = 31 * n + (this.mIsLocal ? 1231 : 1237);
        n = 31 * n + (this.mLocalOsPath == null ? 0 : this.mLocalOsPath.hashCode());
        n = 31 * n + (this.mOs == null ? 0 : this.mOs.hashCode());
        n = 31 * n + (int)(this.mSize ^ this.mSize >>> 32);
        n = 31 * n + (this.mUrl == null ? 0 : this.mUrl.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Archive)) {
            return false;
        }
        Archive archive = (Archive)object;
        if (this.mArch == null ? archive.mArch != null : !this.mArch.equals((Object)archive.mArch)) {
            return false;
        }
        if (this.mChecksum == null ? archive.mChecksum != null : !this.mChecksum.equals(archive.mChecksum)) {
            return false;
        }
        if (this.mChecksumType == null ? archive.mChecksumType != null : !this.mChecksumType.equals((Object)archive.mChecksumType)) {
            return false;
        }
        if (this.mIsLocal != archive.mIsLocal) {
            return false;
        }
        if (this.mLocalOsPath == null ? archive.mLocalOsPath != null : !this.mLocalOsPath.equals(archive.mLocalOsPath)) {
            return false;
        }
        if (this.mOs == null ? archive.mOs != null : !this.mOs.equals((Object)archive.mOs)) {
            return false;
        }
        if (this.mSize != archive.mSize) {
            return false;
        }
        return !(this.mUrl == null ? archive.mUrl != null : !this.mUrl.equals(archive.mUrl));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Arch {
        ANY("Any"),
        PPC("PowerPC"),
        X86("x86"),
        X86_64("x86_64");

        private final String mUiName;

        private Arch(String string2) {
            this.mUiName = string2;
        }

        public String getUiName() {
            return this.mUiName;
        }

        public String getXmlName() {
            return this.toString().toLowerCase(Locale.US);
        }

        public static Arch getCurrentArch() {
            String string = System.getProperty("os.arch");
            if (string.equalsIgnoreCase("x86_64") || string.equalsIgnoreCase("amd64")) {
                return X86_64;
            }
            if (string.equalsIgnoreCase("x86") || string.equalsIgnoreCase("i386") || string.equalsIgnoreCase("i686")) {
                return X86;
            }
            if (string.equalsIgnoreCase("ppc") || string.equalsIgnoreCase("PowerPC")) {
                return PPC;
            }
            return null;
        }

        public boolean isCompatible() {
            if (this == ANY) {
                return true;
            }
            Arch arch = Arch.getCurrentArch();
            return this == arch;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Os {
        ANY("Any"),
        LINUX("Linux"),
        MACOSX("MacOS X"),
        WINDOWS("Windows");

        private final String mUiName;

        private Os(String string2) {
            this.mUiName = string2;
        }

        public String getUiName() {
            return this.mUiName;
        }

        public String getXmlName() {
            return this.toString().toLowerCase(Locale.US);
        }

        public static Os getCurrentOs() {
            String string = System.getProperty("os.name");
            if (string.startsWith("Mac")) {
                return MACOSX;
            }
            if (string.startsWith("Windows")) {
                return WINDOWS;
            }
            if (string.startsWith("Linux")) {
                return LINUX;
            }
            return null;
        }

        public boolean isCompatible() {
            if (this == ANY) {
                return true;
            }
            Os os = Os.getCurrentOs();
            return this == os;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChecksumType {
        SHA1("SHA-1");

        private final String mAlgorithmName;

        private ChecksumType(String string2) {
            this.mAlgorithmName = string2;
        }

        public MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
            return MessageDigest.getInstance(this.mAlgorithmName);
        }
    }
}

