/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.proguard;

import com.crashlytics.tools.android.ObfuscatorConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class ProguardConfig
implements ObfuscatorConfig {
    public static final String PROGUARD_ID = "proguard";
    private static final String PROGUARD_CONFIG_PROPERTY = "proguard.config";
    private static final String DEFAULT_MAPPING_FILE = "mapping.txt";
    public static final String OPTION_DONT_OBFUSCATE = "-dontobfuscate";
    public static final String OPTION_PRINT_MAPPING = "-printmapping";
    private List<File> _configFiles = null;
    private boolean _obfuscates = false;
    private File _deobfuscationFile = null;
    private final String _version;

    public static String getProguardVersion(File file) {
        return "4.7";
    }

    public ProguardConfig(List<File> list, String string) throws IOException {
        this._version = string;
        this.updateConfig(list);
    }

    public List<File> getConfigFiles() {
        return this._configFiles;
    }

    @Override
    public void updateConfig(List<File> list) throws IOException {
        this._obfuscates = !list.isEmpty();
        this._deobfuscationFile = null;
        this._configFiles = new LinkedList<File>(list);
        if (list.isEmpty()) {
            return;
        }
        boolean bl = false;
        String string = this.getDefaultMappingsFile();
        for (File file : list) {
            BufferedReader bufferedReader = null;
            try {
                String string2;
                bufferedReader = new BufferedReader(new FileReader(file));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.contains("#")) {
                        string2 = string2.substring(0, string2.indexOf("#"));
                    }
                    if ((string2 = string2.trim()).startsWith(OPTION_DONT_OBFUSCATE)) {
                        bl = true;
                        continue;
                    }
                    if (!string2.startsWith(OPTION_PRINT_MAPPING)) continue;
                    string = string2.replaceFirst(OPTION_PRINT_MAPPING, "").trim();
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                if (bufferedReader == null) continue;
                bufferedReader.close();
            }
        }
        boolean bl2 = this._obfuscates = !bl;
        if (this._obfuscates) {
            this._deobfuscationFile = new File(string);
        }
    }

    protected String getDefaultMappingsFile() {
        return DEFAULT_MAPPING_FILE;
    }

    @Override
    public boolean isObsfucationEnabled() {
        return this._obfuscates;
    }

    @Override
    public File getDeobfuscationFile() {
        return this._deobfuscationFile;
    }

    @Override
    public String getObfuscatorId() {
        return PROGUARD_ID;
    }

    @Override
    public String getObfuscatorVersion() {
        return this._version;
    }

    public static File findProguardConfigFile(File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("Properties file not found: " + file);
        }
        Properties properties = new Properties();
        properties.load(new FileReader(file));
        if (properties.contains(PROGUARD_CONFIG_PROPERTY)) {
            String string = (String)properties.get(PROGUARD_CONFIG_PROPERTY);
            return new File(string);
        }
        return null;
    }
}

