/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.DefaultManifestData;
import com.crashlytics.tools.android.project.DeobsMetadata;
import com.crashlytics.tools.android.project.ManifestData;
import com.crashlytics.tools.android.project.ResourceFileManager;
import com.crashlytics.tools.utils.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class DefaultAndroidProject
implements AndroidProject {
    static final String OBFUSCATOR_ID_PROGUARD = "proguard";
    private static final String DEOBS_SUBDIR = "deobs";
    private final File _projectPath;
    private final File _dataPath;
    private final File _deobsPath;
    private final ManifestData _manifestData;
    private final File _manifestFile;
    private final ResourceFileManager _resourceManager;
    protected static final FilenameFilter DEOBS_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(".zip");
        }
    };

    public DefaultAndroidProject(File file) throws IOException {
        this(file, new File(file, DeveloperTools.CRASHLYTICS_DATA_ROOT.getPath()));
    }

    public DefaultAndroidProject(File file, File file2) throws IOException {
        this._projectPath = file;
        if (!this._projectPath.exists() || !this._projectPath.isDirectory()) {
            throw new IllegalArgumentException("Project path is not a directory: " + this._projectPath);
        }
        this._manifestFile = new File(this._projectPath, "AndroidManifest.xml");
        this._manifestData = new DefaultManifestData(this._manifestFile);
        this._resourceManager = new ResourceFileManager(this._projectPath, "com_crashlytics_export_strings.xml");
        FileUtils.verifyDirectory(file2);
        String string = this._manifestData.getPackage();
        this._dataPath = new File(file2, string);
        FileUtils.verifyDirectory(this._dataPath);
        this._deobsPath = new File(this._dataPath, DEOBS_SUBDIR);
    }

    @Override
    public File getManifestFile() {
        return this._manifestFile;
    }

    @Override
    public ManifestData getManifestData() {
        return this._manifestData;
    }

    @Override
    public File getResourceFile() {
        return this._resourceManager.getResourceFile();
    }

    @Override
    public File getLocation() {
        return this._projectPath;
    }

    @Override
    public File getLauncherIcon() {
        return this._manifestData.getLauncherIcon();
    }

    @Override
    public UUID updateBuildId() throws IOException {
        if (!this._resourceManager.fileExists()) {
            this._resourceManager.createEmptyResourceFile();
        }
        UUID uUID = this._resourceManager.updateBuildId();
        return uUID;
    }

    @Override
    public UUID getBuildId() throws IOException {
        return this._resourceManager.getBuildId();
    }

    @Override
    public File getDataDirectory() {
        return this._dataPath;
    }

    @Override
    public void storeDeobfuscationFile(File file, String string, String string2) throws IOException {
        if (!file.isFile()) {
            throw new IllegalArgumentException("Invalid deobfuscation file: " + file);
        }
        FileUtils.verifyDirectory(this._deobsPath);
        UUID uUID = this._resourceManager.getBuildId();
        File file2 = new File(this._deobsPath, uUID.toString() + ".zip");
        if (file2.exists()) {
            throw new IllegalStateException("Destination file exists: " + file2);
        }
        FileUtils.zip(file, file2, false);
        DeobsMetadata deobsMetadata = new DeobsMetadata(uUID.toString(), this._manifestFile);
        deobsMetadata.setObfuscatorId(string);
        deobsMetadata.setObfuscatorVersion(string2);
        File file3 = new File(this._deobsPath, uUID.toString() + ".meta");
        deobsMetadata.store(file3);
    }

    @Override
    public boolean hasCachedDeobfuscationFiles() {
        return this._deobsPath.exists() && this._deobsPath.list(DEOBS_FILTER).length > 0;
    }

    protected File getDeobfuscationDirectory() {
        return this._deobsPath;
    }

    @Override
    public List<File> getDeobfuscationFiles() throws IOException {
        if (!this._deobsPath.exists()) {
            return Collections.emptyList();
        }
        FileUtils.verifyDirectory(this._deobsPath);
        LinkedList<File> linkedList = new LinkedList<File>();
        for (String string : this._deobsPath.list(DEOBS_FILTER)) {
            linkedList.add(new File(this._deobsPath, string));
        }
        return linkedList;
    }
}

