/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.api.WebApi;
import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.DeobsMetadata;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class DeobsUploader {
    private static final String REQUEST_DEOBS_FORMAT = "%s/api/v1/%s/deobs";
    private final WebApi _webApi;

    public DeobsUploader(WebApi webApi) {
        this._webApi = webApi;
    }

    public boolean uploadDeobfuscationFiles(AndroidProject androidProject, String string) throws IOException {
        List<File> list = androidProject.getDeobfuscationFiles();
        int n = 0;
        for (File file : androidProject.getDeobfuscationFiles()) {
            boolean bl = this.uploadDeobsFile(file, string);
            if (!bl) continue;
            ++n;
        }
        return n == list.size();
    }

    private boolean uploadDeobsFile(File file, String string) throws IOException {
        String string2 = this.buildIdFromFilename(file);
        File file2 = new File(file.getParent(), string2 + ".meta");
        DeobsMetadata deobsMetadata = new DeobsMetadata();
        deobsMetadata.load(file2);
        Map<String, String> map = deobsMetadata.toMap();
        URL uRL = new URL(String.format(REQUEST_DEOBS_FORMAT, this._webApi.getBaseApiUrl(), string));
        boolean bl = this._webApi.sendFile(uRL, file, "application/zip", "resource[file]", map);
        if (bl) {
            file2.delete();
            file.delete();
        }
        return bl;
    }

    private String buildIdFromFilename(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".zip");
        return string.substring(0, n);
    }
}

