/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    public static String ENDLINE = System.getProperty("line.separator");
    private static final int ZIP_BUFFER = 2048;

    public static boolean isCrashlyticsJar(String string) {
        return (string = string.toLowerCase()).endsWith(".jar") && string.startsWith("crashlytics-");
    }

    public static void verifyDirectory(File file) throws IOException {
        if (!file.exists()) {
            file.mkdir();
        }
        if (!file.exists() || !file.isDirectory()) {
            throw new IOException("Could not create directory: " + file);
        }
    }

    public static void redirect(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    public static Thread redirectAsync(final InputStream inputStream, final OutputStream outputStream) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FileUtils.redirect(inputStream, outputStream);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        });
        thread.start();
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        FileChannel fileChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            fileChannel = new FileInputStream(file).getChannel();
            abstractInterruptibleChannel = new FileOutputStream(file2).getChannel();
            ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, 0L, fileChannel.size());
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
        }
    }

    public static void zip(File file, File file2, boolean bl) throws IOException {
        int n;
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("Source file does not exist: " + file);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        byte[] byArray = new byte[2048];
        String string = bl ? file.toString() : file.getName();
        ZipEntry zipEntry = new ZipEntry(string);
        zipOutputStream.putNextEntry(zipEntry);
        while ((n = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
            zipOutputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        zipOutputStream.close();
    }

    public static void unzip(File file, File file2) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            int n;
            ZipEntry zipEntry = enumeration.nextElement();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            byte[] byArray = new byte[2048];
            FileOutputStream fileOutputStream = new FileOutputStream(new File(file2, zipEntry.getName()));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);
            while ((n = ((InputStream)bufferedInputStream).read(byArray, 0, 2048)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            ((InputStream)bufferedInputStream).close();
        }
    }

    public static String unzipToString(File file) throws IOException {
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException("source file does not exist: " + file);
        }
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        zipInputStream.getNextEntry();
        String string = new Scanner(zipInputStream).useDelimiter("\\A").next();
        return string;
    }

    public static String fileToString(File file) throws IOException {
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException("source file does not exist: " + file);
        }
        return new Scanner(file).useDelimiter("\\A").next();
    }

    public static String streamToString(InputStream inputStream) {
        return new Scanner(inputStream).useDelimiter("\\A").next();
    }

    public static int characterOffset(File file, int n, int n2) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int n3 = 0;
        int n4 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (n3++ == n) {
                n4 += n2;
                break;
            }
            if (n3 > n) {
                bufferedReader.close();
                return -1;
            }
            n4 += string.length() + ENDLINE.length();
        }
        bufferedReader.close();
        return n4;
    }
}

