/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import com.crashlytics.android.answers.EventFilter;
import com.crashlytics.android.answers.SessionEvent;
import java.util.HashSet;
import java.util.Set;

class SamplingEventFilter
implements EventFilter {
    final int samplingRate;
    static final Set<SessionEvent.Type> EVENTS_TYPE_TO_SAMPLE = new HashSet<SessionEvent.Type>(){
        {
            this.add(SessionEvent.Type.CREATE);
            this.add(SessionEvent.Type.START);
            this.add(SessionEvent.Type.RESUME);
            this.add(SessionEvent.Type.SAVE_INSTANCE_STATE);
            this.add(SessionEvent.Type.PAUSE);
            this.add(SessionEvent.Type.STOP);
            this.add(SessionEvent.Type.DESTROY);
            this.add(SessionEvent.Type.ERROR);
        }
    };

    public SamplingEventFilter(int samplingRate) {
        this.samplingRate = samplingRate;
    }

    @Override
    public boolean skipEvent(SessionEvent sessionEvent) {
        boolean canBeSampled = EVENTS_TYPE_TO_SAMPLE.contains((Object)sessionEvent.type) && sessionEvent.sessionEventMetadata.betaDeviceToken == null;
        String installID = sessionEvent.sessionEventMetadata.installationId;
        boolean isSampledId = Math.abs(installID.hashCode() % this.samplingRate) != 0;
        return canBeSampled && isSampledId;
    }
}

