/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.app.Activity;
import com.crashlytics.android.answers.CustomEvent;
import com.crashlytics.android.answers.PredefinedEvent;
import com.crashlytics.android.answers.SessionEventMetadata;
import java.util.Collections;
import java.util.Map;

final class SessionEvent {
    static final String ACTIVITY_KEY = "activity";
    static final String SESSION_ID_KEY = "sessionId";
    public final SessionEventMetadata sessionEventMetadata;
    public final long timestamp;
    public final Type type;
    public final Map<String, String> details;
    public final String customType;
    public final Map<String, Object> customAttributes;
    public final String predefinedType;
    public final Map<String, Object> predefinedAttributes;
    private String stringRepresentation;

    public static Builder lifecycleEventBuilder(Type type, Activity activity) {
        Map<String, String> details = Collections.singletonMap(ACTIVITY_KEY, activity.getClass().getName());
        return new Builder(type).details(details);
    }

    public static Builder installEventBuilder() {
        return new Builder(Type.INSTALL);
    }

    public static Builder errorEventBuilder(String sessionId) {
        Map<String, String> details = Collections.singletonMap(SESSION_ID_KEY, sessionId);
        return new Builder(Type.ERROR).details(details);
    }

    public static Builder crashEventBuilder(String sessionId) {
        Map<String, String> details = Collections.singletonMap(SESSION_ID_KEY, sessionId);
        return new Builder(Type.CRASH).details(details);
    }

    public static Builder customEventBuilder(CustomEvent event) {
        return new Builder(Type.CUSTOM).customType(event.getCustomType()).customAttributes(event.getCustomAttributes());
    }

    public static Builder predefinedEventBuilder(PredefinedEvent<?> event) {
        return new Builder(Type.PREDEFINED).predefinedType(event.getPredefinedType()).predefinedAttributes(event.getPredefinedAttributes()).customAttributes(event.getCustomAttributes());
    }

    private SessionEvent(SessionEventMetadata sessionEventMetadata, long timestamp, Type type, Map<String, String> details, String customType, Map<String, Object> customAttributes, String predefinedType, Map<String, Object> predefinedAttributes) {
        this.sessionEventMetadata = sessionEventMetadata;
        this.timestamp = timestamp;
        this.type = type;
        this.details = details;
        this.customType = customType;
        this.customAttributes = customAttributes;
        this.predefinedType = predefinedType;
        this.predefinedAttributes = predefinedAttributes;
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            StringBuilder sb = new StringBuilder().append("[").append(this.getClass().getSimpleName()).append(": ").append("timestamp=").append(this.timestamp).append(", type=").append((Object)this.type).append(", details=").append(this.details.toString()).append(", customType=").append(this.customType).append(", customAttributes=").append(this.customAttributes.toString()).append(", predefinedType=").append(this.predefinedType).append(", predefinedAttributes=").append(this.predefinedAttributes.toString()).append(", metadata=[").append(this.sessionEventMetadata).append("]]");
            this.stringRepresentation = sb.toString();
        }
        return this.stringRepresentation;
    }

    static class Builder {
        final Type type;
        final long timestamp;
        Map<String, String> details;
        String customType;
        Map<String, Object> customAttributes;
        String predefinedType;
        Map<String, Object> predefinedAttributes;

        public Builder(Type type) {
            this.type = type;
            this.timestamp = System.currentTimeMillis();
            this.details = Collections.emptyMap();
            this.customType = null;
            this.customAttributes = Collections.emptyMap();
            this.predefinedType = null;
            this.predefinedAttributes = Collections.emptyMap();
        }

        public Builder details(Map<String, String> details) {
            this.details = details;
            return this;
        }

        public Builder customType(String customType) {
            this.customType = customType;
            return this;
        }

        public Builder customAttributes(Map<String, Object> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public Builder predefinedType(String predefinedType) {
            this.predefinedType = predefinedType;
            return this;
        }

        public Builder predefinedAttributes(Map<String, Object> predefinedAttributes) {
            this.predefinedAttributes = predefinedAttributes;
            return this;
        }

        public SessionEvent build(SessionEventMetadata sessionEventMetadata) {
            return new SessionEvent(sessionEventMetadata, this.timestamp, this.type, this.details, this.customType, this.customAttributes, this.predefinedType, this.predefinedAttributes);
        }
    }

    static enum Type {
        CREATE,
        START,
        RESUME,
        SAVE_INSTANCE_STATE,
        PAUSE,
        STOP,
        DESTROY,
        ERROR,
        CRASH,
        INSTALL,
        CUSTOM,
        PREDEFINED;

    }
}

