/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.content.Context;
import com.crashlytics.android.answers.SessionEventMetadata;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.IdManager;
import java.util.Map;
import java.util.UUID;

class SessionMetadataCollector {
    private final Context context;
    private final IdManager idManager;
    private final String versionCode;
    private final String versionName;

    public SessionMetadataCollector(Context context, IdManager idManager, String versionCode, String versionName) {
        this.context = context;
        this.idManager = idManager;
        this.versionCode = versionCode;
        this.versionName = versionName;
    }

    public SessionEventMetadata getMetadata() {
        Map deviceIdentifiers = this.idManager.getDeviceIdentifiers();
        String appBundleId = this.context.getPackageName();
        String installationId = this.idManager.getAppInstallIdentifier();
        String androidId = (String)deviceIdentifiers.get(IdManager.DeviceIdentifierType.ANDROID_ID);
        String advertisingId = (String)deviceIdentifiers.get(IdManager.DeviceIdentifierType.ANDROID_ADVERTISING_ID);
        String betaDeviceToken = (String)deviceIdentifiers.get(IdManager.DeviceIdentifierType.FONT_TOKEN);
        String buildId = CommonUtils.resolveBuildId((Context)this.context);
        String osVersion = this.idManager.getOsVersionString();
        String deviceModel = this.idManager.getModelName();
        String executionId = UUID.randomUUID().toString();
        return new SessionEventMetadata(appBundleId, executionId, installationId, androidId, advertisingId, betaDeviceToken, buildId, osVersion, deviceModel, this.versionCode, this.versionName);
    }
}

