/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import com.crashlytics.android.answers.AnswersEventsHandler;
import com.crashlytics.android.answers.AnswersFilesManagerProvider;
import com.crashlytics.android.answers.AnswersLifecycleCallbacks;
import com.crashlytics.android.answers.AnswersPreferenceManager;
import com.crashlytics.android.answers.CustomEvent;
import com.crashlytics.android.answers.PredefinedEvent;
import com.crashlytics.android.answers.SessionEvent;
import com.crashlytics.android.answers.SessionMetadataCollector;
import io.fabric.sdk.android.ActivityLifecycleManager;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.IdManager;
import io.fabric.sdk.android.services.network.DefaultHttpRequestFactory;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.persistence.FileStore;
import io.fabric.sdk.android.services.persistence.FileStoreImpl;
import io.fabric.sdk.android.services.settings.AnalyticsSettingsData;

class SessionAnalyticsManager {
    static final String ON_CRASH_ERROR_MSG = "onCrash called from main thread!!!";
    static final long FIRST_LAUNCH_INTERVAL_IN_MS = 3600000L;
    private final long installedAt;
    final AnswersEventsHandler eventsHandler;
    final ActivityLifecycleManager lifecycleManager;
    final AnswersPreferenceManager preferenceManager;
    final AnswersLifecycleCallbacks lifecycleCallbacks = new AnswersLifecycleCallbacks(this);

    public static SessionAnalyticsManager build(Kit kit, Context context, IdManager idManager, String versionCode, String versionName, long installedAt) {
        SessionMetadataCollector metadataCollector = new SessionMetadataCollector(context, idManager, versionCode, versionName);
        AnswersFilesManagerProvider filesManagerProvider = new AnswersFilesManagerProvider(context, (FileStore)new FileStoreImpl(kit));
        DefaultHttpRequestFactory httpRequestFactory = new DefaultHttpRequestFactory(Fabric.getLogger());
        ActivityLifecycleManager lifecycleManager = new ActivityLifecycleManager(context);
        AnswersEventsHandler eventsHandler = new AnswersEventsHandler(kit, context, filesManagerProvider, metadataCollector, (HttpRequestFactory)httpRequestFactory);
        AnswersPreferenceManager preferenceManager = AnswersPreferenceManager.build(context);
        return new SessionAnalyticsManager(eventsHandler, lifecycleManager, preferenceManager, installedAt);
    }

    SessionAnalyticsManager(AnswersEventsHandler eventsHandler, ActivityLifecycleManager lifecycleManager, AnswersPreferenceManager preferenceManager, long installedAt) {
        this.eventsHandler = eventsHandler;
        this.lifecycleManager = lifecycleManager;
        this.preferenceManager = preferenceManager;
        this.installedAt = installedAt;
    }

    public void enable() {
        this.eventsHandler.enable();
        this.lifecycleManager.registerCallbacks((ActivityLifecycleManager.Callbacks)this.lifecycleCallbacks);
        if (this.isFirstLaunch(this.installedAt)) {
            this.onInstall();
            this.preferenceManager.setAnalyticsLaunched();
        }
    }

    public void disable() {
        this.lifecycleManager.resetCallbacks();
        this.eventsHandler.disable();
    }

    public void onCustom(CustomEvent event) {
        Fabric.getLogger().d("Answers", "Logged custom event: " + event);
        this.eventsHandler.processEventAsync(SessionEvent.customEventBuilder(event));
    }

    public void onPredefined(PredefinedEvent event) {
        Fabric.getLogger().d("Answers", "Logged predefined event: " + event);
        this.eventsHandler.processEventAsync(SessionEvent.predefinedEventBuilder(event));
    }

    public void onCrash(String sessionId) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalStateException(ON_CRASH_ERROR_MSG);
        }
        Fabric.getLogger().d("Answers", "Logged crash");
        this.eventsHandler.processEventSync(SessionEvent.crashEventBuilder(sessionId));
    }

    public void onError(String sessionId) {
    }

    public void onInstall() {
        Fabric.getLogger().d("Answers", "Logged install");
        this.eventsHandler.processEventAsyncAndFlush(SessionEvent.installEventBuilder());
    }

    public void onLifecycle(Activity activity, SessionEvent.Type type) {
        Fabric.getLogger().d("Answers", "Logged lifecycle event: " + type.name());
        this.eventsHandler.processEventAsync(SessionEvent.lifecycleEventBuilder(type, activity));
    }

    public void setAnalyticsSettingsData(AnalyticsSettingsData analyticsSettingsData, String protocolAndHostOverride) {
        this.eventsHandler.setAnalyticsSettingsData(analyticsSettingsData, protocolAndHostOverride);
    }

    boolean isFirstLaunch(long installedAt) {
        return !this.preferenceManager.hasAnalyticsLaunched() && this.installedRecently(installedAt);
    }

    boolean installedRecently(long installedAt) {
        long timeDifferenceInMilliseconds = System.currentTimeMillis() - installedAt;
        return timeDifferenceInMilliseconds < 3600000L;
    }
}

