/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.content.Context;
import com.crashlytics.android.answers.AnswersFilesManagerProvider;
import com.crashlytics.android.answers.DisabledSessionAnalyticsManagerStrategy;
import com.crashlytics.android.answers.EnabledSessionAnalyticsManagerStrategy;
import com.crashlytics.android.answers.SessionAnalyticsFilesManager;
import com.crashlytics.android.answers.SessionAnalyticsManagerStrategy;
import com.crashlytics.android.answers.SessionEvent;
import com.crashlytics.android.answers.SessionEventMetadata;
import com.crashlytics.android.answers.SessionMetadataCollector;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.events.EventsStorageListener;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.settings.AnalyticsSettingsData;
import java.util.concurrent.ScheduledExecutorService;

class AnswersEventsHandler
implements EventsStorageListener {
    private final Kit kit;
    private final Context context;
    private final AnswersFilesManagerProvider filesManagerProvider;
    private final SessionMetadataCollector metadataCollector;
    private final HttpRequestFactory requestFactory;
    final ScheduledExecutorService executor;
    SessionAnalyticsManagerStrategy strategy = new DisabledSessionAnalyticsManagerStrategy();

    public AnswersEventsHandler(Kit kit, Context context, AnswersFilesManagerProvider filesManagerProvider, SessionMetadataCollector metadataCollector, HttpRequestFactory requestFactory, ScheduledExecutorService executor) {
        this.kit = kit;
        this.context = context;
        this.filesManagerProvider = filesManagerProvider;
        this.metadataCollector = metadataCollector;
        this.requestFactory = requestFactory;
        this.executor = executor;
    }

    public void processEventAsync(SessionEvent.Builder eventBuilder) {
        this.processEvent(eventBuilder, false, false);
    }

    public void processEventAsyncAndFlush(SessionEvent.Builder eventBuilder) {
        this.processEvent(eventBuilder, false, true);
    }

    public void processEventSync(SessionEvent.Builder eventBuilder) {
        this.processEvent(eventBuilder, true, false);
    }

    public void setAnalyticsSettingsData(final AnalyticsSettingsData analyticsSettingsData, final String protocolAndHostOverride) {
        this.executeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    AnswersEventsHandler.this.strategy.setAnalyticsSettingsData(analyticsSettingsData, protocolAndHostOverride);
                }
                catch (Exception e) {
                    Fabric.getLogger().e("Answers", "Failed to set analytics settings data", (Throwable)e);
                }
            }
        });
    }

    public void disable() {
        this.executeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    SessionAnalyticsManagerStrategy prevStrategy = AnswersEventsHandler.this.strategy;
                    AnswersEventsHandler.this.strategy = new DisabledSessionAnalyticsManagerStrategy();
                    prevStrategy.deleteAllEvents();
                }
                catch (Exception e) {
                    Fabric.getLogger().e("Answers", "Failed to disable events", (Throwable)e);
                }
            }
        });
    }

    public void onRollOver(String rolledOverFile) {
        this.executeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    AnswersEventsHandler.this.strategy.sendEvents();
                }
                catch (Exception e) {
                    Fabric.getLogger().e("Answers", "Failed to send events files", (Throwable)e);
                }
            }
        });
    }

    public void enable() {
        this.executeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    SessionEventMetadata metadata = AnswersEventsHandler.this.metadataCollector.getMetadata();
                    SessionAnalyticsFilesManager filesManager = AnswersEventsHandler.this.filesManagerProvider.getAnalyticsFilesManager();
                    filesManager.registerRollOverListener(AnswersEventsHandler.this);
                    AnswersEventsHandler.this.strategy = new EnabledSessionAnalyticsManagerStrategy(AnswersEventsHandler.this.kit, AnswersEventsHandler.this.context, AnswersEventsHandler.this.executor, filesManager, AnswersEventsHandler.this.requestFactory, metadata);
                }
                catch (Exception e) {
                    Fabric.getLogger().e("Answers", "Failed to enable events", (Throwable)e);
                }
            }
        });
    }

    public void flushEvents() {
        this.executeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    AnswersEventsHandler.this.strategy.rollFileOver();
                }
                catch (Exception e) {
                    Fabric.getLogger().e("Answers", "Failed to flush events", (Throwable)e);
                }
            }
        });
    }

    void processEvent(final SessionEvent.Builder eventBuilder, boolean sync, final boolean flush) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    AnswersEventsHandler.this.strategy.processEvent(eventBuilder);
                    if (flush) {
                        AnswersEventsHandler.this.strategy.rollFileOver();
                    }
                }
                catch (Exception e) {
                    Fabric.getLogger().e("Answers", "Failed to process event", (Throwable)e);
                }
            }
        };
        if (sync) {
            this.executeSync(runnable);
        } else {
            this.executeAsync(runnable);
        }
    }

    private void executeSync(Runnable runnable) {
        try {
            this.executor.submit(runnable).get();
        }
        catch (Exception e) {
            Fabric.getLogger().e("Answers", "Failed to run events task", (Throwable)e);
        }
    }

    private void executeAsync(Runnable runnable) {
        try {
            this.executor.submit(runnable);
        }
        catch (Exception e) {
            Fabric.getLogger().e("Answers", "Failed to submit events task", (Throwable)e);
        }
    }
}

