/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import com.crashlytics.android.answers.RandomBackoff;
import com.crashlytics.android.answers.RetryManager;
import com.crashlytics.android.answers.SessionAnalyticsFilesSender;
import io.fabric.sdk.android.services.concurrency.internal.Backoff;
import io.fabric.sdk.android.services.concurrency.internal.DefaultRetryPolicy;
import io.fabric.sdk.android.services.concurrency.internal.ExponentialBackoff;
import io.fabric.sdk.android.services.concurrency.internal.RetryPolicy;
import io.fabric.sdk.android.services.concurrency.internal.RetryState;
import io.fabric.sdk.android.services.events.FilesSender;
import java.io.File;
import java.util.List;

class AnswersRetryFilesSender
implements FilesSender {
    private static final int MAX_RETRIES = 5;
    private static final int BACKOFF_MS = 1000;
    private static final int BACKOFF_POWER = 8;
    private static final double JITTER_PERCENT = 0.1;
    private final SessionAnalyticsFilesSender filesSender;
    private final RetryManager retryManager;

    public static AnswersRetryFilesSender build(SessionAnalyticsFilesSender filesSender) {
        RandomBackoff backoff = new RandomBackoff((Backoff)new ExponentialBackoff(1000L, 8), 0.1);
        DefaultRetryPolicy retryPolicy = new DefaultRetryPolicy(5);
        RetryState retryState = new RetryState((Backoff)backoff, (RetryPolicy)retryPolicy);
        RetryManager retryManager = new RetryManager(retryState);
        return new AnswersRetryFilesSender(filesSender, retryManager);
    }

    AnswersRetryFilesSender(SessionAnalyticsFilesSender filesSender, RetryManager retryManager) {
        this.filesSender = filesSender;
        this.retryManager = retryManager;
    }

    public boolean send(List<File> files) {
        long currentNanoTime = System.nanoTime();
        if (this.retryManager.canRetry(currentNanoTime)) {
            boolean cleanup = this.filesSender.send(files);
            if (cleanup) {
                this.retryManager.reset();
                return true;
            }
            this.retryManager.recordRetry(currentNanoTime);
            return false;
        }
        return false;
    }
}

