/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import android.content.Context;
import com.crashlytics.android.core.CrashlyticsCore;
import com.crashlytics.android.core.CrashlyticsUncaughtExceptionHandler;
import com.crashlytics.android.core.CreateReportRequest;
import com.crashlytics.android.core.CreateReportSpiCall;
import com.crashlytics.android.core.Report;
import com.crashlytics.android.core.SessionReport;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.ApiKey;
import io.fabric.sdk.android.services.common.BackgroundPriorityRunnable;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class ReportUploader {
    private static final FilenameFilter crashFileFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String filename) {
            return filename.endsWith(ReportUploader.CLS_FILE_EXT) && !filename.contains("Session");
        }
    };
    static final Map<String, String> HEADER_INVALID_CLS_FILE = Collections.singletonMap("X-CRASHLYTICS-INVALID-SESSION", "1");
    private static final short[] RETRY_INTERVALS = new short[]{10, 20, 30, 60, 120, 300};
    private static final String CLS_FILE_EXT = ".cls";
    private final Object fileAccessLock = new Object();
    private final CreateReportSpiCall createReportCall;
    private Thread uploadThread;

    public ReportUploader(CreateReportSpiCall createReportCall) {
        if (createReportCall == null) {
            throw new IllegalArgumentException("createReportCall must not be null.");
        }
        this.createReportCall = createReportCall;
    }

    public void uploadReports() {
        this.uploadReports(0.0f);
    }

    public synchronized void uploadReports(float delay) {
        if (this.uploadThread == null) {
            this.uploadThread = new Thread((Runnable)((Object)new Worker(delay)), "Crashlytics Report Uploader");
            this.uploadThread.start();
        }
    }

    boolean isUploading() {
        return this.uploadThread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean forceUpload(Report report) {
        boolean removed = false;
        Object object = this.fileAccessLock;
        synchronized (object) {
            try {
                Context context = CrashlyticsCore.getInstance().getContext();
                CreateReportRequest requestData = new CreateReportRequest(new ApiKey().getValue(context), report);
                boolean sent = this.createReportCall.invoke(requestData);
                Fabric.getLogger().i("Fabric", "Crashlytics report upload " + (sent ? "complete: " : "FAILED: ") + report.getFileName());
                if (sent) {
                    report.remove();
                    removed = true;
                }
            }
            catch (Exception e) {
                Fabric.getLogger().e("Fabric", "Error occurred sending report " + report, (Throwable)e);
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Report> findReports() {
        File[] clsFiles;
        Fabric.getLogger().d("Fabric", "Checking for crash reports...");
        Object object = this.fileAccessLock;
        synchronized (object) {
            clsFiles = CrashlyticsCore.getInstance().getSdkDirectory().listFiles(crashFileFilter);
        }
        LinkedList<Report> reports = new LinkedList<Report>();
        for (File file : clsFiles) {
            Fabric.getLogger().d("Fabric", "Found crash report " + file.getPath());
            reports.add(new SessionReport(file));
        }
        if (reports.isEmpty()) {
            Fabric.getLogger().d("Fabric", "No reports found.");
        }
        return reports;
    }

    private class Worker
    extends BackgroundPriorityRunnable {
        private final float delay;

        Worker(float delay) {
            this.delay = delay;
        }

        public void onRun() {
            try {
                this.attemptUploadWithRetry();
            }
            catch (Exception e) {
                Fabric.getLogger().e("Fabric", "An unexpected error occurred while attempting to upload crash reports.", (Throwable)e);
            }
            ReportUploader.this.uploadThread = null;
        }

        private void attemptUploadWithRetry() {
            Fabric.getLogger().d("Fabric", "Starting report processing in " + this.delay + " second(s)...");
            if (this.delay > 0.0f) {
                try {
                    Thread.sleep((long)(this.delay * 1000.0f));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            CrashlyticsCore crashlyticsCore = CrashlyticsCore.getInstance();
            CrashlyticsUncaughtExceptionHandler handler = crashlyticsCore.getHandler();
            List<Report> reports = ReportUploader.this.findReports();
            if (handler.isHandlingException()) {
                return;
            }
            if (!reports.isEmpty() && !crashlyticsCore.canSendWithUserApproval()) {
                Fabric.getLogger().d("Fabric", "User declined to send. Removing " + reports.size() + " Report(s).");
                for (Report report : reports) {
                    report.remove();
                }
                return;
            }
            int retryCount = 0;
            while (!reports.isEmpty()) {
                if (CrashlyticsCore.getInstance().getHandler().isHandlingException()) {
                    return;
                }
                Fabric.getLogger().d("Fabric", "Attempting to send " + reports.size() + " report(s)");
                for (Report report : reports) {
                    ReportUploader.this.forceUpload(report);
                }
                reports = ReportUploader.this.findReports();
                if (reports.isEmpty()) continue;
                long interval = RETRY_INTERVALS[Math.min(retryCount++, RETRY_INTERVALS.length - 1)];
                Fabric.getLogger().d("Fabric", "Report submisson: scheduling delayed retry in " + interval + " seconds");
                try {
                    Thread.sleep(interval * 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }
}

