/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import com.crashlytics.android.core.MiddleOutStrategy;
import com.crashlytics.android.core.StackTraceTrimmingStrategy;

class MiddleOutFallbackStrategy
implements StackTraceTrimmingStrategy {
    private final int maximumStackSize;
    private final StackTraceTrimmingStrategy[] trimmingStrategies;
    private final MiddleOutStrategy middleOutStrategy;

    public MiddleOutFallbackStrategy(int maximumStackSize, StackTraceTrimmingStrategy ... strategies) {
        this.maximumStackSize = maximumStackSize;
        this.trimmingStrategies = strategies;
        this.middleOutStrategy = new MiddleOutStrategy(maximumStackSize);
    }

    @Override
    public StackTraceElement[] getTrimmedStackTrace(StackTraceElement[] stacktrace) {
        if (stacktrace.length <= this.maximumStackSize) {
            return stacktrace;
        }
        StackTraceElement[] trimmed = stacktrace;
        for (StackTraceTrimmingStrategy strategy : this.trimmingStrategies) {
            if (trimmed.length <= this.maximumStackSize) break;
            trimmed = strategy.getTrimmedStackTrace(stacktrace);
        }
        if (trimmed.length > this.maximumStackSize) {
            trimmed = this.middleOutStrategy.getTrimmedStackTrace(trimmed);
        }
        return trimmed;
    }
}

