/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.view.View;
import android.widget.ScrollView;
import android.widget.TextView;
import com.crashlytics.android.answers.Answers;
import com.crashlytics.android.core.BuildIdValidator;
import com.crashlytics.android.core.CrashTest;
import com.crashlytics.android.core.CrashlyticsExecutorServiceWrapper;
import com.crashlytics.android.core.CrashlyticsFileMarker;
import com.crashlytics.android.core.CrashlyticsListener;
import com.crashlytics.android.core.CrashlyticsMissingDependencyException;
import com.crashlytics.android.core.CrashlyticsPinningInfoProvider;
import com.crashlytics.android.core.CrashlyticsUncaughtExceptionHandler;
import com.crashlytics.android.core.CreateReportSpiCall;
import com.crashlytics.android.core.DefaultCreateReportSpiCall;
import com.crashlytics.android.core.DialogStringResolver;
import com.crashlytics.android.core.ManifestUnityVersionProvider;
import com.crashlytics.android.core.PinningInfoProvider;
import com.crashlytics.android.core.ReportUploader;
import com.crashlytics.android.core.UnityVersionProvider;
import com.crashlytics.android.core.internal.CrashEventDataProvider;
import com.crashlytics.android.core.internal.models.SessionEventData;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.ApiKey;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.Crash;
import io.fabric.sdk.android.services.common.ExecutorUtils;
import io.fabric.sdk.android.services.concurrency.DependsOn;
import io.fabric.sdk.android.services.concurrency.Priority;
import io.fabric.sdk.android.services.concurrency.PriorityCallable;
import io.fabric.sdk.android.services.concurrency.Task;
import io.fabric.sdk.android.services.concurrency.UnmetDependencyException;
import io.fabric.sdk.android.services.network.DefaultHttpRequestFactory;
import io.fabric.sdk.android.services.network.HttpMethod;
import io.fabric.sdk.android.services.network.HttpRequest;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.persistence.FileStore;
import io.fabric.sdk.android.services.persistence.FileStoreImpl;
import io.fabric.sdk.android.services.persistence.PreferenceStoreImpl;
import io.fabric.sdk.android.services.settings.PromptSettingsData;
import io.fabric.sdk.android.services.settings.SessionSettingsData;
import io.fabric.sdk.android.services.settings.Settings;
import io.fabric.sdk.android.services.settings.SettingsData;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.HttpsURLConnection;

@DependsOn(value={CrashEventDataProvider.class})
public class CrashlyticsCore
extends Kit<Void> {
    public static final String TAG = "CrashlyticsCore";
    static final float CLS_DEFAULT_PROCESS_DELAY = 1.0f;
    static final String CRASHLYTICS_API_ENDPOINT = "com.crashlytics.ApiEndpoint";
    static final String CRASHLYTICS_REQUIRE_BUILD_ID = "com.crashlytics.RequireBuildId";
    static final boolean CRASHLYTICS_REQUIRE_BUILD_ID_DEFAULT = true;
    static final String COLLECT_CUSTOM_LOGS = "com.crashlytics.CollectCustomLogs";
    static final String COLLECT_CUSTOM_KEYS = "com.crashlytics.CollectCustomKeys";
    static final int MAX_ATTRIBUTES = 64;
    static final int MAX_ATTRIBUTE_SIZE = 1024;
    static final int DEFAULT_MAIN_HANDLER_TIMEOUT_SEC = 4;
    private static final String PREF_ALWAYS_SEND_REPORTS_KEY = "always_send_reports_opt_in";
    private static final boolean SHOULD_PROMPT_BEFORE_SENDING_REPORTS_DEFAULT = false;
    private static final String INITIALIZATION_MARKER_FILE_NAME = "initialization_marker";
    static final String CRASH_MARKER_FILE_NAME = "crash_marker";
    private final long startTime;
    private final ConcurrentHashMap<String, String> attributes;
    private File sdkDir;
    private FileStore fileStore;
    private CrashlyticsFileMarker initializationMarker;
    private CrashlyticsFileMarker crashMarker;
    private CrashlyticsListener listener;
    private CrashlyticsUncaughtExceptionHandler handler;
    private String userId = null;
    private String userEmail = null;
    private String userName = null;
    private String buildId;
    private String packageName;
    private String apiKey;
    private String installerPackageName;
    private String versionCode;
    private String versionName;
    private float delay;
    private boolean disabled;
    private final PinningInfoProvider pinningInfo;
    private HttpRequestFactory httpRequestFactory;
    private CrashlyticsExecutorServiceWrapper executorServiceWrapper;
    private CrashEventDataProvider externalCrashEventDataProvider;

    public CrashlyticsCore() {
        this(1.0f, null, null, false);
    }

    CrashlyticsCore(float delay, CrashlyticsListener listener, PinningInfoProvider pinningInfo, boolean disabled) {
        this(delay, listener, pinningInfo, disabled, ExecutorUtils.buildSingleThreadExecutorService((String)"Crashlytics Exception Handler"));
    }

    CrashlyticsCore(float delay, CrashlyticsListener listener, PinningInfoProvider pinningInfo, boolean disabled, ExecutorService crashHandlerExecutor) {
        this.delay = delay;
        this.listener = listener != null ? listener : new NoOpListener();
        this.pinningInfo = pinningInfo;
        this.disabled = disabled;
        this.executorServiceWrapper = new CrashlyticsExecutorServiceWrapper(crashHandlerExecutor);
        this.attributes = new ConcurrentHashMap();
        this.startTime = System.currentTimeMillis();
    }

    protected boolean onPreExecute() {
        Context context = super.getContext();
        return this.onPreExecute(context);
    }

    boolean onPreExecute(Context context) {
        if (this.disabled) {
            return false;
        }
        this.apiKey = new ApiKey().getValue(context);
        if (this.apiKey == null) {
            return false;
        }
        Fabric.getLogger().i(TAG, "Initializing Crashlytics " + this.getVersion());
        this.fileStore = new FileStoreImpl((Kit)this);
        this.crashMarker = new CrashlyticsFileMarker(CRASH_MARKER_FILE_NAME, this.fileStore);
        this.initializationMarker = new CrashlyticsFileMarker(INITIALIZATION_MARKER_FILE_NAME, this.fileStore);
        try {
            this.setAndValidateKitProperties(context, this.apiKey);
            ManifestUnityVersionProvider unityVersionProvider = new ManifestUnityVersionProvider(context, this.getPackageName());
            boolean initializeSynchronously = this.didPreviousInitializationFail();
            this.checkForPreviousCrash();
            this.installExceptionHandler(unityVersionProvider);
            if (initializeSynchronously && CommonUtils.canTryConnection((Context)context)) {
                this.finishInitSynchronously();
                return false;
            }
            return true;
        }
        catch (CrashlyticsMissingDependencyException e) {
            throw new UnmetDependencyException((Throwable)e);
        }
        catch (Exception e) {
            Fabric.getLogger().e(TAG, "Crashlytics was not started due to an exception during initialization", (Throwable)e);
            return false;
        }
    }

    private void setAndValidateKitProperties(Context context, String apiKey) throws PackageManager.NameNotFoundException {
        CrashlyticsPinningInfoProvider infoProvider = this.pinningInfo != null ? new CrashlyticsPinningInfoProvider(this.pinningInfo) : null;
        this.httpRequestFactory = new DefaultHttpRequestFactory(Fabric.getLogger());
        this.httpRequestFactory.setPinningInfoProvider((io.fabric.sdk.android.services.network.PinningInfoProvider)infoProvider);
        this.packageName = context.getPackageName();
        this.installerPackageName = this.getIdManager().getInstallerPackageName();
        Fabric.getLogger().d(TAG, "Installer package name is: " + this.installerPackageName);
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo = packageManager.getPackageInfo(this.packageName, 0);
        this.versionCode = Integer.toString(packageInfo.versionCode);
        this.versionName = packageInfo.versionName == null ? "0.0" : packageInfo.versionName;
        this.buildId = CommonUtils.resolveBuildId((Context)context);
        this.getBuildIdValidator(this.buildId, CrashlyticsCore.isRequiringBuildId(context)).validate(apiKey, this.packageName);
    }

    private void installExceptionHandler(UnityVersionProvider unityVersionProvider) {
        try {
            Fabric.getLogger().d(TAG, "Installing exception handler...");
            this.handler = new CrashlyticsUncaughtExceptionHandler(Thread.getDefaultUncaughtExceptionHandler(), this.executorServiceWrapper, this.getIdManager(), unityVersionProvider, this.fileStore, this);
            this.handler.openSession();
            Thread.setDefaultUncaughtExceptionHandler(this.handler);
            Fabric.getLogger().d(TAG, "Successfully installed exception handler.");
        }
        catch (Exception e) {
            Fabric.getLogger().e(TAG, "There was a problem installing the exception handler.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doInBackground() {
        this.markInitializationStarted();
        SessionEventData crashEventData = this.getExternalCrashEventData();
        if (crashEventData != null) {
            this.handler.writeExternalCrashEvent(crashEventData);
        }
        this.handler.cleanInvalidTempFiles();
        try {
            SettingsData settingsData = Settings.getInstance().awaitSettingsData();
            if (settingsData == null) {
                Fabric.getLogger().w(TAG, "Received null settings, skipping initialization!");
                Void void_ = null;
                return void_;
            }
            if (!settingsData.featuresData.collectReports) {
                Fabric.getLogger().d(TAG, "Collection of crash reports disabled in Crashlytics settings.");
                Void void_ = null;
                return void_;
            }
            this.handler.finalizeSessions();
            CreateReportSpiCall call = this.getCreateReportSpiCall(settingsData);
            if (call == null) {
                Fabric.getLogger().w(TAG, "Unable to create a call to upload reports.");
                Void void_ = null;
                return void_;
            }
            new ReportUploader(this.apiKey, call).uploadReports(this.delay);
        }
        catch (Exception e) {
            Fabric.getLogger().e(TAG, "Crashlytics encountered a problem during asynchronous initialization.", (Throwable)e);
        }
        finally {
            this.markInitializationComplete();
        }
        return null;
    }

    public String getIdentifier() {
        return "com.crashlytics.sdk.android.crashlytics-core";
    }

    public String getVersion() {
        return "2.3.13.145";
    }

    public static CrashlyticsCore getInstance() {
        return (CrashlyticsCore)Fabric.getKit(CrashlyticsCore.class);
    }

    public PinningInfoProvider getPinningInfoProvider() {
        return !this.disabled ? this.pinningInfo : null;
    }

    public void logException(Throwable throwable) {
        if (this.disabled) {
            return;
        }
        if (!CrashlyticsCore.ensureFabricWithCalled("prior to logging exceptions.")) {
            return;
        }
        if (throwable == null) {
            Fabric.getLogger().log(5, TAG, "Crashlytics is ignoring a request to log a null exception.");
            return;
        }
        this.handler.writeNonFatalException(Thread.currentThread(), throwable);
    }

    public void log(String msg) {
        this.doLog(3, TAG, msg);
    }

    private void doLog(int priority, String tag, String msg) {
        if (this.disabled) {
            return;
        }
        if (!CrashlyticsCore.ensureFabricWithCalled("prior to logging messages.")) {
            return;
        }
        long timestamp = System.currentTimeMillis() - this.startTime;
        this.handler.writeToLog(timestamp, CrashlyticsCore.formatLogMessage(priority, tag, msg));
    }

    public void log(int priority, String tag, String msg) {
        this.doLog(priority, tag, msg);
        Fabric.getLogger().log(priority, "" + tag, "" + msg, true);
    }

    public void setUserIdentifier(String identifier) {
        if (this.disabled) {
            return;
        }
        this.userId = CrashlyticsCore.sanitizeAttribute(identifier);
        this.handler.cacheUserData(this.userId, this.userName, this.userEmail);
    }

    public void setUserName(String name) {
        if (this.disabled) {
            return;
        }
        this.userName = CrashlyticsCore.sanitizeAttribute(name);
        this.handler.cacheUserData(this.userId, this.userName, this.userEmail);
    }

    public void setUserEmail(String email) {
        if (this.disabled) {
            return;
        }
        this.userEmail = CrashlyticsCore.sanitizeAttribute(email);
        this.handler.cacheUserData(this.userId, this.userName, this.userEmail);
    }

    public void setString(String key, String value) {
        if (this.disabled) {
            return;
        }
        if (key == null) {
            Context context = this.getContext();
            if (context != null && CommonUtils.isAppDebuggable((Context)context)) {
                throw new IllegalArgumentException("Custom attribute key must not be null.");
            }
            Fabric.getLogger().e(TAG, "Attempting to set custom attribute with null key, ignoring.", null);
            return;
        }
        key = CrashlyticsCore.sanitizeAttribute(key);
        if (this.attributes.size() >= 64 && !this.attributes.containsKey(key)) {
            Fabric.getLogger().d(TAG, "Exceeded maximum number of custom attributes (64)");
            return;
        }
        value = value == null ? "" : CrashlyticsCore.sanitizeAttribute(value);
        this.attributes.put(key, value);
        this.handler.cacheKeyData(this.attributes);
    }

    public void setBool(String key, boolean value) {
        this.setString(key, Boolean.toString(value));
    }

    public void setDouble(String key, double value) {
        this.setString(key, Double.toString(value));
    }

    public void setFloat(String key, float value) {
        this.setString(key, Float.toString(value));
    }

    public void setInt(String key, int value) {
        this.setString(key, Integer.toString(value));
    }

    public void setLong(String key, long value) {
        this.setString(key, Long.toString(value));
    }

    public void crash() {
        new CrashTest().indexOutOfBounds();
    }

    public boolean verifyPinning(URL url) {
        try {
            return this.internalVerifyPinning(url);
        }
        catch (Exception e) {
            Fabric.getLogger().e(TAG, "Could not verify SSL pinning", (Throwable)e);
            return false;
        }
    }

    @Deprecated
    public synchronized void setListener(CrashlyticsListener listener) {
        Fabric.getLogger().w(TAG, "Use of setListener is deprecated.");
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null.");
        }
        this.listener = listener;
    }

    static void recordLoggedExceptionEvent(String sessionId, String exceptionName) {
        Answers answers = (Answers)Fabric.getKit(Answers.class);
        if (answers != null) {
            answers.onException(new Crash.LoggedException(sessionId, exceptionName));
        }
    }

    static void recordFatalExceptionEvent(String sessionId, String exceptionName) {
        Answers answers = (Answers)Fabric.getKit(Answers.class);
        if (answers != null) {
            answers.onException(new Crash.FatalException(sessionId, exceptionName));
        }
    }

    Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    BuildIdValidator getBuildIdValidator(String buildId, boolean requireBuildId) {
        return new BuildIdValidator(buildId, requireBuildId);
    }

    String getPackageName() {
        return this.packageName;
    }

    String getApiKey() {
        return this.apiKey;
    }

    String getInstallerPackageName() {
        return this.installerPackageName;
    }

    String getVersionName() {
        return this.versionName;
    }

    String getVersionCode() {
        return this.versionCode;
    }

    String getOverridenSpiEndpoint() {
        return CommonUtils.getStringsFileValue((Context)this.getContext(), (String)CRASHLYTICS_API_ENDPOINT);
    }

    String getBuildId() {
        return this.buildId;
    }

    CrashlyticsUncaughtExceptionHandler getHandler() {
        return this.handler;
    }

    String getUserIdentifier() {
        return this.getIdManager().canCollectUserIds() ? this.userId : null;
    }

    String getUserEmail() {
        return this.getIdManager().canCollectUserIds() ? this.userEmail : null;
    }

    String getUserName() {
        return this.getIdManager().canCollectUserIds() ? this.userName : null;
    }

    private void finishInitSynchronously() {
        PriorityCallable<Void> callable = new PriorityCallable<Void>(){

            public Void call() throws Exception {
                return CrashlyticsCore.this.doInBackground();
            }

            public Priority getPriority() {
                return Priority.IMMEDIATE;
            }
        };
        for (Task task : this.getDependencies()) {
            callable.addDependency(task);
        }
        Future future = this.getFabric().getExecutorService().submit(callable);
        Fabric.getLogger().d(TAG, "Crashlytics detected incomplete initialization on previous app launch. Will initialize synchronously.");
        try {
            future.get(4L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Fabric.getLogger().e(TAG, "Crashlytics was interrupted during initialization.", (Throwable)e);
        }
        catch (ExecutionException e) {
            Fabric.getLogger().e(TAG, "Problem encountered during Crashlytics initialization.", (Throwable)e);
        }
        catch (TimeoutException e) {
            Fabric.getLogger().e(TAG, "Crashlytics timed out during initialization.", (Throwable)e);
        }
    }

    void markInitializationStarted() {
        this.executorServiceWrapper.executeSyncLoggingException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CrashlyticsCore.this.initializationMarker.create();
                Fabric.getLogger().d(CrashlyticsCore.TAG, "Initialization marker file created.");
                return null;
            }
        });
    }

    void markInitializationComplete() {
        this.executorServiceWrapper.executeAsync(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    boolean removed = CrashlyticsCore.this.initializationMarker.remove();
                    Fabric.getLogger().d(CrashlyticsCore.TAG, "Initialization marker file removed: " + removed);
                    return removed;
                }
                catch (Exception e) {
                    Fabric.getLogger().e(CrashlyticsCore.TAG, "Problem encountered deleting Crashlytics initialization marker.", (Throwable)e);
                    return false;
                }
            }
        });
    }

    boolean didPreviousInitializationFail() {
        return this.executorServiceWrapper.executeSyncLoggingException(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return CrashlyticsCore.this.initializationMarker.isPresent();
            }
        });
    }

    void setExternalCrashEventDataProvider(CrashEventDataProvider provider) {
        this.externalCrashEventDataProvider = provider;
    }

    SessionEventData getExternalCrashEventData() {
        SessionEventData eventData = null;
        if (this.externalCrashEventDataProvider != null) {
            eventData = this.externalCrashEventDataProvider.getCrashEventData();
        }
        return eventData;
    }

    boolean internalVerifyPinning(URL url) {
        if (this.getPinningInfoProvider() != null) {
            HttpRequest httpRequest = this.httpRequestFactory.buildHttpRequest(HttpMethod.GET, url.toString());
            HttpsURLConnection conn = (HttpsURLConnection)httpRequest.getConnection();
            conn.setInstanceFollowRedirects(false);
            httpRequest.code();
            return true;
        }
        return false;
    }

    File getSdkDirectory() {
        if (this.sdkDir == null) {
            this.sdkDir = new FileStoreImpl((Kit)this).getFilesDir();
        }
        return this.sdkDir;
    }

    boolean shouldPromptUserBeforeSendingCrashReports() {
        return (Boolean)Settings.getInstance().withSettings((Settings.SettingsAccess)new Settings.SettingsAccess<Boolean>(){

            public Boolean usingSettings(SettingsData settingsData) {
                if (settingsData.featuresData.promptEnabled) {
                    return !CrashlyticsCore.this.shouldSendReportsWithoutPrompting();
                }
                return false;
            }
        }, (Object)false);
    }

    boolean shouldSendReportsWithoutPrompting() {
        PreferenceStoreImpl prefStore = new PreferenceStoreImpl((Kit)this);
        return prefStore.get().getBoolean(PREF_ALWAYS_SEND_REPORTS_KEY, false);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    void setShouldSendUserReportsWithoutPrompting(boolean send) {
        PreferenceStoreImpl prefStore = new PreferenceStoreImpl((Kit)this);
        prefStore.save(prefStore.edit().putBoolean(PREF_ALWAYS_SEND_REPORTS_KEY, send));
    }

    boolean canSendWithUserApproval() {
        return (Boolean)Settings.getInstance().withSettings((Settings.SettingsAccess)new Settings.SettingsAccess<Boolean>(){

            public Boolean usingSettings(SettingsData settingsData) {
                boolean send = true;
                Activity activity = CrashlyticsCore.this.getFabric().getCurrentActivity();
                if (activity != null && !activity.isFinishing() && CrashlyticsCore.this.shouldPromptUserBeforeSendingCrashReports()) {
                    send = CrashlyticsCore.this.getSendDecisionFromUser(activity, settingsData.promptData);
                }
                return send;
            }
        }, (Object)true);
    }

    CreateReportSpiCall getCreateReportSpiCall(SettingsData settingsData) {
        if (settingsData != null) {
            return new DefaultCreateReportSpiCall(this, this.getOverridenSpiEndpoint(), settingsData.appData.reportsUrl, this.httpRequestFactory);
        }
        return null;
    }

    private void checkForPreviousCrash() {
        Boolean foundPreviousCrash = this.executorServiceWrapper.executeSyncLoggingException(new CrashMarkerCheck(this.crashMarker));
        if (!Boolean.TRUE.equals(foundPreviousCrash)) {
            return;
        }
        try {
            this.listener.crashlyticsDidDetectCrashDuringPreviousExecution();
        }
        catch (Exception e) {
            Fabric.getLogger().e(TAG, "Exception thrown by CrashlyticsListener while notifying of previous crash.", (Throwable)e);
        }
    }

    void createCrashMarker() {
        this.crashMarker.create();
    }

    private boolean getSendDecisionFromUser(Activity context, final PromptSettingsData promptData) {
        final DialogStringResolver stringResolver = new DialogStringResolver((Context)context, promptData);
        final OptInLatch latch = new OptInLatch();
        final Activity activity = context;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
                DialogInterface.OnClickListener sendClickListener = new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        latch.setOptIn(true);
                        dialog.dismiss();
                    }
                };
                float density = activity.getResources().getDisplayMetrics().density;
                int textViewPadding = CrashlyticsCore.dipsToPixels(density, 5);
                TextView textView = new TextView((Context)activity);
                textView.setAutoLinkMask(15);
                textView.setText((CharSequence)stringResolver.getMessage());
                textView.setTextAppearance((Context)activity, 16973892);
                textView.setPadding(textViewPadding, textViewPadding, textViewPadding, textViewPadding);
                textView.setFocusable(false);
                ScrollView scrollView = new ScrollView((Context)activity);
                scrollView.setPadding(CrashlyticsCore.dipsToPixels(density, 14), CrashlyticsCore.dipsToPixels(density, 2), CrashlyticsCore.dipsToPixels(density, 10), CrashlyticsCore.dipsToPixels(density, 12));
                scrollView.addView((View)textView);
                builder.setView((View)scrollView).setTitle((CharSequence)stringResolver.getTitle()).setCancelable(false).setNeutralButton((CharSequence)stringResolver.getSendButtonTitle(), sendClickListener);
                if (promptData.showCancelButton) {
                    DialogInterface.OnClickListener cancelClickListener = new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int id) {
                            latch.setOptIn(false);
                            dialog.dismiss();
                        }
                    };
                    builder.setNegativeButton((CharSequence)stringResolver.getCancelButtonTitle(), cancelClickListener);
                }
                if (promptData.showAlwaysSendButton) {
                    DialogInterface.OnClickListener alwaysSendClickListener = new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int id) {
                            CrashlyticsCore.this.setShouldSendUserReportsWithoutPrompting(true);
                            latch.setOptIn(true);
                            dialog.dismiss();
                        }
                    };
                    builder.setPositiveButton((CharSequence)stringResolver.getAlwaysSendButtonTitle(), alwaysSendClickListener);
                }
                builder.show();
            }
        });
        Fabric.getLogger().d(TAG, "Waiting for user opt-in.");
        latch.await();
        return latch.getOptIn();
    }

    static SessionSettingsData getSessionSettingsData() {
        SettingsData settingsData = Settings.getInstance().awaitSettingsData();
        return settingsData == null ? null : settingsData.sessionData;
    }

    private static boolean isRequiringBuildId(Context context) {
        return CommonUtils.getBooleanResourceValue((Context)context, (String)CRASHLYTICS_REQUIRE_BUILD_ID, (boolean)true);
    }

    private static String formatLogMessage(int priority, String tag, String msg) {
        return CommonUtils.logPriorityToString((int)priority) + "/" + tag + " " + msg;
    }

    private static boolean ensureFabricWithCalled(String msg) {
        CrashlyticsCore instance = CrashlyticsCore.getInstance();
        if (instance == null || instance.handler == null) {
            Fabric.getLogger().e(TAG, "Crashlytics must be initialized by calling Fabric.with(Context) " + msg, null);
            return false;
        }
        return true;
    }

    private static String sanitizeAttribute(String input) {
        if (input != null && (input = input.trim()).length() > 1024) {
            input = input.substring(0, 1024);
        }
        return input;
    }

    private static int dipsToPixels(float density, int dips) {
        return (int)(density * (float)dips);
    }

    private static final class NoOpListener
    implements CrashlyticsListener {
        private NoOpListener() {
        }

        @Override
        public void crashlyticsDidDetectCrashDuringPreviousExecution() {
        }
    }

    private static final class CrashMarkerCheck
    implements Callable<Boolean> {
        private final CrashlyticsFileMarker crashMarker;

        public CrashMarkerCheck(CrashlyticsFileMarker crashMarker) {
            this.crashMarker = crashMarker;
        }

        @Override
        public Boolean call() throws Exception {
            if (!this.crashMarker.isPresent()) {
                return Boolean.FALSE;
            }
            Fabric.getLogger().d(CrashlyticsCore.TAG, "Found previous crash marker.");
            this.crashMarker.remove();
            return Boolean.TRUE;
        }
    }

    private static class OptInLatch {
        private boolean send = false;
        private final CountDownLatch latch = new CountDownLatch(1);

        private OptInLatch() {
        }

        void setOptIn(boolean optIn) {
            this.send = optIn;
            this.latch.countDown();
        }

        boolean getOptIn() {
            return this.send;
        }

        void await() {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class Builder {
        private float delay = -1.0f;
        private CrashlyticsListener listener;
        private PinningInfoProvider pinningInfoProvider;
        private boolean disabled = false;

        public Builder delay(float delay) {
            if (delay <= 0.0f) {
                throw new IllegalArgumentException("delay must be greater than 0");
            }
            if (this.delay > 0.0f) {
                throw new IllegalStateException("delay already set.");
            }
            this.delay = delay;
            return this;
        }

        public Builder listener(CrashlyticsListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener must not be null.");
            }
            if (this.listener != null) {
                throw new IllegalStateException("listener already set.");
            }
            this.listener = listener;
            return this;
        }

        @Deprecated
        public Builder pinningInfo(PinningInfoProvider pinningInfoProvider) {
            if (pinningInfoProvider == null) {
                throw new IllegalArgumentException("pinningInfoProvider must not be null.");
            }
            if (this.pinningInfoProvider != null) {
                throw new IllegalStateException("pinningInfoProvider already set.");
            }
            this.pinningInfoProvider = pinningInfoProvider;
            return this;
        }

        public Builder disabled(boolean isDisabled) {
            this.disabled = isDisabled;
            return this;
        }

        public CrashlyticsCore build() {
            if (this.delay < 0.0f) {
                this.delay = 1.0f;
            }
            return new CrashlyticsCore(this.delay, this.listener, this.pinningInfoProvider, this.disabled);
        }
    }
}

