/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import com.crashlytics.android.core.CLSUUID;
import com.crashlytics.android.core.ClsFileOutputStream;
import com.crashlytics.android.core.CodedOutputStream;
import com.crashlytics.android.core.CrashlyticsCore;
import com.crashlytics.android.core.CrashlyticsExecutorServiceWrapper;
import com.crashlytics.android.core.CreateReportSpiCall;
import com.crashlytics.android.core.DevicePowerStateListener;
import com.crashlytics.android.core.LogFileManager;
import com.crashlytics.android.core.MetaDataStore;
import com.crashlytics.android.core.MiddleOutFallbackStrategy;
import com.crashlytics.android.core.NativeCrashWriter;
import com.crashlytics.android.core.RemoveRepeatsStrategy;
import com.crashlytics.android.core.ReportUploader;
import com.crashlytics.android.core.SessionProtobufHelper;
import com.crashlytics.android.core.SessionReport;
import com.crashlytics.android.core.StackTraceTrimmingStrategy;
import com.crashlytics.android.core.TrimmedThrowableData;
import com.crashlytics.android.core.UnityVersionProvider;
import com.crashlytics.android.core.UserMetaData;
import com.crashlytics.android.core.Utils;
import com.crashlytics.android.core.internal.models.SessionEventData;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.DeliveryMechanism;
import io.fabric.sdk.android.services.common.IdManager;
import io.fabric.sdk.android.services.persistence.FileStore;
import io.fabric.sdk.android.services.settings.SessionSettingsData;
import io.fabric.sdk.android.services.settings.Settings;
import io.fabric.sdk.android.services.settings.SettingsData;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CrashlyticsUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    static final FilenameFilter SESSION_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String filename) {
            return filename.length() == 35 + ".cls".length() && filename.endsWith(".cls");
        }
    };
    static final Comparator<File> LARGEST_FILE_NAME_FIRST = new Comparator<File>(){

        @Override
        public int compare(File file1, File file2) {
            return file2.getName().compareTo(file1.getName());
        }
    };
    static final Comparator<File> SMALLEST_FILE_NAME_FIRST = new Comparator<File>(){

        @Override
        public int compare(File file1, File file2) {
            return file1.getName().compareTo(file2.getName());
        }
    };
    static final FilenameFilter ANY_SESSION_FILENAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File file, String filename) {
            return SESSION_FILE_PATTERN.matcher(filename).matches();
        }
    };
    private static final Pattern SESSION_FILE_PATTERN = Pattern.compile("([\\d|A-Z|a-z]{12}\\-[\\d|A-Z|a-z]{4}\\-[\\d|A-Z|a-z]{4}\\-[\\d|A-Z|a-z]{12}).+");
    private static final Map<String, String> SEND_AT_CRASHTIME_HEADER = Collections.singletonMap("X-CRASHLYTICS-SEND-FLAGS", "1");
    private static final int MAX_LOCAL_LOGGED_EXCEPTIONS = 64;
    static final int MAX_OPEN_SESSIONS = 8;
    private static final int MAX_COMPLETE_SESSIONS_COUNT = 4;
    static final int MAX_INVALID_SESSIONS = 4;
    static final int MAX_STACK_SIZE = 1024;
    static final int NUM_STACK_REPETITIONS_ALLOWED = 10;
    static final String INVALID_CLS_CACHE_DIR = "invalidClsFiles";
    private static final String GENERATOR_FORMAT = "Crashlytics Android SDK/%s";
    private static final String EVENT_TYPE_CRASH = "crash";
    private static final String EVENT_TYPE_LOGGED = "error";
    private static final int SESSION_ID_LENGTH = 35;
    private static final int ANALYZER_VERSION = 1;
    static final String SESSION_USER_TAG = "SessionUser";
    static final String SESSION_NON_FATAL_TAG = "SessionEvent";
    static final String SESSION_FATAL_TAG = "SessionCrash";
    static final String SESSION_APP_TAG = "SessionApp";
    static final String SESSION_OS_TAG = "SessionOS";
    static final String SESSION_DEVICE_TAG = "SessionDevice";
    static final String SESSION_BEGIN_TAG = "BeginSession";
    static final String SESSION_EVENT_MISSING_BINARY_IMGS_TAG = "SessionMissingBinaryImages";
    private static final String[] INITIAL_SESSION_PART_TAGS = new String[]{"SessionUser", "SessionApp", "SessionOS", "SessionDevice"};
    private final AtomicInteger eventCounter = new AtomicInteger(0);
    private final Thread.UncaughtExceptionHandler defaultHandler;
    private final FileStore fileStore;
    private final AtomicBoolean isHandlingException;
    private final CrashlyticsExecutorServiceWrapper executorServiceWrapper;
    private final IdManager idManager;
    private final StackTraceTrimmingStrategy stackTraceTrimmingStrategy;
    private final CrashlyticsCore crashlyticsCore;
    private final LogFileManager logFileManager;
    private final DevicePowerStateListener devicePowerStateListener;
    private final String unityVersion;
    private final File invalidFilesDir;

    CrashlyticsUncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler, CrashlyticsExecutorServiceWrapper executorServiceWrapper, IdManager idManager, UnityVersionProvider unityVersionProvider, FileStore fileStore, CrashlyticsCore crashlyticsCore) {
        this.defaultHandler = handler;
        this.executorServiceWrapper = executorServiceWrapper;
        this.idManager = idManager;
        this.crashlyticsCore = crashlyticsCore;
        this.unityVersion = unityVersionProvider.getUnityVersion();
        this.fileStore = fileStore;
        this.invalidFilesDir = new File(this.getFilesDir(), INVALID_CLS_CACHE_DIR);
        this.isHandlingException = new AtomicBoolean(false);
        Context context = crashlyticsCore.getContext();
        this.logFileManager = new LogFileManager(context, fileStore);
        this.devicePowerStateListener = new DevicePowerStateListener(context);
        this.stackTraceTrimmingStrategy = new MiddleOutFallbackStrategy(1024, new RemoveRepeatsStrategy(10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void uncaughtException(final Thread thread, final Throwable ex) {
        this.isHandlingException.set(true);
        try {
            Fabric.getLogger().d("CrashlyticsCore", "Crashlytics is handling uncaught exception \"" + ex + "\" from thread " + thread.getName());
            this.devicePowerStateListener.dispose();
            final Date now = new Date();
            this.executorServiceWrapper.executeSyncLoggingException(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    CrashlyticsUncaughtExceptionHandler.this.handleUncaughtException(now, thread, ex);
                    return null;
                }
            });
        }
        catch (Exception e) {
            Fabric.getLogger().e("CrashlyticsCore", "An error occurred in the uncaught exception handler", (Throwable)e);
        }
        finally {
            Fabric.getLogger().d("CrashlyticsCore", "Crashlytics completed exception processing. Invoking default exception handler.");
            this.defaultHandler.uncaughtException(thread, ex);
            this.isHandlingException.set(false);
        }
    }

    private void handleUncaughtException(Date time, Thread thread, Throwable ex) throws Exception {
        this.crashlyticsCore.createCrashMarker();
        this.writeFatal(time, thread, ex);
        this.doCloseSessions();
        this.doOpenSession();
        this.trimSessionFiles();
        if (!this.crashlyticsCore.shouldPromptUserBeforeSendingCrashReports()) {
            this.sendSessionReports();
        }
    }

    boolean isHandlingException() {
        return this.isHandlingException.get();
    }

    File getInvalidFilesDir() {
        return this.invalidFilesDir;
    }

    void writeToLog(final long timestamp, final String msg) {
        this.executorServiceWrapper.executeAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (!CrashlyticsUncaughtExceptionHandler.this.isHandlingException.get()) {
                    CrashlyticsUncaughtExceptionHandler.this.logFileManager.writeToLog(timestamp, msg);
                }
                return null;
            }
        });
    }

    void writeNonFatalException(final Thread thread, final Throwable ex) {
        final Date now = new Date();
        this.executorServiceWrapper.executeAsync(new Runnable(){

            @Override
            public void run() {
                if (!CrashlyticsUncaughtExceptionHandler.this.isHandlingException.get()) {
                    CrashlyticsUncaughtExceptionHandler.this.doWriteNonFatal(now, thread, ex);
                }
            }
        });
    }

    void cacheUserData(final String userId, final String userName, final String userEmail) {
        this.executorServiceWrapper.executeAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String currentSessionId = CrashlyticsUncaughtExceptionHandler.this.getCurrentSessionId();
                new MetaDataStore(CrashlyticsUncaughtExceptionHandler.this.getFilesDir()).writeUserData(currentSessionId, new UserMetaData(userId, userName, userEmail));
                return null;
            }
        });
    }

    void cacheKeyData(final Map<String, String> keyData) {
        this.executorServiceWrapper.executeAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String currentSessionId = CrashlyticsUncaughtExceptionHandler.this.getCurrentSessionId();
                new MetaDataStore(CrashlyticsUncaughtExceptionHandler.this.getFilesDir()).writeKeyData(currentSessionId, keyData);
                return null;
            }
        });
    }

    void openSession() {
        this.executorServiceWrapper.executeAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CrashlyticsUncaughtExceptionHandler.this.doOpenSession();
                return null;
            }
        });
    }

    private String getCurrentSessionId() {
        File[] sessionBeginFiles = this.listSortedSessionBeginFiles();
        return sessionBeginFiles.length > 0 ? CrashlyticsUncaughtExceptionHandler.getSessionIdFromSessionFile(sessionBeginFiles[0]) : null;
    }

    private String getPreviousSessionId() {
        File[] sessionBeginFiles = this.listSortedSessionBeginFiles();
        return sessionBeginFiles.length > 1 ? CrashlyticsUncaughtExceptionHandler.getSessionIdFromSessionFile(sessionBeginFiles[1]) : null;
    }

    static String getSessionIdFromSessionFile(File sessionFile) {
        return sessionFile.getName().substring(0, 35);
    }

    boolean hasOpenSession() {
        return this.listSessionBeginFiles().length > 0;
    }

    boolean finalizeSessions() {
        return this.executorServiceWrapper.executeSyncLoggingException(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (CrashlyticsUncaughtExceptionHandler.this.isHandlingException.get()) {
                    Fabric.getLogger().d("CrashlyticsCore", "Skipping session finalization because a crash has already occurred.");
                    return Boolean.FALSE;
                }
                Fabric.getLogger().d("CrashlyticsCore", "Finalizing previously open sessions.");
                CrashlyticsUncaughtExceptionHandler.this.doCloseSessions(true);
                Fabric.getLogger().d("CrashlyticsCore", "Closed all previously open sessions");
                return Boolean.TRUE;
            }
        });
    }

    private void doOpenSession() throws Exception {
        Date startedAt = new Date();
        String sessionIdentifier = new CLSUUID(this.idManager).toString();
        Fabric.getLogger().d("CrashlyticsCore", "Opening an new session with ID " + sessionIdentifier);
        this.writeBeginSession(sessionIdentifier, startedAt);
        this.writeSessionApp(sessionIdentifier);
        this.writeSessionOS(sessionIdentifier);
        this.writeSessionDevice(sessionIdentifier);
        this.logFileManager.setCurrentSession(sessionIdentifier);
    }

    void doCloseSessions() throws Exception {
        this.doCloseSessions(false);
    }

    private void doCloseSessions(boolean excludeCurrent) throws Exception {
        int offset = excludeCurrent ? 1 : 0;
        this.trimOpenSessions(8 + offset);
        File[] sessionBeginFiles = this.listSortedSessionBeginFiles();
        if (sessionBeginFiles.length <= offset) {
            Fabric.getLogger().d("CrashlyticsCore", "No open sessions to be closed.");
            return;
        }
        String mostRecentSessionIdToClose = CrashlyticsUncaughtExceptionHandler.getSessionIdFromSessionFile(sessionBeginFiles[offset]);
        this.writeSessionUser(mostRecentSessionIdToClose);
        CrashlyticsUncaughtExceptionHandler crashlyticsUncaughtExceptionHandler = this;
        SessionSettingsData settingsData = crashlyticsUncaughtExceptionHandler.crashlyticsCore.getSessionSettingsData();
        if (settingsData == null) {
            Fabric.getLogger().d("CrashlyticsCore", "Unable to close session. Settings are not loaded.");
            return;
        }
        this.closeOpenSessions(sessionBeginFiles, offset, settingsData.maxCustomExceptionEvents);
    }

    private void closeOpenSessions(File[] sessionBeginFiles, int beginIndex, int maxLoggedExceptionsCount) {
        Fabric.getLogger().d("CrashlyticsCore", "Closing open sessions.");
        for (int i = beginIndex; i < sessionBeginFiles.length; ++i) {
            File sessionBeginFile = sessionBeginFiles[i];
            String sessionIdentifier = CrashlyticsUncaughtExceptionHandler.getSessionIdFromSessionFile(sessionBeginFile);
            Fabric.getLogger().d("CrashlyticsCore", "Closing session: " + sessionIdentifier);
            this.writeSessionPartsToSessionFile(sessionBeginFile, sessionIdentifier, maxLoggedExceptionsCount);
        }
    }

    private void closeWithoutRenamingOrLog(ClsFileOutputStream fos) {
        if (fos == null) {
            return;
        }
        try {
            fos.closeInProgressStream();
        }
        catch (IOException ex) {
            Fabric.getLogger().e("CrashlyticsCore", "Error closing session file stream in the presence of an exception", (Throwable)ex);
        }
    }

    private void deleteSessionPartFilesFor(String sessionId) {
        for (File file : this.listSessionPartFilesFor(sessionId)) {
            file.delete();
        }
    }

    private File[] listSessionPartFilesFor(String sessionId) {
        return this.listFilesMatching(new SessionPartFileFilter(sessionId));
    }

    private File[] listCompleteSessionFiles() {
        return this.listFilesMatching(SESSION_FILE_FILTER);
    }

    File[] listSessionBeginFiles() {
        return this.listFilesMatching(new FileNameContainsFilter(SESSION_BEGIN_TAG));
    }

    private File[] listSortedSessionBeginFiles() {
        File[] sessionBeginFiles = this.listSessionBeginFiles();
        Arrays.sort(sessionBeginFiles, LARGEST_FILE_NAME_FIRST);
        return sessionBeginFiles;
    }

    private File[] listFilesMatching(FilenameFilter filter) {
        return this.listFilesMatching(this.getFilesDir(), filter);
    }

    private File[] listFilesMatching(File directory, FilenameFilter filter) {
        return this.ensureFileArrayNotNull(directory.listFiles(filter));
    }

    private File[] listFiles(File directory) {
        return this.ensureFileArrayNotNull(directory.listFiles());
    }

    private File[] ensureFileArrayNotNull(File[] files) {
        return files == null ? new File[]{} : files;
    }

    private void trimSessionEventFiles(String sessionId, int limit) {
        Utils.capFileCount(this.getFilesDir(), new FileNameContainsFilter(sessionId + SESSION_NON_FATAL_TAG), limit, SMALLEST_FILE_NAME_FIRST);
    }

    void trimSessionFiles() {
        Utils.capFileCount(this.getFilesDir(), SESSION_FILE_FILTER, 4, SMALLEST_FILE_NAME_FIRST);
    }

    private void trimOpenSessions(int maxOpenSessionCount) {
        HashSet<String> sessionIdsToKeep = new HashSet<String>();
        File[] beginSessionFiles = this.listSortedSessionBeginFiles();
        int count = Math.min(maxOpenSessionCount, beginSessionFiles.length);
        for (int i = 0; i < count; ++i) {
            String sessionId = CrashlyticsUncaughtExceptionHandler.getSessionIdFromSessionFile(beginSessionFiles[i]);
            sessionIdsToKeep.add(sessionId);
        }
        this.logFileManager.discardOldLogFiles(sessionIdsToKeep);
        this.retainSessions(this.listFilesMatching(new AnySessionPartFileFilter()), sessionIdsToKeep);
    }

    private void retainSessions(File[] files, Set<String> sessionIdsToKeep) {
        for (File sessionPartFile : files) {
            String fileName = sessionPartFile.getName();
            Matcher matcher = SESSION_FILE_PATTERN.matcher(fileName);
            if (!matcher.matches()) {
                Fabric.getLogger().d("CrashlyticsCore", "Deleting unknown file: " + fileName);
                sessionPartFile.delete();
                break;
            }
            String sessionId = matcher.group(1);
            if (sessionIdsToKeep.contains(sessionId)) continue;
            Fabric.getLogger().d("CrashlyticsCore", "Trimming session file: " + fileName);
            sessionPartFile.delete();
        }
    }

    private File[] getTrimmedNonFatalFiles(String sessionId, File[] nonFatalFiles, int maxLoggedExceptionsCount) {
        if (nonFatalFiles.length > maxLoggedExceptionsCount) {
            Fabric.getLogger().d("CrashlyticsCore", String.format(Locale.US, "Trimming down to %d logged exceptions.", maxLoggedExceptionsCount));
            this.trimSessionEventFiles(sessionId, maxLoggedExceptionsCount);
            nonFatalFiles = this.listFilesMatching(new FileNameContainsFilter(sessionId + SESSION_NON_FATAL_TAG));
        }
        return nonFatalFiles;
    }

    void cleanInvalidTempFiles() {
        this.executorServiceWrapper.executeAsync(new Runnable(){

            @Override
            public void run() {
                CrashlyticsUncaughtExceptionHandler.this.doCleanInvalidTempFiles(CrashlyticsUncaughtExceptionHandler.this.listFilesMatching(new InvalidPartFileFilter()));
            }
        });
    }

    void doCleanInvalidTempFiles(File[] invalidFiles) {
        final HashSet<String> invalidSessionIds = new HashSet<String>();
        for (File invalidFile : invalidFiles) {
            Fabric.getLogger().d("CrashlyticsCore", "Found invalid session part file: " + invalidFile);
            invalidSessionIds.add(CrashlyticsUncaughtExceptionHandler.getSessionIdFromSessionFile(invalidFile));
        }
        if (invalidSessionIds.isEmpty()) {
            return;
        }
        if (!this.invalidFilesDir.exists()) {
            this.invalidFilesDir.mkdir();
        }
        FilenameFilter invalidSessionFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                if (filename.length() < 35) {
                    return false;
                }
                return invalidSessionIds.contains(filename.substring(0, 35));
            }
        };
        for (File sessionFile : this.listFilesMatching(invalidSessionFilter)) {
            Fabric.getLogger().d("CrashlyticsCore", "Moving session file: " + sessionFile);
            if (sessionFile.renameTo(new File(this.invalidFilesDir, sessionFile.getName()))) continue;
            Fabric.getLogger().d("CrashlyticsCore", "Could not move session file. Deleting " + sessionFile);
            sessionFile.delete();
        }
        this.trimInvalidSessionFiles();
    }

    private void trimInvalidSessionFiles() {
        if (!this.invalidFilesDir.exists()) {
            return;
        }
        File[] oldInvalidFiles = this.listFilesMatching(this.invalidFilesDir, new InvalidPartFileFilter());
        Arrays.sort(oldInvalidFiles, Collections.reverseOrder());
        HashSet<String> sessionIdsToKeep = new HashSet<String>();
        for (int i = 0; i < oldInvalidFiles.length && sessionIdsToKeep.size() < 4; ++i) {
            sessionIdsToKeep.add(CrashlyticsUncaughtExceptionHandler.getSessionIdFromSessionFile(oldInvalidFiles[i]));
        }
        this.retainSessions(this.listFiles(this.invalidFilesDir), sessionIdsToKeep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFatal(Date time, Thread thread, Throwable ex) {
        block7: {
            ClsFileOutputStream fos = null;
            CodedOutputStream cos = null;
            try {
                String currentSessionId = this.getCurrentSessionId();
                if (currentSessionId == null) {
                    Fabric.getLogger().e("CrashlyticsCore", "Tried to write a fatal exception while no session was open.", null);
                    return;
                }
                CrashlyticsCore.recordFatalExceptionEvent(currentSessionId, ex.getClass().getName());
                fos = new ClsFileOutputStream(this.getFilesDir(), currentSessionId + SESSION_FATAL_TAG);
                cos = CodedOutputStream.newInstance(fos);
                this.writeSessionEvent(cos, time, thread, ex, EVENT_TYPE_CRASH, true);
                CommonUtils.flushOrLog((Flushable)cos, (String)"Failed to flush to session begin file.");
            }
            catch (Exception e) {
                Fabric.getLogger().e("CrashlyticsCore", "An error occurred in the fatal exception logger", (Throwable)e);
                break block7;
            }
            finally {
                CommonUtils.flushOrLog(cos, (String)"Failed to flush to session begin file.");
                CommonUtils.closeOrLog(fos, (String)"Failed to close fatal exception file output stream.");
            }
            CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close fatal exception file output stream.");
        }
    }

    void writeExternalCrashEvent(final SessionEventData crashEventData) {
        this.executorServiceWrapper.executeAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (!CrashlyticsUncaughtExceptionHandler.this.isHandlingException.get()) {
                    CrashlyticsUncaughtExceptionHandler.this.doWriteExternalCrashEvent(crashEventData);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriteExternalCrashEvent(SessionEventData crashEventData) throws IOException {
        block7: {
            ClsFileOutputStream fos = null;
            CodedOutputStream cos = null;
            try {
                String previousSessionId = this.getPreviousSessionId();
                if (previousSessionId == null) {
                    Fabric.getLogger().e("CrashlyticsCore", "Tried to write a native crash while no session was open.", null);
                    return;
                }
                CrashlyticsCore.recordFatalExceptionEvent(previousSessionId, String.format(Locale.US, "<native-crash [%s (%s)]>", crashEventData.signal.code, crashEventData.signal.name));
                boolean hasBinaryImages = crashEventData.binaryImages != null && crashEventData.binaryImages.length > 0;
                String fileTag = hasBinaryImages ? SESSION_FATAL_TAG : SESSION_EVENT_MISSING_BINARY_IMGS_TAG;
                fos = new ClsFileOutputStream(this.getFilesDir(), previousSessionId + fileTag);
                cos = CodedOutputStream.newInstance(fos);
                Map<String, String> storedKeyData = new MetaDataStore(this.getFilesDir()).readKeyData(previousSessionId);
                LogFileManager previousSessionLogManager = new LogFileManager(this.crashlyticsCore.getContext(), this.fileStore, previousSessionId);
                NativeCrashWriter.writeNativeCrash(crashEventData, previousSessionLogManager, storedKeyData, cos);
                CommonUtils.flushOrLog((Flushable)cos, (String)"Failed to flush to session begin file.");
            }
            catch (Exception e) {
                Fabric.getLogger().e("CrashlyticsCore", "An error occurred in the native crash logger", (Throwable)e);
                break block7;
            }
            finally {
                CommonUtils.flushOrLog(cos, (String)"Failed to flush to session begin file.");
                CommonUtils.closeOrLog(fos, (String)"Failed to close fatal exception file output stream.");
            }
            CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close fatal exception file output stream.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriteNonFatal(Date time, Thread thread, Throwable ex) {
        String currentSessionId;
        block8: {
            currentSessionId = this.getCurrentSessionId();
            if (currentSessionId == null) {
                Fabric.getLogger().e("CrashlyticsCore", "Tried to write a non-fatal exception while no session was open.", null);
                return;
            }
            CrashlyticsCore.recordLoggedExceptionEvent(currentSessionId, ex.getClass().getName());
            ClsFileOutputStream fos = null;
            CodedOutputStream cos = null;
            try {
                Fabric.getLogger().d("CrashlyticsCore", "Crashlytics is logging non-fatal exception \"" + ex + "\" from thread " + thread.getName());
                String counterString = CommonUtils.padWithZerosToMaxIntWidth((int)this.eventCounter.getAndIncrement());
                String nonFatalFileName = currentSessionId + SESSION_NON_FATAL_TAG + counterString;
                fos = new ClsFileOutputStream(this.getFilesDir(), nonFatalFileName);
                cos = CodedOutputStream.newInstance(fos);
                this.writeSessionEvent(cos, time, thread, ex, EVENT_TYPE_LOGGED, false);
                CommonUtils.flushOrLog((Flushable)cos, (String)"Failed to flush to non-fatal file.");
            }
            catch (Exception e) {
                Fabric.getLogger().e("CrashlyticsCore", "An error occurred in the non-fatal exception logger", (Throwable)e);
                break block8;
            }
            finally {
                CommonUtils.flushOrLog(cos, (String)"Failed to flush to non-fatal file.");
                CommonUtils.closeOrLog(fos, (String)"Failed to close non-fatal file output stream.");
            }
            CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close non-fatal file output stream.");
        }
        try {
            this.trimSessionEventFiles(currentSessionId, 64);
        }
        catch (Exception e) {
            Fabric.getLogger().e("CrashlyticsCore", "An error occurred when trimming non-fatal files.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBeginSession(String sessionId, Date startedAt) throws Exception {
        ClsFileOutputStream fos = null;
        CodedOutputStream cos = null;
        try {
            fos = new ClsFileOutputStream(this.getFilesDir(), sessionId + SESSION_BEGIN_TAG);
            cos = CodedOutputStream.newInstance(fos);
            String generator = String.format(Locale.US, GENERATOR_FORMAT, this.crashlyticsCore.getVersion());
            long startedAtSeconds = startedAt.getTime() / 1000L;
            SessionProtobufHelper.writeBeginSession(cos, sessionId, generator, startedAtSeconds);
        }
        catch (Throwable throwable) {
            CommonUtils.flushOrLog(cos, (String)"Failed to flush to session begin file.");
            CommonUtils.closeOrLog(fos, (String)"Failed to close begin session file.");
            throw throwable;
        }
        CommonUtils.flushOrLog((Flushable)cos, (String)"Failed to flush to session begin file.");
        CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close begin session file.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSessionApp(String sessionId) throws Exception {
        ClsFileOutputStream fos = null;
        CodedOutputStream cos = null;
        try {
            fos = new ClsFileOutputStream(this.getFilesDir(), sessionId + SESSION_APP_TAG);
            cos = CodedOutputStream.newInstance(fos);
            String appIdentifier = this.idManager.getAppIdentifier();
            String apiKey = this.crashlyticsCore.getApiKey();
            String versionCode = this.crashlyticsCore.getVersionCode();
            String versionName = this.crashlyticsCore.getVersionName();
            String installUuid = this.idManager.getAppInstallIdentifier();
            int deliveryMechanism = DeliveryMechanism.determineFrom((String)this.crashlyticsCore.getInstallerPackageName()).getId();
            SessionProtobufHelper.writeSessionApp(cos, appIdentifier, apiKey, versionCode, versionName, installUuid, deliveryMechanism, this.unityVersion);
        }
        catch (Throwable throwable) {
            CommonUtils.flushOrLog(cos, (String)"Failed to flush to session app file.");
            CommonUtils.closeOrLog(fos, (String)"Failed to close session app file.");
            throw throwable;
        }
        CommonUtils.flushOrLog((Flushable)cos, (String)"Failed to flush to session app file.");
        CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close session app file.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSessionOS(String sessionId) throws Exception {
        ClsFileOutputStream fos = null;
        CodedOutputStream cos = null;
        try {
            fos = new ClsFileOutputStream(this.getFilesDir(), sessionId + SESSION_OS_TAG);
            cos = CodedOutputStream.newInstance(fos);
            boolean isRooted = CommonUtils.isRooted((Context)this.crashlyticsCore.getContext());
            SessionProtobufHelper.writeSessionOS(cos, isRooted);
        }
        catch (Throwable throwable) {
            CommonUtils.flushOrLog(cos, (String)"Failed to flush to session OS file.");
            CommonUtils.closeOrLog(fos, (String)"Failed to close session OS file.");
            throw throwable;
        }
        CommonUtils.flushOrLog((Flushable)cos, (String)"Failed to flush to session OS file.");
        CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close session OS file.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSessionDevice(String sessionId) throws Exception {
        ClsFileOutputStream fos = null;
        CodedOutputStream cos = null;
        try {
            fos = new ClsFileOutputStream(this.getFilesDir(), sessionId + SESSION_DEVICE_TAG);
            cos = CodedOutputStream.newInstance(fos);
            Context context = this.crashlyticsCore.getContext();
            StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
            String clsDeviceId = this.idManager.getDeviceUUID();
            int arch = CommonUtils.getCpuArchitectureInt();
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            long totalRam = CommonUtils.getTotalRamInBytes();
            long diskSpace = (long)statFs.getBlockCount() * (long)statFs.getBlockSize();
            boolean isEmulator = CommonUtils.isEmulator((Context)context);
            Map ids = this.idManager.getDeviceIdentifiers();
            int state = CommonUtils.getDeviceState((Context)context);
            SessionProtobufHelper.writeSessionDevice(cos, clsDeviceId, arch, Build.MODEL, availableProcessors, totalRam, diskSpace, isEmulator, ids, state, Build.MANUFACTURER, Build.PRODUCT);
        }
        catch (Throwable throwable) {
            CommonUtils.flushOrLog(cos, (String)"Failed to flush session device info.");
            CommonUtils.closeOrLog(fos, (String)"Failed to close session device file.");
            throw throwable;
        }
        CommonUtils.flushOrLog((Flushable)cos, (String)"Failed to flush session device info.");
        CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close session device file.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSessionUser(String sessionId) throws Exception {
        UserMetaData userMetaData;
        CodedOutputStream cos;
        ClsFileOutputStream fos;
        block3: {
            fos = null;
            cos = null;
            try {
                fos = new ClsFileOutputStream(this.getFilesDir(), sessionId + SESSION_USER_TAG);
                cos = CodedOutputStream.newInstance(fos);
                userMetaData = this.getUserMetaData(sessionId);
                if (!userMetaData.isEmpty()) break block3;
            }
            catch (Throwable throwable) {
                CommonUtils.flushOrLog(cos, (String)"Failed to flush session user file.");
                CommonUtils.closeOrLog(fos, (String)"Failed to close session user file.");
                throw throwable;
            }
            CommonUtils.flushOrLog((Flushable)cos, (String)"Failed to flush session user file.");
            CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close session user file.");
            return;
        }
        SessionProtobufHelper.writeSessionUser(cos, userMetaData.id, userMetaData.name, userMetaData.email);
        CommonUtils.flushOrLog((Flushable)cos, (String)"Failed to flush session user file.");
        CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close session user file.");
    }

    private void writeSessionEvent(CodedOutputStream cos, Date time, Thread thread, Throwable ex, String eventType, boolean includeAllThreads) throws Exception {
        Map<Object, Object> attributes;
        Thread[] threads;
        TrimmedThrowableData trimmedEx = new TrimmedThrowableData(ex, this.stackTraceTrimmingStrategy);
        Context context = this.crashlyticsCore.getContext();
        long eventTime = time.getTime() / 1000L;
        Float batteryLevel = CommonUtils.getBatteryLevel((Context)context);
        int batteryVelocity = CommonUtils.getBatteryVelocity((Context)context, (boolean)this.devicePowerStateListener.isPowerConnected());
        boolean proximityEnabled = CommonUtils.getProximitySensorEnabled((Context)context);
        int orientation = context.getResources().getConfiguration().orientation;
        long usedRamBytes = CommonUtils.getTotalRamInBytes() - CommonUtils.calculateFreeRamInBytes((Context)context);
        long diskUsedBytes = CommonUtils.calculateUsedDiskSpaceInBytes((String)Environment.getDataDirectory().getPath());
        ActivityManager.RunningAppProcessInfo runningAppProcessInfo = CommonUtils.getAppProcessInfo((String)context.getPackageName(), (Context)context);
        LinkedList<StackTraceElement[]> stacks = new LinkedList<StackTraceElement[]>();
        StackTraceElement[] exceptionStack = trimmedEx.stacktrace;
        String buildId = this.crashlyticsCore.getBuildId();
        String appIdentifier = this.idManager.getAppIdentifier();
        if (includeAllThreads) {
            Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
            threads = new Thread[allStackTraces.size()];
            int i = 0;
            for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
                threads[i] = entry.getKey();
                stacks.add(this.stackTraceTrimmingStrategy.getTrimmedStackTrace(entry.getValue()));
                ++i;
            }
        } else {
            threads = new Thread[]{};
        }
        if (!CommonUtils.getBooleanResourceValue((Context)context, (String)"com.crashlytics.CollectCustomKeys", (boolean)true)) {
            attributes = new TreeMap();
        } else {
            attributes = this.crashlyticsCore.getAttributes();
            if (attributes != null && attributes.size() > 1) {
                attributes = new TreeMap<Object, Object>(attributes);
            }
        }
        SessionProtobufHelper.writeSessionEvent(cos, eventTime, eventType, trimmedEx, thread, exceptionStack, threads, stacks, attributes, this.logFileManager, runningAppProcessInfo, orientation, appIdentifier, buildId, batteryLevel, batteryVelocity, proximityEnabled, usedRamBytes, diskUsedBytes);
    }

    private void writeSessionPartsToSessionFile(File sessionBeginFile, String sessionId, int maxLoggedExceptionsCount) {
        Fabric.getLogger().d("CrashlyticsCore", "Collecting session parts for ID " + sessionId);
        File[] fatalFiles = this.listFilesMatching(new FileNameContainsFilter(sessionId + SESSION_FATAL_TAG));
        boolean hasFatal = fatalFiles != null && fatalFiles.length > 0;
        Fabric.getLogger().d("CrashlyticsCore", String.format(Locale.US, "Session %s has fatal exception: %s", sessionId, hasFatal));
        File[] nonFatalFiles = this.listFilesMatching(new FileNameContainsFilter(sessionId + SESSION_NON_FATAL_TAG));
        boolean hasNonFatal = nonFatalFiles != null && nonFatalFiles.length > 0;
        Fabric.getLogger().d("CrashlyticsCore", String.format(Locale.US, "Session %s has non-fatal exceptions: %s", sessionId, hasNonFatal));
        if (hasFatal || hasNonFatal) {
            File[] trimmedNonFatalFiles = this.getTrimmedNonFatalFiles(sessionId, nonFatalFiles, maxLoggedExceptionsCount);
            File fatalFile = hasFatal ? fatalFiles[0] : null;
            this.synthesizeSessionFile(sessionBeginFile, sessionId, trimmedNonFatalFiles, fatalFile);
        } else {
            Fabric.getLogger().d("CrashlyticsCore", "No events present for session ID " + sessionId);
        }
        Fabric.getLogger().d("CrashlyticsCore", "Removing session part files for ID " + sessionId);
        this.deleteSessionPartFilesFor(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synthesizeSessionFile(File sessionBeginFile, String sessionId, File[] nonFatalFiles, File fatalFile) {
        CodedOutputStream cos;
        ClsFileOutputStream fos;
        boolean exceptionDuringWrite;
        block10: {
            boolean hasFatal = fatalFile != null;
            exceptionDuringWrite = false;
            fos = null;
            cos = null;
            try {
                fos = new ClsFileOutputStream(this.getFilesDir(), sessionId);
                cos = CodedOutputStream.newInstance(fos);
                Fabric.getLogger().d("CrashlyticsCore", "Collecting SessionStart data for session ID " + sessionId);
                CrashlyticsUncaughtExceptionHandler.writeToCosFromFile(cos, sessionBeginFile);
                cos.writeUInt64(4, new Date().getTime() / 1000L);
                cos.writeBool(5, hasFatal);
                cos.writeUInt32(11, 1);
                cos.writeEnum(12, 3);
                this.writeInitialPartsTo(cos, sessionId);
                CrashlyticsUncaughtExceptionHandler.writeNonFatalEventsTo(cos, nonFatalFiles, sessionId);
                if (!hasFatal) break block10;
                CrashlyticsUncaughtExceptionHandler.writeToCosFromFile(cos, fatalFile);
            }
            catch (Exception e) {
                try {
                    Fabric.getLogger().e("CrashlyticsCore", "Failed to write session file for session ID: " + sessionId, (Throwable)e);
                    exceptionDuringWrite = true;
                }
                catch (Throwable throwable) {
                    CommonUtils.flushOrLog(cos, (String)"Error flushing session file stream");
                    if (exceptionDuringWrite) {
                        this.closeWithoutRenamingOrLog(fos);
                    } else {
                        CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close CLS file");
                    }
                    throw throwable;
                }
                CommonUtils.flushOrLog((Flushable)cos, (String)"Error flushing session file stream");
                if (exceptionDuringWrite) {
                    this.closeWithoutRenamingOrLog(fos);
                } else {
                    CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close CLS file");
                }
            }
        }
        CommonUtils.flushOrLog((Flushable)cos, (String)"Error flushing session file stream");
        if (exceptionDuringWrite) {
            this.closeWithoutRenamingOrLog(fos);
        } else {
            CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close CLS file");
        }
    }

    private static void writeNonFatalEventsTo(CodedOutputStream cos, File[] nonFatalFiles, String sessionId) {
        Arrays.sort(nonFatalFiles, CommonUtils.FILE_MODIFIED_COMPARATOR);
        for (File nonFatalFile : nonFatalFiles) {
            try {
                Fabric.getLogger().d("CrashlyticsCore", String.format(Locale.US, "Found Non Fatal for session ID %s in %s ", sessionId, nonFatalFile.getName()));
                CrashlyticsUncaughtExceptionHandler.writeToCosFromFile(cos, nonFatalFile);
            }
            catch (Exception e) {
                Fabric.getLogger().e("CrashlyticsCore", "Error writting non-fatal to session.", (Throwable)e);
            }
        }
    }

    private void writeInitialPartsTo(CodedOutputStream cos, String sessionId) throws IOException {
        for (String tag : INITIAL_SESSION_PART_TAGS) {
            File[] sessionPartFiles = this.listFilesMatching(new FileNameContainsFilter(sessionId + tag));
            if (sessionPartFiles.length == 0) {
                Fabric.getLogger().e("CrashlyticsCore", "Can't find " + tag + " data for session ID " + sessionId, null);
                continue;
            }
            Fabric.getLogger().d("CrashlyticsCore", "Collecting " + tag + " data for session ID " + sessionId);
            CrashlyticsUncaughtExceptionHandler.writeToCosFromFile(cos, sessionPartFiles[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToCosFromFile(CodedOutputStream cos, File file) throws IOException {
        if (!file.exists()) {
            Fabric.getLogger().e("CrashlyticsCore", "Tried to include a file that doesn't exist: " + file.getName(), null);
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            CrashlyticsUncaughtExceptionHandler.copyToCodedOutputStream(fis, cos, (int)file.length());
        }
        finally {
            CommonUtils.closeOrLog((Closeable)fis, (String)"Failed to close file input stream.");
        }
    }

    private static void copyToCodedOutputStream(InputStream inStream, CodedOutputStream cos, int bufferLength) throws IOException {
        int numRead;
        byte[] buffer = new byte[bufferLength];
        for (int offset = 0; offset < buffer.length && (numRead = inStream.read(buffer, offset, buffer.length - offset)) >= 0; offset += numRead) {
        }
        cos.writeRawBytes(buffer);
    }

    private UserMetaData getUserMetaData(String sessionId) {
        return this.isHandlingException() ? new UserMetaData(this.crashlyticsCore.getUserIdentifier(), this.crashlyticsCore.getUserName(), this.crashlyticsCore.getUserEmail()) : new MetaDataStore(this.getFilesDir()).readUserData(sessionId);
    }

    private void sendSessionReports() {
        for (File finishedSessionFile : this.listCompleteSessionFiles()) {
            this.executorServiceWrapper.executeAsync(new SendSessionRunnable(this.crashlyticsCore, finishedSessionFile));
        }
    }

    private File getFilesDir() {
        return this.fileStore.getFilesDir();
    }

    private static final class SendSessionRunnable
    implements Runnable {
        private final CrashlyticsCore crashlyticsCore;
        private final File fileToSend;

        public SendSessionRunnable(CrashlyticsCore crashlyticsCore, File fileToSend) {
            this.crashlyticsCore = crashlyticsCore;
            this.fileToSend = fileToSend;
        }

        @Override
        public void run() {
            if (!CommonUtils.canTryConnection((Context)this.crashlyticsCore.getContext())) {
                return;
            }
            Fabric.getLogger().d("CrashlyticsCore", "Attempting to send crash report at time of crash...");
            SettingsData settingsData = Settings.getInstance().awaitSettingsData();
            CreateReportSpiCall call = this.crashlyticsCore.getCreateReportSpiCall(settingsData);
            if (call != null) {
                new ReportUploader(this.crashlyticsCore.getApiKey(), call).forceUpload(new SessionReport(this.fileToSend, SEND_AT_CRASHTIME_HEADER));
            }
        }
    }

    static class InvalidPartFileFilter
    implements FilenameFilter {
        InvalidPartFileFilter() {
        }

        @Override
        public boolean accept(File file, String fileName) {
            return ClsFileOutputStream.TEMP_FILENAME_FILTER.accept(file, fileName) || fileName.contains(CrashlyticsUncaughtExceptionHandler.SESSION_EVENT_MISSING_BINARY_IMGS_TAG);
        }
    }

    private static class AnySessionPartFileFilter
    implements FilenameFilter {
        private AnySessionPartFileFilter() {
        }

        @Override
        public boolean accept(File file, String fileName) {
            return !SESSION_FILE_FILTER.accept(file, fileName) && SESSION_FILE_PATTERN.matcher(fileName).matches();
        }
    }

    static class SessionPartFileFilter
    implements FilenameFilter {
        private final String sessionId;

        public SessionPartFileFilter(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public boolean accept(File file, String fileName) {
            if (fileName.equals(this.sessionId + ".cls")) {
                return false;
            }
            return fileName.contains(this.sessionId) && !fileName.endsWith(".cls_temp");
        }
    }

    static class FileNameContainsFilter
    implements FilenameFilter {
        private final String string;

        public FileNameContainsFilter(String s) {
            this.string = s;
        }

        @Override
        public boolean accept(File dir, String filename) {
            return filename.contains(this.string) && !filename.endsWith(".cls_temp");
        }
    }
}

