/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import com.crashlytics.android.core.UserMetaData;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.CommonUtils;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class MetaDataStore {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String USERDATA_SUFFIX = "user";
    private static final String KEYDATA_SUFFIX = "keys";
    private static final String METADATA_EXT = ".meta";
    private static final String KEY_USER_ID = "userId";
    private static final String KEY_USER_NAME = "userName";
    private static final String KEY_USER_EMAIL = "userEmail";
    private final File filesDir;

    public MetaDataStore(File filesDir) {
        this.filesDir = filesDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUserData(String sessionId, UserMetaData data) {
        File f = this.getUserDataFileForSession(sessionId);
        BufferedWriter writer = null;
        try {
            String userDataString = MetaDataStore.userDataToJson(data);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), UTF_8));
            writer.write(userDataString);
            ((Writer)writer).flush();
            CommonUtils.closeOrLog((Closeable)writer, (String)"Failed to close user metadata file.");
        }
        catch (Exception e) {
            Fabric.getLogger().e("CrashlyticsCore", "Error serializing user metadata.", (Throwable)e);
        }
        finally {
            CommonUtils.closeOrLog(writer, (String)"Failed to close user metadata file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserMetaData readUserData(String sessionId) {
        File f = this.getUserDataFileForSession(sessionId);
        if (!f.exists()) {
            return UserMetaData.EMPTY;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            UserMetaData userMetaData = MetaDataStore.jsonToUserData(CommonUtils.streamToString((InputStream)is));
            return userMetaData;
        }
        catch (Exception e) {
            Fabric.getLogger().e("CrashlyticsCore", "Error deserializing user metadata.", (Throwable)e);
        }
        finally {
            CommonUtils.closeOrLog((Closeable)is, (String)"Failed to close user metadata file.");
        }
        return UserMetaData.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeKeyData(String sessionId, Map<String, String> keyData) {
        File f = this.getKeysFileForSession(sessionId);
        BufferedWriter writer = null;
        try {
            String keyDataString = MetaDataStore.keysDataToJson(keyData);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), UTF_8));
            writer.write(keyDataString);
            ((Writer)writer).flush();
            CommonUtils.closeOrLog((Closeable)writer, (String)"Failed to close key/value metadata file.");
        }
        catch (Exception e) {
            Fabric.getLogger().e("CrashlyticsCore", "Error serializing key/value metadata.", (Throwable)e);
        }
        finally {
            CommonUtils.closeOrLog(writer, (String)"Failed to close key/value metadata file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> readKeyData(String sessionId) {
        File f = this.getKeysFileForSession(sessionId);
        if (!f.exists()) {
            return Collections.emptyMap();
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            Map<String, String> map = MetaDataStore.jsonToKeysData(CommonUtils.streamToString((InputStream)is));
            return map;
        }
        catch (Exception e) {
            Fabric.getLogger().e("CrashlyticsCore", "Error deserializing user metadata.", (Throwable)e);
        }
        finally {
            CommonUtils.closeOrLog((Closeable)is, (String)"Failed to close user metadata file.");
        }
        return Collections.emptyMap();
    }

    private File getUserDataFileForSession(String sessionId) {
        return new File(this.filesDir, sessionId + USERDATA_SUFFIX + METADATA_EXT);
    }

    private File getKeysFileForSession(String sessionId) {
        return new File(this.filesDir, sessionId + KEYDATA_SUFFIX + METADATA_EXT);
    }

    private static UserMetaData jsonToUserData(String json) throws JSONException {
        JSONObject dataObj = new JSONObject(json);
        String id = MetaDataStore.valueOrNull(dataObj, KEY_USER_ID);
        String name = MetaDataStore.valueOrNull(dataObj, KEY_USER_NAME);
        String email = MetaDataStore.valueOrNull(dataObj, KEY_USER_EMAIL);
        return new UserMetaData(id, name, email);
    }

    private static String userDataToJson(final UserMetaData userData) throws JSONException {
        return new JSONObject(){
            {
                this.put(MetaDataStore.KEY_USER_ID, userData.id);
                this.put(MetaDataStore.KEY_USER_NAME, userData.name);
                this.put(MetaDataStore.KEY_USER_EMAIL, userData.email);
            }
        }.toString();
    }

    private static Map<String, String> jsonToKeysData(String json) throws JSONException {
        JSONObject dataObj = new JSONObject(json);
        HashMap<String, String> keyData = new HashMap<String, String>();
        Iterator keyIter = dataObj.keys();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            keyData.put(key, MetaDataStore.valueOrNull(dataObj, key));
        }
        return keyData;
    }

    private static String keysDataToJson(Map<String, String> keyData) throws JSONException {
        return new JSONObject(keyData).toString();
    }

    private static String valueOrNull(JSONObject json, String key) {
        return !json.isNull(key) ? json.optString(key, null) : null;
    }
}

