/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import com.crashlytics.android.core.ByteString;
import com.crashlytics.android.core.CodedOutputStream;
import com.crashlytics.android.core.LogFileManager;
import com.crashlytics.android.core.internal.models.BinaryImageData;
import com.crashlytics.android.core.internal.models.CustomAttributeData;
import com.crashlytics.android.core.internal.models.DeviceData;
import com.crashlytics.android.core.internal.models.SessionEventData;
import com.crashlytics.android.core.internal.models.SignalData;
import com.crashlytics.android.core.internal.models.ThreadData;
import io.fabric.sdk.android.Fabric;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

class NativeCrashWriter {
    static final String NDK_CRASH_TYPE = "ndk-crash";
    private static final SignalData DEFAULT_SIGNAL = new SignalData("", "", 0L);
    private static final ProtobufMessage[] EMPTY_CHILDREN = new ProtobufMessage[0];
    private static final ThreadMessage[] EMPTY_THREAD_MESSAGES = new ThreadMessage[0];
    private static final FrameMessage[] EMPTY_FRAME_MESSAGES = new FrameMessage[0];
    private static final BinaryImageMessage[] EMPTY_BINARY_IMAGE_MESSAGES = new BinaryImageMessage[0];
    private static final CustomAttributeMessage[] EMPTY_CUSTOM_ATTRIBUTE_MESSAGES = new CustomAttributeMessage[0];

    NativeCrashWriter() {
    }

    private static EventMessage createEventMessage(SessionEventData crashEvent, LogFileManager logFileManager, Map<String, String> attributes) throws IOException {
        SignalData signal = crashEvent.signal != null ? crashEvent.signal : DEFAULT_SIGNAL;
        SignalMessage signalMessage = new SignalMessage(signal);
        RepeatedMessage threadsMessage = NativeCrashWriter.createThreadsMessage(crashEvent.threads);
        RepeatedMessage binaryImagesMessage = NativeCrashWriter.createBinaryImagesMessage(crashEvent.binaryImages);
        ExecutionMessage executionMessage = new ExecutionMessage(signalMessage, threadsMessage, binaryImagesMessage);
        RepeatedMessage customAttributesMessage = NativeCrashWriter.createCustomAttributesMessage(NativeCrashWriter.mergeCustomAttributes(crashEvent.customAttributes, attributes));
        ApplicationMessage applicationMessage = new ApplicationMessage(executionMessage, customAttributesMessage);
        ProtobufMessage deviceMessage = NativeCrashWriter.createDeviceMessage(crashEvent.deviceData);
        ByteString logByteString = logFileManager.getByteStringForLog();
        if (logByteString == null) {
            Fabric.getLogger().d("CrashlyticsCore", "No log data to include with this event.");
        }
        logFileManager.clearLog();
        ProtobufMessage logMessage = logByteString != null ? new LogMessage(logByteString) : new NullMessage();
        return new EventMessage(crashEvent.timestamp, NDK_CRASH_TYPE, applicationMessage, deviceMessage, logMessage);
    }

    private static CustomAttributeData[] mergeCustomAttributes(CustomAttributeData[] ndkAttributes, Map<String, String> javaAttributes) {
        TreeMap<String, String> sorted = new TreeMap<String, String>(javaAttributes);
        if (ndkAttributes != null) {
            for (CustomAttributeData attr : ndkAttributes) {
                sorted.put(attr.key, attr.value);
            }
        }
        Map.Entry[] entryArray = sorted.entrySet().toArray(new Map.Entry[sorted.size()]);
        CustomAttributeData[] merged = new CustomAttributeData[entryArray.length];
        for (int i = 0; i < merged.length; ++i) {
            merged[i] = new CustomAttributeData((String)entryArray[i].getKey(), (String)entryArray[i].getValue());
        }
        return merged;
    }

    private static ProtobufMessage createDeviceMessage(DeviceData deviceData) {
        if (deviceData == null) {
            return new NullMessage();
        }
        return new DeviceMessage((float)deviceData.batteryCapacity / 100.0f, deviceData.batteryVelocity, deviceData.proximity, deviceData.orientation, deviceData.totalPhysicalMemory - deviceData.availablePhysicalMemory, deviceData.totalInternalStorage - deviceData.availableInternalStorage);
    }

    private static RepeatedMessage createThreadsMessage(ThreadData[] threads) {
        ProtobufMessage[] threadMessages = threads != null ? new ThreadMessage[threads.length] : EMPTY_THREAD_MESSAGES;
        for (int threadIdx = 0; threadIdx < threadMessages.length; ++threadIdx) {
            ThreadData threadData = threads[threadIdx];
            threadMessages[threadIdx] = new ThreadMessage(threadData, NativeCrashWriter.createFramesMessage(threadData.frames));
        }
        return new RepeatedMessage(threadMessages);
    }

    private static RepeatedMessage createFramesMessage(ThreadData.FrameData[] frames) {
        ProtobufMessage[] frameMessages = frames != null ? new FrameMessage[frames.length] : EMPTY_FRAME_MESSAGES;
        for (int frameIdx = 0; frameIdx < frameMessages.length; ++frameIdx) {
            frameMessages[frameIdx] = new FrameMessage(frames[frameIdx]);
        }
        return new RepeatedMessage(frameMessages);
    }

    private static RepeatedMessage createBinaryImagesMessage(BinaryImageData[] binaryImages) {
        ProtobufMessage[] binaryImageMessages = binaryImages != null ? new BinaryImageMessage[binaryImages.length] : EMPTY_BINARY_IMAGE_MESSAGES;
        for (int i = 0; i < binaryImageMessages.length; ++i) {
            binaryImageMessages[i] = new BinaryImageMessage(binaryImages[i]);
        }
        return new RepeatedMessage(binaryImageMessages);
    }

    private static RepeatedMessage createCustomAttributesMessage(CustomAttributeData[] customAttributes) {
        ProtobufMessage[] customAttributeMessages = customAttributes != null ? new CustomAttributeMessage[customAttributes.length] : EMPTY_CUSTOM_ATTRIBUTE_MESSAGES;
        for (int i = 0; i < customAttributeMessages.length; ++i) {
            customAttributeMessages[i] = new CustomAttributeMessage(customAttributes[i]);
        }
        return new RepeatedMessage(customAttributeMessages);
    }

    public static void writeNativeCrash(SessionEventData crashEventData, LogFileManager logFileManager, Map<String, String> customAttributes, CodedOutputStream cos) throws IOException {
        EventMessage crashEventMessage = NativeCrashWriter.createEventMessage(crashEventData, logFileManager, customAttributes);
        crashEventMessage.write(cos);
    }

    private static final class CustomAttributeMessage
    extends ProtobufMessage {
        private static final int PROTOBUF_TAG = 2;
        private final String key;
        private final String value;

        public CustomAttributeMessage(CustomAttributeData customAttributeData) {
            super(2, new ProtobufMessage[0]);
            this.key = customAttributeData.key;
            this.value = customAttributeData.value;
        }

        @Override
        public int getPropertiesSize() {
            int size = CodedOutputStream.computeBytesSize(1, ByteString.copyFromUtf8(this.key));
            return size += CodedOutputStream.computeBytesSize(2, ByteString.copyFromUtf8(this.value == null ? "" : this.value));
        }

        @Override
        public void writeProperties(CodedOutputStream cos) throws IOException {
            cos.writeBytes(1, ByteString.copyFromUtf8(this.key));
            cos.writeBytes(2, ByteString.copyFromUtf8(this.value == null ? "" : this.value));
        }
    }

    private static final class BinaryImageMessage
    extends ProtobufMessage {
        private static final int PROTOBUF_TAG = 4;
        private final long baseAddr;
        private final long imageSize;
        private final String filePath;
        private final String uuid;

        public BinaryImageMessage(BinaryImageData binaryImageData) {
            super(4, new ProtobufMessage[0]);
            this.baseAddr = binaryImageData.baseAddress;
            this.imageSize = binaryImageData.size;
            this.filePath = binaryImageData.path;
            this.uuid = binaryImageData.id;
        }

        @Override
        public int getPropertiesSize() {
            int addrSize = CodedOutputStream.computeUInt64Size(1, this.baseAddr);
            int imgSize = CodedOutputStream.computeUInt64Size(2, this.imageSize);
            int pathSize = CodedOutputStream.computeBytesSize(3, ByteString.copyFromUtf8(this.filePath));
            int uuidSize = CodedOutputStream.computeBytesSize(4, ByteString.copyFromUtf8(this.uuid));
            return pathSize + addrSize + imgSize + uuidSize;
        }

        @Override
        public void writeProperties(CodedOutputStream cos) throws IOException {
            cos.writeUInt64(1, this.baseAddr);
            cos.writeUInt64(2, this.imageSize);
            cos.writeBytes(3, ByteString.copyFromUtf8(this.filePath));
            cos.writeBytes(4, ByteString.copyFromUtf8(this.uuid));
        }
    }

    private static final class SignalMessage
    extends ProtobufMessage {
        private static final int PROTOBUF_TAG = 3;
        private final String sigName;
        private final String sigCode;
        private final long sigAddr;

        public SignalMessage(SignalData signalData) {
            super(3, new ProtobufMessage[0]);
            this.sigName = signalData.name;
            this.sigCode = signalData.code;
            this.sigAddr = signalData.faultAddress;
        }

        @Override
        public int getPropertiesSize() {
            int size = CodedOutputStream.computeBytesSize(1, ByteString.copyFromUtf8(this.sigName));
            size += CodedOutputStream.computeBytesSize(2, ByteString.copyFromUtf8(this.sigCode));
            return size += CodedOutputStream.computeUInt64Size(3, this.sigAddr);
        }

        @Override
        public void writeProperties(CodedOutputStream cos) throws IOException {
            cos.writeBytes(1, ByteString.copyFromUtf8(this.sigName));
            cos.writeBytes(2, ByteString.copyFromUtf8(this.sigCode));
            cos.writeUInt64(3, this.sigAddr);
        }
    }

    private static final class FrameMessage
    extends ProtobufMessage {
        private static final int PROTOBUF_TAG = 3;
        private final long address;
        private final String symbol;
        private final String file;
        private final long offset;
        private final int importance;

        public FrameMessage(ThreadData.FrameData frameData) {
            super(3, new ProtobufMessage[0]);
            this.address = frameData.address;
            this.symbol = frameData.symbol;
            this.file = frameData.file;
            this.offset = frameData.offset;
            this.importance = frameData.importance;
        }

        @Override
        public int getPropertiesSize() {
            int size = CodedOutputStream.computeUInt64Size(1, this.address);
            size += CodedOutputStream.computeBytesSize(2, ByteString.copyFromUtf8(this.symbol));
            size += CodedOutputStream.computeBytesSize(3, ByteString.copyFromUtf8(this.file));
            size += CodedOutputStream.computeUInt64Size(4, this.offset);
            return size += CodedOutputStream.computeUInt32Size(5, this.importance);
        }

        @Override
        public void writeProperties(CodedOutputStream cos) throws IOException {
            cos.writeUInt64(1, this.address);
            cos.writeBytes(2, ByteString.copyFromUtf8(this.symbol));
            cos.writeBytes(3, ByteString.copyFromUtf8(this.file));
            cos.writeUInt64(4, this.offset);
            cos.writeUInt32(5, this.importance);
        }
    }

    private static final class ThreadMessage
    extends ProtobufMessage {
        private static final int PROTOBUF_TAG = 1;
        private final String name;
        private final int importance;

        public ThreadMessage(ThreadData threadData, RepeatedMessage frames) {
            super(1, frames);
            this.name = threadData.name;
            this.importance = threadData.importance;
        }

        @Override
        public int getPropertiesSize() {
            int nameSize = this.hasName() ? CodedOutputStream.computeBytesSize(1, ByteString.copyFromUtf8(this.name)) : 0;
            return CodedOutputStream.computeUInt32Size(2, this.importance) + nameSize;
        }

        @Override
        public void writeProperties(CodedOutputStream cos) throws IOException {
            if (this.hasName()) {
                cos.writeBytes(1, ByteString.copyFromUtf8(this.name));
            }
            cos.writeUInt32(2, this.importance);
        }

        private boolean hasName() {
            return this.name != null && this.name.length() > 0;
        }
    }

    private static final class ExecutionMessage
    extends ProtobufMessage {
        private static final int PROTOBUF_TAG = 1;

        public ExecutionMessage(SignalMessage signalMessage, RepeatedMessage threads, RepeatedMessage binaryImages) {
            super(1, threads, signalMessage, binaryImages);
        }
    }

    private static final class ApplicationMessage
    extends ProtobufMessage {
        private static final int PROTOBUF_TAG = 3;

        public ApplicationMessage(ExecutionMessage executionMessage, RepeatedMessage customAttrs) {
            super(3, executionMessage, customAttrs);
        }
    }

    private static final class LogMessage
    extends ProtobufMessage {
        private static final int PROTOBUF_TAG = 6;
        ByteString logBytes;

        public LogMessage(ByteString logBytes) {
            super(6, new ProtobufMessage[0]);
            this.logBytes = logBytes;
        }

        @Override
        public int getPropertiesSize() {
            return CodedOutputStream.computeBytesSize(1, this.logBytes);
        }

        @Override
        public void writeProperties(CodedOutputStream cos) throws IOException {
            cos.writeBytes(1, this.logBytes);
        }
    }

    private static final class DeviceMessage
    extends ProtobufMessage {
        private static final int PROTOBUF_TAG = 5;
        private final float batteryLevel;
        private final int batteryVelocity;
        private final boolean proximityOn;
        private final int orientation;
        private final long ramUsed;
        private final long diskUsed;

        public DeviceMessage(float batteryLevel, int batteryVelocity, boolean proximityOn, int orientation, long ramUsed, long diskUsed) {
            super(5, new ProtobufMessage[0]);
            this.batteryLevel = batteryLevel;
            this.batteryVelocity = batteryVelocity;
            this.proximityOn = proximityOn;
            this.orientation = orientation;
            this.ramUsed = ramUsed;
            this.diskUsed = diskUsed;
        }

        @Override
        public int getPropertiesSize() {
            int size = 0;
            size += CodedOutputStream.computeFloatSize(1, this.batteryLevel);
            size += CodedOutputStream.computeSInt32Size(2, this.batteryVelocity);
            size += CodedOutputStream.computeBoolSize(3, this.proximityOn);
            size += CodedOutputStream.computeUInt32Size(4, this.orientation);
            size += CodedOutputStream.computeUInt64Size(5, this.ramUsed);
            return size += CodedOutputStream.computeUInt64Size(6, this.diskUsed);
        }

        @Override
        public void writeProperties(CodedOutputStream cos) throws IOException {
            cos.writeFloat(1, this.batteryLevel);
            cos.writeSInt32(2, this.batteryVelocity);
            cos.writeBool(3, this.proximityOn);
            cos.writeUInt32(4, this.orientation);
            cos.writeUInt64(5, this.ramUsed);
            cos.writeUInt64(6, this.diskUsed);
        }
    }

    private static final class EventMessage
    extends ProtobufMessage {
        private static final int PROTOBUF_TAG = 10;
        private final long time;
        private final String crashType;

        public EventMessage(long time, String crashType, ProtobufMessage ... eventMessages) {
            super(10, eventMessages);
            this.time = time;
            this.crashType = crashType;
        }

        @Override
        public int getPropertiesSize() {
            int timeSize = CodedOutputStream.computeUInt64Size(1, this.time);
            int typeSize = CodedOutputStream.computeBytesSize(2, ByteString.copyFromUtf8(this.crashType));
            return timeSize + typeSize;
        }

        @Override
        public void writeProperties(CodedOutputStream cos) throws IOException {
            cos.writeUInt64(1, this.time);
            cos.writeBytes(2, ByteString.copyFromUtf8(this.crashType));
        }
    }

    private static final class NullMessage
    extends ProtobufMessage {
        public NullMessage() {
            super(0, new ProtobufMessage[0]);
        }

        @Override
        public void write(CodedOutputStream cos) throws IOException {
        }

        @Override
        public int getSize() {
            return 0;
        }
    }

    private static final class RepeatedMessage
    extends ProtobufMessage {
        private final ProtobufMessage[] messages;

        public RepeatedMessage(ProtobufMessage ... messages) {
            super(0, new ProtobufMessage[0]);
            this.messages = messages;
        }

        @Override
        public void write(CodedOutputStream cos) throws IOException {
            for (ProtobufMessage message : this.messages) {
                message.write(cos);
            }
        }

        @Override
        public int getSize() {
            int size = 0;
            for (ProtobufMessage message : this.messages) {
                size += message.getSize();
            }
            return size;
        }
    }

    private static abstract class ProtobufMessage {
        private final int tag;
        private final ProtobufMessage[] children;

        public ProtobufMessage(int tag, ProtobufMessage ... children) {
            this.tag = tag;
            this.children = children != null ? children : EMPTY_CHILDREN;
        }

        public int getSize() {
            int size = this.getSizeNoTag();
            size += CodedOutputStream.computeRawVarint32Size(size);
            return size += CodedOutputStream.computeTagSize(this.tag);
        }

        public int getSizeNoTag() {
            int size = this.getPropertiesSize();
            for (ProtobufMessage child : this.children) {
                size += child.getSize();
            }
            return size;
        }

        public void write(CodedOutputStream cos) throws IOException {
            cos.writeTag(this.tag, 2);
            cos.writeRawVarint32(this.getSizeNoTag());
            this.writeProperties(cos);
            for (ProtobufMessage child : this.children) {
                child.write(cos);
            }
        }

        public int getPropertiesSize() {
            return 0;
        }

        public void writeProperties(CodedOutputStream cos) throws IOException {
        }
    }
}

