/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import com.crashlytics.android.core.Report;
import com.crashlytics.android.core.ReportUploader;
import io.fabric.sdk.android.Fabric;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class SessionReport
implements Report {
    private final File file;
    private final File[] files;
    private final Map<String, String> customHeaders;

    public SessionReport(File file) {
        this(file, Collections.emptyMap());
    }

    public SessionReport(File file, Map<String, String> customHeaders) {
        this.file = file;
        this.files = new File[]{file};
        this.customHeaders = new HashMap<String, String>(customHeaders);
        if (this.file.length() == 0L) {
            this.customHeaders.putAll(ReportUploader.HEADER_INVALID_CLS_FILE);
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public File[] getFiles() {
        return this.files;
    }

    @Override
    public String getFileName() {
        return this.getFile().getName();
    }

    @Override
    public String getIdentifier() {
        String fileName = this.getFileName();
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    @Override
    public Map<String, String> getCustomHeaders() {
        return Collections.unmodifiableMap(this.customHeaders);
    }

    @Override
    public void remove() {
        Fabric.getLogger().d("CrashlyticsCore", "Removing report at " + this.file.getPath());
        this.file.delete();
    }
}

