/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.widget.ScrollView;
import android.widget.TextView;
import com.crashlytics.android.core.DialogStringResolver;
import io.fabric.sdk.android.services.settings.PromptSettingsData;
import java.util.concurrent.CountDownLatch;

class CrashPromptDialog {
    private final OptInLatch latch;
    private final AlertDialog.Builder dialog;

    public static CrashPromptDialog create(Activity activity, PromptSettingsData promptData, final AlwaysSendCallback alwaysSendCallback) {
        final OptInLatch latch = new OptInLatch();
        DialogStringResolver stringResolver = new DialogStringResolver((Context)activity, promptData);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        ScrollView scrollView = CrashPromptDialog.createDialogView(activity, stringResolver.getMessage());
        DialogInterface.OnClickListener sendClickListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                latch.setOptIn(true);
                dialog.dismiss();
            }
        };
        builder.setView((View)scrollView).setTitle((CharSequence)stringResolver.getTitle()).setCancelable(false).setNeutralButton((CharSequence)stringResolver.getSendButtonTitle(), sendClickListener);
        if (promptData.showCancelButton) {
            DialogInterface.OnClickListener cancelClickListener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id) {
                    latch.setOptIn(false);
                    dialog.dismiss();
                }
            };
            builder.setNegativeButton((CharSequence)stringResolver.getCancelButtonTitle(), cancelClickListener);
        }
        if (promptData.showAlwaysSendButton) {
            DialogInterface.OnClickListener alwaysSendClickListener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id) {
                    alwaysSendCallback.sendUserReportsWithoutPrompting(true);
                    latch.setOptIn(true);
                    dialog.dismiss();
                }
            };
            builder.setPositiveButton((CharSequence)stringResolver.getAlwaysSendButtonTitle(), alwaysSendClickListener);
        }
        return new CrashPromptDialog(builder, latch);
    }

    private static ScrollView createDialogView(Activity activity, String message) {
        float density = activity.getResources().getDisplayMetrics().density;
        int textViewPadding = CrashPromptDialog.dipsToPixels(density, 5);
        TextView textView = new TextView((Context)activity);
        textView.setAutoLinkMask(15);
        textView.setText((CharSequence)message);
        textView.setTextAppearance((Context)activity, 16973892);
        textView.setPadding(textViewPadding, textViewPadding, textViewPadding, textViewPadding);
        textView.setFocusable(false);
        ScrollView scrollView = new ScrollView((Context)activity);
        scrollView.setPadding(CrashPromptDialog.dipsToPixels(density, 14), CrashPromptDialog.dipsToPixels(density, 2), CrashPromptDialog.dipsToPixels(density, 10), CrashPromptDialog.dipsToPixels(density, 12));
        scrollView.addView((View)textView);
        return scrollView;
    }

    private static int dipsToPixels(float density, int dips) {
        return (int)(density * (float)dips);
    }

    private CrashPromptDialog(AlertDialog.Builder dialog, OptInLatch latch) {
        this.latch = latch;
        this.dialog = dialog;
    }

    public void show() {
        this.dialog.show();
    }

    public void await() {
        this.latch.await();
    }

    public boolean getOptIn() {
        return this.latch.getOptIn();
    }

    private static class OptInLatch {
        private boolean send = false;
        private final CountDownLatch latch = new CountDownLatch(1);

        private OptInLatch() {
        }

        void setOptIn(boolean optIn) {
            this.send = optIn;
            this.latch.countDown();
        }

        boolean getOptIn() {
            return this.send;
        }

        void await() {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static interface AlwaysSendCallback {
        public void sendUserReportsWithoutPrompting(boolean var1);
    }
}

