/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import io.fabric.sdk.android.Fabric;
import java.util.concurrent.atomic.AtomicBoolean;

class CrashlyticsUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final CrashListener crashListener;
    private final Thread.UncaughtExceptionHandler defaultHandler;
    private final AtomicBoolean isHandlingException;

    public CrashlyticsUncaughtExceptionHandler(CrashListener crashListener, Thread.UncaughtExceptionHandler defaultHandler) {
        this.crashListener = crashListener;
        this.defaultHandler = defaultHandler;
        this.isHandlingException = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        this.isHandlingException.set(true);
        try {
            this.crashListener.onUncaughtException(thread, ex);
        }
        catch (Exception e) {
            Fabric.getLogger().e("CrashlyticsCore", "An error occurred in the uncaught exception handler", (Throwable)e);
        }
        finally {
            Fabric.getLogger().d("CrashlyticsCore", "Crashlytics completed exception processing. Invoking default exception handler.");
            this.defaultHandler.uncaughtException(thread, ex);
            this.isHandlingException.set(false);
        }
    }

    boolean isHandlingException() {
        return this.isHandlingException.get();
    }

    static interface CrashListener {
        public void onUncaughtException(Thread var1, Throwable var2);
    }
}

