/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import com.crashlytics.android.core.CrashlyticsController;
import com.crashlytics.android.core.CrashlyticsCore;
import com.crashlytics.android.core.CreateReportRequest;
import com.crashlytics.android.core.CreateReportSpiCall;
import com.crashlytics.android.core.InvalidSessionReport;
import com.crashlytics.android.core.Report;
import com.crashlytics.android.core.SessionReport;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.BackgroundPriorityRunnable;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class ReportUploader {
    private static final FilenameFilter crashFileFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String filename) {
            return filename.endsWith(ReportUploader.CLS_FILE_EXT) && !filename.contains("Session");
        }
    };
    static final Map<String, String> HEADER_INVALID_CLS_FILE = Collections.singletonMap("X-CRASHLYTICS-INVALID-SESSION", "1");
    private static final short[] RETRY_INTERVALS = new short[]{10, 20, 30, 60, 120, 300};
    private static final String CLS_FILE_EXT = ".cls";
    private final Object fileAccessLock = new Object();
    private final CreateReportSpiCall createReportCall;
    private final String apiKey;
    private Thread uploadThread;

    public ReportUploader(String apiKey, CreateReportSpiCall createReportCall) {
        if (createReportCall == null) {
            throw new IllegalArgumentException("createReportCall must not be null.");
        }
        this.createReportCall = createReportCall;
        this.apiKey = apiKey;
    }

    public synchronized void uploadReports(float delay, SendCheck sendCheck) {
        if (this.uploadThread != null) {
            Fabric.getLogger().d("CrashlyticsCore", "Report upload has already been started.");
            return;
        }
        Worker uploadWorker = new Worker(delay, sendCheck);
        this.uploadThread = new Thread((Runnable)((Object)uploadWorker), "Crashlytics Report Uploader");
        this.uploadThread.start();
    }

    boolean isUploading() {
        return this.uploadThread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean forceUpload(Report report) {
        boolean removed = false;
        Object object = this.fileAccessLock;
        synchronized (object) {
            try {
                CreateReportRequest requestData = new CreateReportRequest(this.apiKey, report);
                boolean sent = this.createReportCall.invoke(requestData);
                Fabric.getLogger().i("CrashlyticsCore", "Crashlytics report upload " + (sent ? "complete: " : "FAILED: ") + report.getIdentifier());
                if (sent) {
                    report.remove();
                    removed = true;
                }
            }
            catch (Exception e) {
                Fabric.getLogger().e("CrashlyticsCore", "Error occurred sending report " + report, (Throwable)e);
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Report> findReports() {
        File[] invalidClsFiles;
        File[] clsFiles;
        Fabric.getLogger().d("CrashlyticsCore", "Checking for crash reports...");
        CrashlyticsController controller = CrashlyticsCore.getInstance().getController();
        Object object = this.fileAccessLock;
        synchronized (object) {
            clsFiles = controller.getFilesDir().listFiles(crashFileFilter);
            invalidClsFiles = controller.getInvalidFilesDir().listFiles();
        }
        LinkedList<Report> reports = new LinkedList<Report>();
        for (File file : clsFiles) {
            Fabric.getLogger().d("CrashlyticsCore", "Found crash report " + file.getPath());
            reports.add(new SessionReport(file));
        }
        HashMap invalidSessionFiles = new HashMap();
        if (invalidClsFiles != null) {
            for (File invalidFile : invalidClsFiles) {
                String sessionId = CrashlyticsController.getSessionIdFromSessionFile(invalidFile);
                if (!invalidSessionFiles.containsKey(sessionId)) {
                    invalidSessionFiles.put(sessionId, new LinkedList());
                }
                ((List)invalidSessionFiles.get(sessionId)).add(invalidFile);
            }
        }
        for (String key : invalidSessionFiles.keySet()) {
            Fabric.getLogger().d("CrashlyticsCore", "Found invalid session: " + key);
            List invalidFiles = (List)invalidSessionFiles.get(key);
            reports.add(new InvalidSessionReport(key, invalidFiles.toArray(new File[invalidFiles.size()])));
        }
        if (reports.isEmpty()) {
            Fabric.getLogger().d("CrashlyticsCore", "No reports found.");
        }
        return reports;
    }

    private class Worker
    extends BackgroundPriorityRunnable {
        private final float delay;
        private final SendCheck sendCheck;

        Worker(float delay, SendCheck sendCheck) {
            this.delay = delay;
            this.sendCheck = sendCheck;
        }

        public void onRun() {
            try {
                this.attemptUploadWithRetry();
            }
            catch (Exception e) {
                Fabric.getLogger().e("CrashlyticsCore", "An unexpected error occurred while attempting to upload crash reports.", (Throwable)e);
            }
            ReportUploader.this.uploadThread = null;
        }

        private void attemptUploadWithRetry() {
            Fabric.getLogger().d("CrashlyticsCore", "Starting report processing in " + this.delay + " second(s)...");
            if (this.delay > 0.0f) {
                try {
                    Thread.sleep((long)(this.delay * 1000.0f));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            CrashlyticsCore crashlyticsCore = CrashlyticsCore.getInstance();
            CrashlyticsController controller = crashlyticsCore.getController();
            List<Report> reports = ReportUploader.this.findReports();
            if (controller.isHandlingException()) {
                return;
            }
            if (!reports.isEmpty() && !this.sendCheck.canSendReports()) {
                Fabric.getLogger().d("CrashlyticsCore", "User declined to send. Removing " + reports.size() + " Report(s).");
                for (Report report : reports) {
                    report.remove();
                }
                return;
            }
            int retryCount = 0;
            while (!reports.isEmpty()) {
                if (controller.isHandlingException()) {
                    return;
                }
                Fabric.getLogger().d("CrashlyticsCore", "Attempting to send " + reports.size() + " report(s)");
                for (Report report : reports) {
                    ReportUploader.this.forceUpload(report);
                }
                reports = ReportUploader.this.findReports();
                if (reports.isEmpty()) continue;
                long interval = RETRY_INTERVALS[Math.min(retryCount++, RETRY_INTERVALS.length - 1)];
                Fabric.getLogger().d("CrashlyticsCore", "Report submisson: scheduling delayed retry in " + interval + " seconds");
                try {
                    Thread.sleep(interval * 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    static final class AlwaysSendCheck
    implements SendCheck {
        AlwaysSendCheck() {
        }

        @Override
        public boolean canSendReports() {
            return true;
        }
    }

    static interface SendCheck {
        public boolean canSendReports();
    }
}

