/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import android.os.Looper;
import io.fabric.sdk.android.Fabric;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

class CrashlyticsBackgroundWorker {
    private final ExecutorService executorService;

    public CrashlyticsBackgroundWorker(ExecutorService executorService) {
        this.executorService = executorService;
    }

    <T> T submitAndWait(Callable<T> callable) {
        try {
            if (Looper.getMainLooper() == Looper.myLooper()) {
                return this.executorService.submit(callable).get(4L, TimeUnit.SECONDS);
            }
            return this.executorService.submit(callable).get();
        }
        catch (RejectedExecutionException e) {
            Fabric.getLogger().d("CrashlyticsCore", "Executor is shut down because we're handling a fatal crash.");
            return null;
        }
        catch (Exception e) {
            Fabric.getLogger().e("CrashlyticsCore", "Failed to execute task.", (Throwable)e);
            return null;
        }
    }

    Future<?> submit(final Runnable runnable) {
        try {
            return this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        Fabric.getLogger().e("CrashlyticsCore", "Failed to execute task.", (Throwable)e);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            Fabric.getLogger().d("CrashlyticsCore", "Executor is shut down because we're handling a fatal crash.");
            return null;
        }
    }

    <T> Future<T> submit(final Callable<T> callable) {
        try {
            return this.executorService.submit(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    try {
                        return callable.call();
                    }
                    catch (Exception e) {
                        Fabric.getLogger().e("CrashlyticsCore", "Failed to execute task.", (Throwable)e);
                        return null;
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            Fabric.getLogger().d("CrashlyticsCore", "Executor is shut down because we're handling a fatal crash.");
            return null;
        }
    }
}

