/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import android.content.Context;
import com.crashlytics.android.core.ByteString;
import com.crashlytics.android.core.FileLogStore;
import com.crashlytics.android.core.QueueFileLogStore;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.CommonUtils;
import java.io.File;
import java.util.Set;

class LogFileManager {
    private static final String COLLECT_CUSTOM_LOGS = "com.crashlytics.CollectCustomLogs";
    private static final String LOGFILE_EXT = ".temp";
    private static final String LOGFILE_PREFIX = "crashlytics-userlog-";
    private static final NoopLogStore NOOP_LOG_STORE = new NoopLogStore();
    static final int MAX_LOG_SIZE = 65536;
    private final Context context;
    private final DirectoryProvider directoryProvider;
    private FileLogStore currentLog;

    LogFileManager(Context context, DirectoryProvider directoryProvider) {
        this(context, directoryProvider, null);
    }

    LogFileManager(Context context, DirectoryProvider directoryProvider, String currentSessionId) {
        this.context = context;
        this.directoryProvider = directoryProvider;
        this.currentLog = NOOP_LOG_STORE;
        this.setCurrentSession(currentSessionId);
    }

    final void setCurrentSession(String sessionId) {
        this.currentLog.closeLogFile();
        this.currentLog = NOOP_LOG_STORE;
        if (sessionId == null) {
            return;
        }
        boolean isLoggingEnabled = CommonUtils.getBooleanResourceValue((Context)this.context, (String)COLLECT_CUSTOM_LOGS, (boolean)true);
        if (!isLoggingEnabled) {
            Fabric.getLogger().d("CrashlyticsCore", "Preferences requested no custom logs. Aborting log file creation.");
            return;
        }
        this.setLogFile(this.getWorkingFileForSession(sessionId), 65536);
    }

    void writeToLog(long timestamp, String msg) {
        this.currentLog.writeToLog(timestamp, msg);
    }

    ByteString getByteStringForLog() {
        return this.currentLog.getLogAsByteString();
    }

    void clearLog() {
        this.currentLog.deleteLogFile();
    }

    void discardOldLogFiles(Set<String> sessionIdsToKeep) {
        File[] logFiles = this.directoryProvider.getLogFileDir().listFiles();
        if (logFiles != null) {
            for (File file : logFiles) {
                if (sessionIdsToKeep.contains(this.getSessionIdForFile(file))) continue;
                file.delete();
            }
        }
    }

    void setLogFile(File workingFile, int maxLogSize) {
        this.currentLog = new QueueFileLogStore(workingFile, maxLogSize);
    }

    private File getWorkingFileForSession(String sessionId) {
        String fileName = LOGFILE_PREFIX + sessionId + LOGFILE_EXT;
        return new File(this.directoryProvider.getLogFileDir(), fileName);
    }

    private String getSessionIdForFile(File workingFile) {
        String filename = workingFile.getName();
        int indexOfExtension = filename.lastIndexOf(LOGFILE_EXT);
        if (indexOfExtension == -1) {
            return filename;
        }
        return filename.substring(LOGFILE_PREFIX.length(), indexOfExtension);
    }

    private static final class NoopLogStore
    implements FileLogStore {
        private NoopLogStore() {
        }

        @Override
        public void writeToLog(long timestamp, String msg) {
        }

        @Override
        public ByteString getLogAsByteString() {
            return null;
        }

        @Override
        public void closeLogFile() {
        }

        @Override
        public void deleteLogFile() {
        }
    }

    public static interface DirectoryProvider {
        public File getLogFileDir();
    }
}

