/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;

final class Utils {
    private static final FilenameFilter ALL_FILES_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String filename) {
            return true;
        }
    };

    private Utils() {
    }

    static int capFileCount(File directory, int maxAllowed, Comparator<File> sortComparator) {
        return Utils.capFileCount(directory, ALL_FILES_FILTER, maxAllowed, sortComparator);
    }

    static int capFileCount(File directory, FilenameFilter filter, int maxAllowed, Comparator<File> sortComparator) {
        File[] sessionFiles = directory.listFiles(filter);
        if (sessionFiles == null) {
            return 0;
        }
        int numRetained = sessionFiles.length;
        Arrays.sort(sessionFiles, sortComparator);
        for (File file : sessionFiles) {
            if (numRetained <= maxAllowed) {
                return numRetained;
            }
            file.delete();
            --numRetained;
        }
        return numRetained;
    }
}

