/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import android.content.Context;
import android.util.Log;
import com.crashlytics.android.core.AppData;
import com.crashlytics.android.core.CrashTest;
import com.crashlytics.android.core.CrashlyticsBackgroundWorker;
import com.crashlytics.android.core.CrashlyticsController;
import com.crashlytics.android.core.CrashlyticsFileMarker;
import com.crashlytics.android.core.CrashlyticsListener;
import com.crashlytics.android.core.CrashlyticsPinningInfoProvider;
import com.crashlytics.android.core.ManifestUnityVersionProvider;
import com.crashlytics.android.core.PinningInfoProvider;
import com.crashlytics.android.core.PreferenceManager;
import com.crashlytics.android.core.internal.CrashEventDataProvider;
import com.crashlytics.android.core.internal.models.SessionEventData;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.ApiKey;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.ExecutorUtils;
import io.fabric.sdk.android.services.common.IdManager;
import io.fabric.sdk.android.services.concurrency.DependsOn;
import io.fabric.sdk.android.services.concurrency.Priority;
import io.fabric.sdk.android.services.concurrency.PriorityCallable;
import io.fabric.sdk.android.services.concurrency.Task;
import io.fabric.sdk.android.services.concurrency.UnmetDependencyException;
import io.fabric.sdk.android.services.network.DefaultHttpRequestFactory;
import io.fabric.sdk.android.services.network.HttpMethod;
import io.fabric.sdk.android.services.network.HttpRequest;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.persistence.FileStore;
import io.fabric.sdk.android.services.persistence.FileStoreImpl;
import io.fabric.sdk.android.services.persistence.PreferenceStore;
import io.fabric.sdk.android.services.persistence.PreferenceStoreImpl;
import io.fabric.sdk.android.services.settings.Settings;
import io.fabric.sdk.android.services.settings.SettingsData;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.HttpsURLConnection;

@DependsOn(value={CrashEventDataProvider.class})
public class CrashlyticsCore
extends Kit<Void> {
    private static final String MISSING_BUILD_ID_MSG = "This app relies on Crashlytics. Please sign up for access at https://fabric.io/sign_up,\ninstall an Android build tool and ask a team member to invite you to this app's organization.";
    public static final String TAG = "CrashlyticsCore";
    static final float CLS_DEFAULT_PROCESS_DELAY = 1.0f;
    static final String CRASHLYTICS_REQUIRE_BUILD_ID = "com.crashlytics.RequireBuildId";
    static final boolean CRASHLYTICS_REQUIRE_BUILD_ID_DEFAULT = true;
    static final int MAX_ATTRIBUTES = 64;
    static final int MAX_ATTRIBUTE_SIZE = 1024;
    static final int DEFAULT_MAIN_HANDLER_TIMEOUT_SEC = 4;
    private static final String PREFERENCE_STORE_NAME = "com.crashlytics.android.core.CrashlyticsCore";
    private static final String INITIALIZATION_MARKER_FILE_NAME = "initialization_marker";
    static final String CRASH_MARKER_FILE_NAME = "crash_marker";
    private final long startTime;
    private final ConcurrentHashMap<String, String> attributes;
    private CrashlyticsFileMarker initializationMarker;
    private CrashlyticsFileMarker crashMarker;
    private CrashlyticsListener listener;
    private CrashlyticsController controller;
    private String userId = null;
    private String userEmail = null;
    private String userName = null;
    private float delay;
    private boolean disabled;
    private final PinningInfoProvider pinningInfo;
    private HttpRequestFactory httpRequestFactory;
    private CrashlyticsBackgroundWorker backgroundWorker;
    private CrashEventDataProvider externalCrashEventDataProvider;

    public CrashlyticsCore() {
        this(1.0f, null, null, false);
    }

    CrashlyticsCore(float delay, CrashlyticsListener listener, PinningInfoProvider pinningInfo, boolean disabled) {
        this(delay, listener, pinningInfo, disabled, ExecutorUtils.buildSingleThreadExecutorService((String)"Crashlytics Exception Handler"));
    }

    CrashlyticsCore(float delay, CrashlyticsListener listener, PinningInfoProvider pinningInfo, boolean disabled, ExecutorService crashHandlerExecutor) {
        this.delay = delay;
        this.listener = listener != null ? listener : new NoOpListener();
        this.pinningInfo = pinningInfo;
        this.disabled = disabled;
        this.backgroundWorker = new CrashlyticsBackgroundWorker(crashHandlerExecutor);
        this.attributes = new ConcurrentHashMap();
        this.startTime = System.currentTimeMillis();
    }

    protected boolean onPreExecute() {
        Context context = super.getContext();
        return this.onPreExecute(context);
    }

    boolean onPreExecute(Context context) {
        boolean requiresBuildId;
        if (this.disabled) {
            return false;
        }
        String apiKey = new ApiKey().getValue(context);
        if (apiKey == null) {
            return false;
        }
        String buildId = CommonUtils.resolveBuildId((Context)context);
        if (!CrashlyticsCore.isBuildIdValid(buildId, requiresBuildId = CommonUtils.getBooleanResourceValue((Context)context, (String)CRASHLYTICS_REQUIRE_BUILD_ID, (boolean)true))) {
            throw new UnmetDependencyException(MISSING_BUILD_ID_MSG);
        }
        try {
            Fabric.getLogger().i(TAG, "Initializing Crashlytics " + this.getVersion());
            FileStoreImpl fileStore = new FileStoreImpl((Kit)this);
            this.crashMarker = new CrashlyticsFileMarker(CRASH_MARKER_FILE_NAME, (FileStore)fileStore);
            this.initializationMarker = new CrashlyticsFileMarker(INITIALIZATION_MARKER_FILE_NAME, (FileStore)fileStore);
            PreferenceStoreImpl preferenceStore = new PreferenceStoreImpl(this.getContext(), PREFERENCE_STORE_NAME);
            PreferenceManager preferenceManager = PreferenceManager.create((PreferenceStore)preferenceStore, this);
            CrashlyticsPinningInfoProvider infoProvider = this.pinningInfo != null ? new CrashlyticsPinningInfoProvider(this.pinningInfo) : null;
            this.httpRequestFactory = new DefaultHttpRequestFactory(Fabric.getLogger());
            this.httpRequestFactory.setPinningInfoProvider((io.fabric.sdk.android.services.network.PinningInfoProvider)infoProvider);
            IdManager idManager = this.getIdManager();
            AppData appData = AppData.create(context, idManager, apiKey, buildId);
            ManifestUnityVersionProvider unityVersionProvider = new ManifestUnityVersionProvider(context, appData.packageName);
            Fabric.getLogger().d(TAG, "Installer package name is: " + appData.installerPackageName);
            this.controller = new CrashlyticsController(this, this.backgroundWorker, this.httpRequestFactory, idManager, preferenceManager, (FileStore)fileStore, appData, unityVersionProvider);
            boolean initializeSynchronously = this.didPreviousInitializationFail();
            this.checkForPreviousCrash();
            this.controller.enableExceptionHandling(Thread.getDefaultUncaughtExceptionHandler());
            if (initializeSynchronously && CommonUtils.canTryConnection((Context)context)) {
                Fabric.getLogger().d(TAG, "Crashlytics did not finish previous background initialization. Initializing synchronously.");
                this.finishInitSynchronously();
                return false;
            }
        }
        catch (Exception e) {
            Fabric.getLogger().e(TAG, "Crashlytics was not started due to an exception during initialization", (Throwable)e);
            this.controller = null;
            return false;
        }
        Fabric.getLogger().d(TAG, "Exception handling initialization successful");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doInBackground() {
        this.markInitializationStarted();
        SessionEventData crashEventData = this.getExternalCrashEventData();
        if (crashEventData != null) {
            this.controller.writeExternalCrashEvent(crashEventData);
        }
        this.controller.cleanInvalidTempFiles();
        try {
            SettingsData settingsData = Settings.getInstance().awaitSettingsData();
            if (settingsData == null) {
                Fabric.getLogger().w(TAG, "Received null settings, skipping report submission!");
                Void void_ = null;
                return void_;
            }
            if (!settingsData.featuresData.collectReports) {
                Fabric.getLogger().d(TAG, "Collection of crash reports disabled in Crashlytics settings.");
                Void void_ = null;
                return void_;
            }
            if (!this.controller.finalizeSessions(settingsData.sessionData)) {
                Fabric.getLogger().d(TAG, "Could not finalize previous sessions.");
            }
            this.controller.submitAllReports(this.delay, settingsData);
        }
        catch (Exception e) {
            Fabric.getLogger().e(TAG, "Crashlytics encountered a problem during asynchronous initialization.", (Throwable)e);
        }
        finally {
            this.markInitializationComplete();
        }
        return null;
    }

    public String getIdentifier() {
        return "com.crashlytics.sdk.android.crashlytics-core";
    }

    public String getVersion() {
        return "2.3.17.dev";
    }

    public static CrashlyticsCore getInstance() {
        return (CrashlyticsCore)Fabric.getKit(CrashlyticsCore.class);
    }

    public PinningInfoProvider getPinningInfoProvider() {
        return !this.disabled ? this.pinningInfo : null;
    }

    public void logException(Throwable throwable) {
        if (this.disabled) {
            return;
        }
        if (!CrashlyticsCore.ensureFabricWithCalled("prior to logging exceptions.")) {
            return;
        }
        if (throwable == null) {
            Fabric.getLogger().log(5, TAG, "Crashlytics is ignoring a request to log a null exception.");
            return;
        }
        this.controller.writeNonFatalException(Thread.currentThread(), throwable);
    }

    public void log(String msg) {
        this.doLog(3, TAG, msg);
    }

    private void doLog(int priority, String tag, String msg) {
        if (this.disabled) {
            return;
        }
        if (!CrashlyticsCore.ensureFabricWithCalled("prior to logging messages.")) {
            return;
        }
        long timestamp = System.currentTimeMillis() - this.startTime;
        this.controller.writeToLog(timestamp, CrashlyticsCore.formatLogMessage(priority, tag, msg));
    }

    public void log(int priority, String tag, String msg) {
        this.doLog(priority, tag, msg);
        Fabric.getLogger().log(priority, "" + tag, "" + msg, true);
    }

    public void setUserIdentifier(String identifier) {
        if (this.disabled) {
            return;
        }
        if (!CrashlyticsCore.ensureFabricWithCalled("prior to setting user data.")) {
            return;
        }
        this.userId = CrashlyticsCore.sanitizeAttribute(identifier);
        this.controller.cacheUserData(this.userId, this.userName, this.userEmail);
    }

    public void setUserName(String name) {
        if (this.disabled) {
            return;
        }
        if (!CrashlyticsCore.ensureFabricWithCalled("prior to setting user data.")) {
            return;
        }
        this.userName = CrashlyticsCore.sanitizeAttribute(name);
        this.controller.cacheUserData(this.userId, this.userName, this.userEmail);
    }

    public void setUserEmail(String email) {
        if (this.disabled) {
            return;
        }
        if (!CrashlyticsCore.ensureFabricWithCalled("prior to setting user data.")) {
            return;
        }
        this.userEmail = CrashlyticsCore.sanitizeAttribute(email);
        this.controller.cacheUserData(this.userId, this.userName, this.userEmail);
    }

    public void setString(String key, String value) {
        if (this.disabled) {
            return;
        }
        if (!CrashlyticsCore.ensureFabricWithCalled("prior to setting keys.")) {
            return;
        }
        if (key == null) {
            Context context = this.getContext();
            if (context != null && CommonUtils.isAppDebuggable((Context)context)) {
                throw new IllegalArgumentException("Custom attribute key must not be null.");
            }
            Fabric.getLogger().e(TAG, "Attempting to set custom attribute with null key, ignoring.", null);
            return;
        }
        key = CrashlyticsCore.sanitizeAttribute(key);
        if (this.attributes.size() >= 64 && !this.attributes.containsKey(key)) {
            Fabric.getLogger().d(TAG, "Exceeded maximum number of custom attributes (64)");
            return;
        }
        value = value == null ? "" : CrashlyticsCore.sanitizeAttribute(value);
        this.attributes.put(key, value);
        this.controller.cacheKeyData(this.attributes);
    }

    public void setBool(String key, boolean value) {
        this.setString(key, Boolean.toString(value));
    }

    public void setDouble(String key, double value) {
        this.setString(key, Double.toString(value));
    }

    public void setFloat(String key, float value) {
        this.setString(key, Float.toString(value));
    }

    public void setInt(String key, int value) {
        this.setString(key, Integer.toString(value));
    }

    public void setLong(String key, long value) {
        this.setString(key, Long.toString(value));
    }

    public void crash() {
        new CrashTest().indexOutOfBounds();
    }

    public boolean verifyPinning(URL url) {
        try {
            return this.internalVerifyPinning(url);
        }
        catch (Exception e) {
            Fabric.getLogger().e(TAG, "Could not verify SSL pinning", (Throwable)e);
            return false;
        }
    }

    @Deprecated
    public synchronized void setListener(CrashlyticsListener listener) {
        Fabric.getLogger().w(TAG, "Use of setListener is deprecated.");
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null.");
        }
        this.listener = listener;
    }

    Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    CrashlyticsController getController() {
        return this.controller;
    }

    String getUserIdentifier() {
        return this.getIdManager().canCollectUserIds() ? this.userId : null;
    }

    String getUserEmail() {
        return this.getIdManager().canCollectUserIds() ? this.userEmail : null;
    }

    String getUserName() {
        return this.getIdManager().canCollectUserIds() ? this.userName : null;
    }

    private void finishInitSynchronously() {
        PriorityCallable<Void> callable = new PriorityCallable<Void>(){

            public Void call() throws Exception {
                return CrashlyticsCore.this.doInBackground();
            }

            public Priority getPriority() {
                return Priority.IMMEDIATE;
            }
        };
        for (Task task : this.getDependencies()) {
            callable.addDependency(task);
        }
        Future future = this.getFabric().getExecutorService().submit(callable);
        Fabric.getLogger().d(TAG, "Crashlytics detected incomplete initialization on previous app launch. Will initialize synchronously.");
        try {
            future.get(4L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Fabric.getLogger().e(TAG, "Crashlytics was interrupted during initialization.", (Throwable)e);
        }
        catch (ExecutionException e) {
            Fabric.getLogger().e(TAG, "Problem encountered during Crashlytics initialization.", (Throwable)e);
        }
        catch (TimeoutException e) {
            Fabric.getLogger().e(TAG, "Crashlytics timed out during initialization.", (Throwable)e);
        }
    }

    void markInitializationStarted() {
        this.backgroundWorker.submitAndWait(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CrashlyticsCore.this.initializationMarker.create();
                Fabric.getLogger().d(CrashlyticsCore.TAG, "Initialization marker file created.");
                return null;
            }
        });
    }

    void markInitializationComplete() {
        this.backgroundWorker.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    boolean removed = CrashlyticsCore.this.initializationMarker.remove();
                    Fabric.getLogger().d(CrashlyticsCore.TAG, "Initialization marker file removed: " + removed);
                    return removed;
                }
                catch (Exception e) {
                    Fabric.getLogger().e(CrashlyticsCore.TAG, "Problem encountered deleting Crashlytics initialization marker.", (Throwable)e);
                    return false;
                }
            }
        });
    }

    boolean didPreviousInitializationFail() {
        return this.backgroundWorker.submitAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return CrashlyticsCore.this.initializationMarker.isPresent();
            }
        });
    }

    void setExternalCrashEventDataProvider(CrashEventDataProvider provider) {
        this.externalCrashEventDataProvider = provider;
    }

    SessionEventData getExternalCrashEventData() {
        SessionEventData eventData = null;
        if (this.externalCrashEventDataProvider != null) {
            eventData = this.externalCrashEventDataProvider.getCrashEventData();
        }
        return eventData;
    }

    boolean internalVerifyPinning(URL url) {
        if (this.getPinningInfoProvider() != null) {
            HttpRequest httpRequest = this.httpRequestFactory.buildHttpRequest(HttpMethod.GET, url.toString());
            HttpsURLConnection conn = (HttpsURLConnection)httpRequest.getConnection();
            conn.setInstanceFollowRedirects(false);
            httpRequest.code();
            return true;
        }
        return false;
    }

    private void checkForPreviousCrash() {
        Boolean foundPreviousCrash = this.backgroundWorker.submitAndWait(new CrashMarkerCheck(this.crashMarker));
        if (!Boolean.TRUE.equals(foundPreviousCrash)) {
            return;
        }
        try {
            this.listener.crashlyticsDidDetectCrashDuringPreviousExecution();
        }
        catch (Exception e) {
            Fabric.getLogger().e(TAG, "Exception thrown by CrashlyticsListener while notifying of previous crash.", (Throwable)e);
        }
    }

    void createCrashMarker() {
        this.crashMarker.create();
    }

    private static String formatLogMessage(int priority, String tag, String msg) {
        return CommonUtils.logPriorityToString((int)priority) + "/" + tag + " " + msg;
    }

    private static boolean ensureFabricWithCalled(String msg) {
        CrashlyticsCore instance = CrashlyticsCore.getInstance();
        if (instance == null || instance.controller == null) {
            Fabric.getLogger().e(TAG, "Crashlytics must be initialized by calling Fabric.with(Context) " + msg, null);
            return false;
        }
        return true;
    }

    private static String sanitizeAttribute(String input) {
        if (input != null && (input = input.trim()).length() > 1024) {
            input = input.substring(0, 1024);
        }
        return input;
    }

    static boolean isBuildIdValid(String buildId, boolean requiresBuildId) {
        if (!requiresBuildId) {
            Fabric.getLogger().d(TAG, "Configured not to require a build ID.");
            return true;
        }
        if (!CommonUtils.isNullOrEmpty((String)buildId)) {
            return true;
        }
        Log.e((String)TAG, (String)".");
        Log.e((String)TAG, (String)".     |  | ");
        Log.e((String)TAG, (String)".     |  |");
        Log.e((String)TAG, (String)".     |  |");
        Log.e((String)TAG, (String)".   \\ |  | /");
        Log.e((String)TAG, (String)".    \\    /");
        Log.e((String)TAG, (String)".     \\  /");
        Log.e((String)TAG, (String)".      \\/");
        Log.e((String)TAG, (String)".");
        Log.e((String)TAG, (String)MISSING_BUILD_ID_MSG);
        Log.e((String)TAG, (String)".");
        Log.e((String)TAG, (String)".      /\\");
        Log.e((String)TAG, (String)".     /  \\");
        Log.e((String)TAG, (String)".    /    \\");
        Log.e((String)TAG, (String)".   / |  | \\");
        Log.e((String)TAG, (String)".     |  |");
        Log.e((String)TAG, (String)".     |  |");
        Log.e((String)TAG, (String)".     |  |");
        Log.e((String)TAG, (String)".");
        return false;
    }

    private static final class NoOpListener
    implements CrashlyticsListener {
        private NoOpListener() {
        }

        @Override
        public void crashlyticsDidDetectCrashDuringPreviousExecution() {
        }
    }

    private static final class CrashMarkerCheck
    implements Callable<Boolean> {
        private final CrashlyticsFileMarker crashMarker;

        public CrashMarkerCheck(CrashlyticsFileMarker crashMarker) {
            this.crashMarker = crashMarker;
        }

        @Override
        public Boolean call() throws Exception {
            if (!this.crashMarker.isPresent()) {
                return Boolean.FALSE;
            }
            Fabric.getLogger().d(CrashlyticsCore.TAG, "Found previous crash marker.");
            this.crashMarker.remove();
            return Boolean.TRUE;
        }
    }

    public static class Builder {
        private float delay = -1.0f;
        private CrashlyticsListener listener;
        private PinningInfoProvider pinningInfoProvider;
        private boolean disabled = false;

        public Builder delay(float delay) {
            if (delay <= 0.0f) {
                throw new IllegalArgumentException("delay must be greater than 0");
            }
            if (this.delay > 0.0f) {
                throw new IllegalStateException("delay already set.");
            }
            this.delay = delay;
            return this;
        }

        public Builder listener(CrashlyticsListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener must not be null.");
            }
            if (this.listener != null) {
                throw new IllegalStateException("listener already set.");
            }
            this.listener = listener;
            return this;
        }

        @Deprecated
        public Builder pinningInfo(PinningInfoProvider pinningInfoProvider) {
            if (pinningInfoProvider == null) {
                throw new IllegalArgumentException("pinningInfoProvider must not be null.");
            }
            if (this.pinningInfoProvider != null) {
                throw new IllegalStateException("pinningInfoProvider already set.");
            }
            this.pinningInfoProvider = pinningInfoProvider;
            return this;
        }

        public Builder disabled(boolean isDisabled) {
            this.disabled = isDisabled;
            return this;
        }

        public CrashlyticsCore build() {
            if (this.delay < 0.0f) {
                this.delay = 1.0f;
            }
            return new CrashlyticsCore(this.delay, this.listener, this.pinningInfoProvider, this.disabled);
        }
    }
}

