/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import android.util.Log;
import com.crashlytics.android.core.CrashlyticsMissingDependencyException;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.CommonUtils;

class BuildIdValidator {
    private static final String MESSAGE = "This app relies on Crashlytics. Please sign up for access at https://fabric.io/sign_up,\ninstall an Android build tool and ask a team member to invite you to this app's organization.";
    private final String buildId;
    private final boolean requiringBuildId;

    public BuildIdValidator(String buildId, boolean requiringBuildId) {
        this.buildId = buildId;
        this.requiringBuildId = requiringBuildId;
    }

    public void validate(String apiKey, String appId) {
        if (CommonUtils.isNullOrEmpty((String)this.buildId) && this.requiringBuildId) {
            String message = this.getMessage(apiKey, appId);
            Log.e((String)"Fabric", (String)".");
            Log.e((String)"Fabric", (String)".     |  | ");
            Log.e((String)"Fabric", (String)".     |  |");
            Log.e((String)"Fabric", (String)".     |  |");
            Log.e((String)"Fabric", (String)".   \\ |  | /");
            Log.e((String)"Fabric", (String)".    \\    /");
            Log.e((String)"Fabric", (String)".     \\  /");
            Log.e((String)"Fabric", (String)".      \\/");
            Log.e((String)"Fabric", (String)".");
            Log.e((String)"Fabric", (String)message);
            Log.e((String)"Fabric", (String)".");
            Log.e((String)"Fabric", (String)".      /\\");
            Log.e((String)"Fabric", (String)".     /  \\");
            Log.e((String)"Fabric", (String)".    /    \\");
            Log.e((String)"Fabric", (String)".   / |  | \\");
            Log.e((String)"Fabric", (String)".     |  |");
            Log.e((String)"Fabric", (String)".     |  |");
            Log.e((String)"Fabric", (String)".     |  |");
            Log.e((String)"Fabric", (String)".");
            throw new CrashlyticsMissingDependencyException(message);
        }
        if (!this.requiringBuildId) {
            Fabric.getLogger().d("Fabric", "Configured not to require a build ID.");
        }
    }

    protected String getMessage(String apiKey, String appId) {
        return MESSAGE;
    }
}

