/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import com.crashlytics.android.core.CLSUUID;
import com.crashlytics.android.core.ClsFileOutputStream;
import com.crashlytics.android.core.CodedOutputStream;
import com.crashlytics.android.core.CrashlyticsCore;
import com.crashlytics.android.core.CrashlyticsExecutorServiceWrapper;
import com.crashlytics.android.core.CrashlyticsListener;
import com.crashlytics.android.core.CreateReportSpiCall;
import com.crashlytics.android.core.ExceptionUtils;
import com.crashlytics.android.core.LogFileManager;
import com.crashlytics.android.core.MetaDataStore;
import com.crashlytics.android.core.NativeCrashWriter;
import com.crashlytics.android.core.ReportUploader;
import com.crashlytics.android.core.SessionDataWriter;
import com.crashlytics.android.core.SessionReport;
import com.crashlytics.android.core.UserMetaData;
import com.crashlytics.android.core.Utils;
import com.crashlytics.android.core.internal.models.SessionEventData;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.DeliveryMechanism;
import io.fabric.sdk.android.services.common.IdManager;
import io.fabric.sdk.android.services.settings.SessionSettingsData;
import io.fabric.sdk.android.services.settings.Settings;
import io.fabric.sdk.android.services.settings.SettingsData;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.Flushable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CrashlyticsUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    static final FilenameFilter SESSION_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String filename) {
            return filename.length() == 35 + ".cls".length() && filename.endsWith(".cls");
        }
    };
    static final Comparator<File> LARGEST_FILE_NAME_FIRST = new Comparator<File>(){

        @Override
        public int compare(File file1, File file2) {
            return file2.getName().compareTo(file1.getName());
        }
    };
    static final Comparator<File> SMALLEST_FILE_NAME_FIRST = new Comparator<File>(){

        @Override
        public int compare(File file1, File file2) {
            return file1.getName().compareTo(file2.getName());
        }
    };
    static final FilenameFilter ANY_SESSION_FILENAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File file, String filename) {
            return SESSION_FILE_PATTERN.matcher(filename).matches();
        }
    };
    private static final Pattern SESSION_FILE_PATTERN = Pattern.compile("([\\d|A-Z|a-z]{12}\\-[\\d|A-Z|a-z]{4}\\-[\\d|A-Z|a-z]{4}\\-[\\d|A-Z|a-z]{12}).+");
    private static final Map<String, String> SEND_AT_CRASHTIME_HEADER = Collections.singletonMap("X-CRASHLYTICS-SEND-FLAGS", "1");
    private static final int MAX_LOCAL_LOGGED_EXCEPTIONS = 64;
    static final int MAX_OPEN_SESSIONS = 8;
    private static final int MAX_COMPLETE_SESSIONS_COUNT = 4;
    static final String CLS_CRASH_MARKER_FILE_NAME = "crash_marker";
    static final String INVALID_CLS_CACHE_DIR = "invalidClsFiles";
    private static final String GENERATOR_FORMAT = "Crashlytics Android SDK/%s";
    private static final String EVENT_TYPE_CRASH = "crash";
    private static final String EVENT_TYPE_LOGGED = "error";
    private static final int SESSION_ID_LENGTH = 35;
    private static final int ANALYZER_VERSION = 1;
    static final String SESSION_USER_TAG = "SessionUser";
    static final String SESSION_NON_FATAL_TAG = "SessionEvent";
    static final String SESSION_FATAL_TAG = "SessionCrash";
    static final String SESSION_APP_TAG = "SessionApp";
    static final String SESSION_OS_TAG = "SessionOS";
    static final String SESSION_DEVICE_TAG = "SessionDevice";
    static final String SESSION_BEGIN_TAG = "BeginSession";
    private final AtomicInteger eventCounter = new AtomicInteger(0);
    private final AtomicBoolean receiversRegistered = new AtomicBoolean(false);
    private final Thread.UncaughtExceptionHandler defaultHandler;
    private final File filesDir;
    private final AtomicBoolean isHandlingException;
    private final BroadcastReceiver powerDisconnectedReceiver;
    private final BroadcastReceiver powerConnectedReceiver;
    private final CrashlyticsExecutorServiceWrapper executorServiceWrapper;
    private final IdManager idManager;
    private boolean powerConnected;
    private final CrashlyticsCore crashlyticsCore;
    private final LogFileManager logFileManager;
    private final SessionDataWriter sessionDataWriter;

    CrashlyticsUncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler, CrashlyticsListener listener, CrashlyticsExecutorServiceWrapper executorServiceWrapper, IdManager idManager, SessionDataWriter sessionDataWriter, CrashlyticsCore crashlyticsCore) {
        this.defaultHandler = handler;
        this.executorServiceWrapper = executorServiceWrapper;
        this.idManager = idManager;
        this.crashlyticsCore = crashlyticsCore;
        this.sessionDataWriter = sessionDataWriter;
        this.isHandlingException = new AtomicBoolean(false);
        this.filesDir = crashlyticsCore.getSdkDirectory();
        this.logFileManager = new LogFileManager(crashlyticsCore.getContext(), this.filesDir);
        this.notifyCrashlyticsListenerOfPreviousCrash(listener);
        this.powerConnectedReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                CrashlyticsUncaughtExceptionHandler.this.powerConnected = true;
            }
        };
        IntentFilter powerConnectedFilter = new IntentFilter("android.intent.action.ACTION_POWER_CONNECTED");
        this.powerDisconnectedReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                CrashlyticsUncaughtExceptionHandler.this.powerConnected = false;
            }
        };
        IntentFilter powerDisconnectedFilter = new IntentFilter("android.intent.action.ACTION_POWER_DISCONNECTED");
        Context context = crashlyticsCore.getContext();
        context.registerReceiver(this.powerConnectedReceiver, powerConnectedFilter);
        context.registerReceiver(this.powerDisconnectedReceiver, powerDisconnectedFilter);
        this.receiversRegistered.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void uncaughtException(final Thread thread, final Throwable ex) {
        this.isHandlingException.set(true);
        try {
            Fabric.getLogger().d("Fabric", "Crashlytics is handling uncaught exception \"" + ex + "\" from thread " + thread.getName());
            if (!this.receiversRegistered.getAndSet(true)) {
                Fabric.getLogger().d("Fabric", "Unregistering power receivers.");
                Context context = this.crashlyticsCore.getContext();
                context.unregisterReceiver(this.powerConnectedReceiver);
                context.unregisterReceiver(this.powerDisconnectedReceiver);
            }
            final Date now = new Date();
            this.executorServiceWrapper.executeSyncLoggingException(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    CrashlyticsUncaughtExceptionHandler.this.handleUncaughtException(now, thread, ex);
                    return null;
                }
            });
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "An error occurred in the uncaught exception handler", (Throwable)e);
        }
        finally {
            Fabric.getLogger().d("Fabric", "Crashlytics completed exception processing. Invoking default exception handler.");
            this.defaultHandler.uncaughtException(thread, ex);
            this.isHandlingException.set(false);
        }
    }

    private void handleUncaughtException(Date time, Thread thread, Throwable ex) throws Exception {
        this.writeFatal(time, thread, ex);
        this.doCloseSessions();
        this.doOpenSession();
        this.trimSessionFiles();
        if (!this.crashlyticsCore.shouldPromptUserBeforeSendingCrashReports()) {
            this.sendSessionReports();
        }
    }

    boolean isHandlingException() {
        return this.isHandlingException.get();
    }

    private void notifyCrashlyticsListenerOfPreviousCrash(CrashlyticsListener listener) {
        Fabric.getLogger().d("Fabric", "Checking for previous crash marker.");
        File markerFile = new File(this.crashlyticsCore.getSdkDirectory(), CLS_CRASH_MARKER_FILE_NAME);
        if (markerFile.exists()) {
            markerFile.delete();
            if (listener != null) {
                try {
                    listener.crashlyticsDidDetectCrashDuringPreviousExecution();
                }
                catch (Exception e) {
                    Fabric.getLogger().e("Fabric", "Exception thrown by CrashlyticsListener while notifying of previous crash.", (Throwable)e);
                }
            }
        }
    }

    void writeToLog(final long timestamp, final String msg) {
        this.executorServiceWrapper.executeAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (!CrashlyticsUncaughtExceptionHandler.this.isHandlingException.get()) {
                    CrashlyticsUncaughtExceptionHandler.this.logFileManager.writeToLog(timestamp, msg);
                }
                return null;
            }
        });
    }

    void writeNonFatalException(final Thread thread, final Throwable ex) {
        final Date now = new Date();
        this.executorServiceWrapper.executeAsync(new Runnable(){

            @Override
            public void run() {
                if (!CrashlyticsUncaughtExceptionHandler.this.isHandlingException.get()) {
                    CrashlyticsUncaughtExceptionHandler.this.doWriteNonFatal(now, thread, ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFatal(Date time, Thread thread, Throwable ex) {
        ClsFileOutputStream fos = null;
        CodedOutputStream cos = null;
        try {
            new File(this.filesDir, CLS_CRASH_MARKER_FILE_NAME).createNewFile();
            String currentSessionId = this.getCurrentSessionId();
            if (currentSessionId != null) {
                CrashlyticsCore.recordFatalExceptionEvent(currentSessionId);
                fos = new ClsFileOutputStream(this.filesDir, currentSessionId + SESSION_FATAL_TAG);
                cos = CodedOutputStream.newInstance(fos);
                this.writeSessionEvent(cos, time, thread, ex, EVENT_TYPE_CRASH, true);
            } else {
                Fabric.getLogger().e("Fabric", "Tried to write a fatal exception while no session was open.", null);
            }
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "An error occurred in the fatal exception logger", (Throwable)e);
            ExceptionUtils.writeStackTraceIfNotNull(e, fos);
        }
        finally {
            CommonUtils.flushOrLog(cos, (String)"Failed to flush to session begin file.");
            CommonUtils.closeOrLog(fos, (String)"Failed to close fatal exception file output stream.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExternalCrashEvent(SessionEventData crashEventData) throws IOException {
        ClsFileOutputStream fos = null;
        CodedOutputStream cos = null;
        try {
            String currentSessionId = this.getCurrentSessionId();
            if (currentSessionId != null) {
                CrashlyticsCore.recordFatalExceptionEvent(currentSessionId);
                fos = new ClsFileOutputStream(this.filesDir, currentSessionId + SESSION_FATAL_TAG);
                cos = CodedOutputStream.newInstance(fos);
                Map<String, String> storedKeyData = new MetaDataStore(this.filesDir).readKeyData(currentSessionId);
                NativeCrashWriter.writeNativeCrash(crashEventData, this.logFileManager, storedKeyData, cos);
            } else {
                Fabric.getLogger().e("Fabric", "Tried to write a native crash while no session was open.", null);
            }
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "An error occurred in the native crash logger", (Throwable)e);
            ExceptionUtils.writeStackTraceIfNotNull(e, fos);
        }
        finally {
            CommonUtils.flushOrLog(cos, (String)"Failed to flush to session begin file.");
            CommonUtils.closeOrLog(fos, (String)"Failed to close fatal exception file output stream.");
        }
    }

    void cacheUserData(final String userId, final String userName, final String userEmail) {
        this.executorServiceWrapper.executeAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String currentSessionId = CrashlyticsUncaughtExceptionHandler.this.getCurrentSessionId();
                new MetaDataStore(CrashlyticsUncaughtExceptionHandler.this.filesDir).writeUserData(currentSessionId, new UserMetaData(userId, userName, userEmail));
                return null;
            }
        });
    }

    void cacheKeyData(final Map<String, String> keyData) {
        this.executorServiceWrapper.executeAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String currentSessionId = CrashlyticsUncaughtExceptionHandler.this.getCurrentSessionId();
                new MetaDataStore(CrashlyticsUncaughtExceptionHandler.this.filesDir).writeKeyData(currentSessionId, keyData);
                return null;
            }
        });
    }

    void ensureOpenSessionExists() {
        this.executorServiceWrapper.executeAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (!CrashlyticsUncaughtExceptionHandler.this.hasOpenSession()) {
                    CrashlyticsUncaughtExceptionHandler.this.doOpenSession();
                } else {
                    CrashlyticsUncaughtExceptionHandler.this.logFileManager.onSessionChange(CrashlyticsUncaughtExceptionHandler.this.getCurrentSessionId());
                }
                return null;
            }
        });
    }

    private String getCurrentSessionId() {
        File[] sessionBeginFiles = this.listFilesMatching(new FileNameContainsFilter(SESSION_BEGIN_TAG));
        Arrays.sort(sessionBeginFiles, LARGEST_FILE_NAME_FIRST);
        return sessionBeginFiles.length > 0 ? this.getSessionIdFromSessionFile(sessionBeginFiles[0]) : null;
    }

    private String getSessionIdFromSessionFile(File sessionFile) {
        return sessionFile.getName().substring(0, 35);
    }

    boolean hasOpenSession() {
        return this.listSessionBeginFiles().length > 0;
    }

    boolean finalizeSessions() {
        return this.executorServiceWrapper.executeSyncLoggingException(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (!CrashlyticsUncaughtExceptionHandler.this.isHandlingException.get()) {
                    SessionEventData crashEventData = CrashlyticsUncaughtExceptionHandler.this.crashlyticsCore.getExternalCrashEventData();
                    if (crashEventData != null) {
                        CrashlyticsUncaughtExceptionHandler.this.writeExternalCrashEvent(crashEventData);
                    }
                    CrashlyticsUncaughtExceptionHandler.this.doCloseSessions();
                    CrashlyticsUncaughtExceptionHandler.this.doOpenSession();
                    Fabric.getLogger().d("Fabric", "Open sessions were closed and a new session was opened.");
                    return true;
                }
                Fabric.getLogger().d("Fabric", "Skipping session finalization because a crash has already occurred.");
                return false;
            }
        });
    }

    private void doOpenSession() throws Exception {
        Date startedAt = new Date();
        String sessionIdentifier = new CLSUUID(this.idManager).toString();
        Fabric.getLogger().d("Fabric", "Opening an new session with ID " + sessionIdentifier);
        this.logFileManager.onSessionChange(sessionIdentifier);
        this.writeBeginSession(sessionIdentifier, startedAt);
        this.writeSessionApp(sessionIdentifier);
        this.writeSessionOS(sessionIdentifier);
        this.writeSessionDevice(sessionIdentifier);
    }

    private void doCloseSessions() throws Exception {
        this.trimOpenSessions(8);
        String currentSessionId = this.getCurrentSessionId();
        if (currentSessionId != null) {
            this.writeSessionUser(currentSessionId);
            SessionSettingsData settingsData = this.crashlyticsCore.getSessionSettingsData();
            if (settingsData != null) {
                int maxLoggedExceptionsCount = settingsData.maxCustomExceptionEvents;
                Fabric.getLogger().d("Fabric", "Closing all open sessions.");
                File[] sessionBeginFiles = this.listSessionBeginFiles();
                if (sessionBeginFiles != null && sessionBeginFiles.length > 0) {
                    for (File sessionBeginFile : sessionBeginFiles) {
                        String sessionIdentifier = this.getSessionIdFromSessionFile(sessionBeginFile);
                        Fabric.getLogger().d("Fabric", "Closing session: " + sessionIdentifier);
                        this.writeSessionPartsToSessionFile(sessionBeginFile, sessionIdentifier, maxLoggedExceptionsCount);
                    }
                }
            } else {
                Fabric.getLogger().d("Fabric", "Unable to close session. Settings are not loaded.");
            }
        } else {
            Fabric.getLogger().d("Fabric", "No open sessions exist.");
        }
    }

    private void closeWithoutRenamingOrLog(ClsFileOutputStream fos) {
        if (fos != null) {
            try {
                fos.closeInProgressStream();
            }
            catch (IOException ex) {
                Fabric.getLogger().e("Fabric", "Error closing session file stream in the presence of an exception", (Throwable)ex);
            }
        }
    }

    private void deleteSessionPartFilesFor(String sessionId) {
        for (File file : this.listSessionPartFilesFor(sessionId)) {
            file.delete();
        }
    }

    private File[] listSessionPartFilesFor(String sessionId) {
        return this.listFilesMatching(new SessionPartFileFilter(sessionId));
    }

    private File[] listCompleteSessionFiles() {
        return this.listFilesMatching(SESSION_FILE_FILTER);
    }

    File[] listSessionBeginFiles() {
        return this.listFilesMatching(new FileNameContainsFilter(SESSION_BEGIN_TAG));
    }

    private File[] listFilesMatching(FilenameFilter filter) {
        return this.ensureFileArrayNotNull(this.filesDir.listFiles(filter));
    }

    private File[] ensureFileArrayNotNull(File[] files) {
        return files == null ? new File[]{} : files;
    }

    private void trimSessionEventFiles(String sessionId, int limit) {
        Utils.capFileCount(this.filesDir, new FileNameContainsFilter(sessionId + SESSION_NON_FATAL_TAG), limit, SMALLEST_FILE_NAME_FIRST);
    }

    void trimSessionFiles() {
        Utils.capFileCount(this.filesDir, SESSION_FILE_FILTER, 4, SMALLEST_FILE_NAME_FIRST);
    }

    private void trimOpenSessions(int maxOpenSessionCount) {
        File[] allSessionPartFiles;
        HashSet<String> sessionIdsToKeep = new HashSet<String>();
        File[] beginSessionFiles = this.listSessionBeginFiles();
        Arrays.sort(beginSessionFiles, LARGEST_FILE_NAME_FIRST);
        int count = Math.min(maxOpenSessionCount, beginSessionFiles.length);
        for (int i = 0; i < count; ++i) {
            String sessionId = this.getSessionIdFromSessionFile(beginSessionFiles[i]);
            sessionIdsToKeep.add(sessionId);
        }
        for (File sessionPartFile : allSessionPartFiles = this.listFilesMatching(new AnySessionPartFileFilter())) {
            String fileName = sessionPartFile.getName();
            Matcher matcher = SESSION_FILE_PATTERN.matcher(fileName);
            matcher.matches();
            String sessionId = matcher.group(1);
            if (sessionIdsToKeep.contains(sessionId)) continue;
            Fabric.getLogger().d("Fabric", "Trimming open session file: " + fileName);
            sessionPartFile.delete();
        }
    }

    void cleanInvalidTempFiles() {
        this.executorServiceWrapper.executeAsync(new Runnable(){

            @Override
            public void run() {
                CrashlyticsUncaughtExceptionHandler.this.doCleanInvalidTempFiles(CrashlyticsUncaughtExceptionHandler.this.listFilesMatching(ClsFileOutputStream.TEMP_FILENAME_FILTER));
            }
        });
    }

    void doCleanInvalidTempFiles(File[] invalidFiles) {
        this.deleteLegacyInvalidCacheDir();
        for (File invalidFile : invalidFiles) {
            Fabric.getLogger().d("Fabric", "Found invalid session part file: " + invalidFile);
            final String sessionId = this.getSessionIdFromSessionFile(invalidFile);
            FilenameFilter sessionFilter = new FilenameFilter(){

                @Override
                public boolean accept(File f, String name) {
                    return name.startsWith(sessionId);
                }
            };
            Fabric.getLogger().d("Fabric", "Deleting all part files for invalid session: " + sessionId);
            for (File sessionFile : this.listFilesMatching(sessionFilter)) {
                Fabric.getLogger().d("Fabric", "Deleting session file: " + sessionFile);
                sessionFile.delete();
            }
        }
    }

    private void deleteLegacyInvalidCacheDir() {
        File cacheDir = new File(this.crashlyticsCore.getSdkDirectory(), INVALID_CLS_CACHE_DIR);
        if (cacheDir.exists()) {
            if (cacheDir.isDirectory()) {
                for (File cacheFile : cacheDir.listFiles()) {
                    cacheFile.delete();
                }
            }
            cacheDir.delete();
        }
    }

    private void writeBeginSession(String sessionId, Date startedAt) throws Exception {
        ClsFileOutputStream fos = null;
        CodedOutputStream cos = null;
        try {
            fos = new ClsFileOutputStream(this.filesDir, sessionId + SESSION_BEGIN_TAG);
            cos = CodedOutputStream.newInstance(fos);
            String generator = String.format(Locale.US, GENERATOR_FORMAT, this.crashlyticsCore.getVersion());
            long startedAtSeconds = startedAt.getTime() / 1000L;
            this.sessionDataWriter.writeBeginSession(cos, sessionId, generator, startedAtSeconds);
        }
        catch (Exception e) {
            try {
                ExceptionUtils.writeStackTraceIfNotNull(e, fos);
                throw e;
            }
            catch (Throwable throwable) {
                CommonUtils.flushOrLog(cos, (String)"Failed to flush to session begin file.");
                CommonUtils.closeOrLog(fos, (String)"Failed to close begin session file.");
                throw throwable;
            }
        }
        CommonUtils.flushOrLog((Flushable)cos, (String)"Failed to flush to session begin file.");
        CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close begin session file.");
    }

    private void writeSessionApp(String sessionId) throws Exception {
        ClsFileOutputStream fos = null;
        CodedOutputStream cos = null;
        try {
            fos = new ClsFileOutputStream(this.filesDir, sessionId + SESSION_APP_TAG);
            cos = CodedOutputStream.newInstance(fos);
            String packageName = this.crashlyticsCore.getPackageName();
            String versionCode = this.crashlyticsCore.getVersionCode();
            String versionName = this.crashlyticsCore.getVersionName();
            String installUuid = this.idManager.getAppInstallIdentifier();
            int deliveryMechanism = DeliveryMechanism.determineFrom((String)this.crashlyticsCore.getInstallerPackageName()).getId();
            this.sessionDataWriter.writeSessionApp(cos, packageName, versionCode, versionName, installUuid, deliveryMechanism);
        }
        catch (Exception e) {
            try {
                ExceptionUtils.writeStackTraceIfNotNull(e, fos);
                throw e;
            }
            catch (Throwable throwable) {
                CommonUtils.flushOrLog(cos, (String)"Failed to flush to session app file.");
                CommonUtils.closeOrLog(fos, (String)"Failed to close session app file.");
                throw throwable;
            }
        }
        CommonUtils.flushOrLog((Flushable)cos, (String)"Failed to flush to session app file.");
        CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close session app file.");
    }

    private void writeSessionOS(String sessionId) throws Exception {
        ClsFileOutputStream fos = null;
        CodedOutputStream cos = null;
        try {
            fos = new ClsFileOutputStream(this.filesDir, sessionId + SESSION_OS_TAG);
            cos = CodedOutputStream.newInstance(fos);
            boolean isRooted = CommonUtils.isRooted((Context)this.crashlyticsCore.getContext());
            this.sessionDataWriter.writeSessionOS(cos, isRooted);
        }
        catch (Exception e) {
            try {
                ExceptionUtils.writeStackTraceIfNotNull(e, fos);
                throw e;
            }
            catch (Throwable throwable) {
                CommonUtils.flushOrLog(cos, (String)"Failed to flush to session OS file.");
                CommonUtils.closeOrLog(fos, (String)"Failed to close session OS file.");
                throw throwable;
            }
        }
        CommonUtils.flushOrLog((Flushable)cos, (String)"Failed to flush to session OS file.");
        CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close session OS file.");
    }

    private void writeSessionDevice(String sessionId) throws Exception {
        ClsFileOutputStream fos = null;
        CodedOutputStream cos = null;
        try {
            fos = new ClsFileOutputStream(this.filesDir, sessionId + SESSION_DEVICE_TAG);
            cos = CodedOutputStream.newInstance(fos);
            Context context = this.crashlyticsCore.getContext();
            StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
            String clsDeviceId = this.idManager.getDeviceUUID();
            int arch = CommonUtils.getCpuArchitectureInt();
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            long totalRam = CommonUtils.getTotalRamInBytes();
            long diskSpace = (long)statFs.getBlockCount() * (long)statFs.getBlockSize();
            boolean isEmulator = CommonUtils.isEmulator((Context)context);
            Map ids = this.idManager.getDeviceIdentifiers();
            int state = CommonUtils.getDeviceState((Context)context);
            this.sessionDataWriter.writeSessionDevice(cos, clsDeviceId, arch, Build.MODEL, availableProcessors, totalRam, diskSpace, isEmulator, ids, state, Build.MANUFACTURER, Build.PRODUCT);
        }
        catch (Exception e) {
            try {
                ExceptionUtils.writeStackTraceIfNotNull(e, fos);
                throw e;
            }
            catch (Throwable throwable) {
                CommonUtils.flushOrLog(cos, (String)"Failed to flush session device info.");
                CommonUtils.closeOrLog(fos, (String)"Failed to close session device file.");
                throw throwable;
            }
        }
        CommonUtils.flushOrLog((Flushable)cos, (String)"Failed to flush session device info.");
        CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close session device file.");
    }

    private void writeSessionUser(String sessionId) throws Exception {
        UserMetaData userMetaData;
        CodedOutputStream cos;
        ClsFileOutputStream fos;
        block5: {
            fos = null;
            cos = null;
            fos = new ClsFileOutputStream(this.filesDir, sessionId + SESSION_USER_TAG);
            cos = CodedOutputStream.newInstance(fos);
            userMetaData = this.getUserMetaData(sessionId);
            if (!userMetaData.isEmpty()) break block5;
            CommonUtils.flushOrLog((Flushable)cos, (String)"Failed to flush session user file.");
            CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close session user file.");
            return;
        }
        try {
            this.sessionDataWriter.writeSessionUser(cos, userMetaData.id, userMetaData.name, userMetaData.email);
        }
        catch (Exception e) {
            try {
                ExceptionUtils.writeStackTraceIfNotNull(e, fos);
                throw e;
            }
            catch (Throwable throwable) {
                CommonUtils.flushOrLog(cos, (String)"Failed to flush session user file.");
                CommonUtils.closeOrLog(fos, (String)"Failed to close session user file.");
                throw throwable;
            }
        }
        CommonUtils.flushOrLog((Flushable)cos, (String)"Failed to flush session user file.");
        CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close session user file.");
    }

    private UserMetaData getUserMetaData(String sessionId) {
        return this.isHandlingException() ? new UserMetaData(this.crashlyticsCore.getUserIdentifier(), this.crashlyticsCore.getUserName(), this.crashlyticsCore.getUserEmail()) : new MetaDataStore(this.filesDir).readUserData(sessionId);
    }

    private void writeSessionEvent(CodedOutputStream cos, Date time, Thread thread, Throwable ex, String eventType, boolean includeAllThreads) throws Exception {
        Map<Object, Object> attributes;
        Thread[] threads;
        Context context = this.crashlyticsCore.getContext();
        long eventTime = time.getTime() / 1000L;
        float batteryLevel = CommonUtils.getBatteryLevel((Context)context);
        int batteryVelocity = CommonUtils.getBatteryVelocity((Context)context, (boolean)this.powerConnected);
        boolean proximityEnabled = CommonUtils.getProximitySensorEnabled((Context)context);
        int orientation = context.getResources().getConfiguration().orientation;
        long usedRamBytes = CommonUtils.getTotalRamInBytes() - CommonUtils.calculateFreeRamInBytes((Context)context);
        long diskUsedBytes = CommonUtils.calculateUsedDiskSpaceInBytes((String)Environment.getDataDirectory().getPath());
        ActivityManager.RunningAppProcessInfo runningAppProcessInfo = CommonUtils.getAppProcessInfo((String)context.getPackageName(), (Context)context);
        LinkedList<StackTraceElement[]> stacks = new LinkedList<StackTraceElement[]>();
        StackTraceElement[] exceptionStack = ex.getStackTrace();
        if (includeAllThreads) {
            Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
            threads = new Thread[allStackTraces.size()];
            int i = 0;
            for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
                threads[i] = entry.getKey();
                stacks.add(entry.getValue());
                ++i;
            }
        } else {
            threads = new Thread[]{};
        }
        if (!CommonUtils.getBooleanResourceValue((Context)context, (String)"com.crashlytics.CollectCustomKeys", (boolean)true)) {
            attributes = new TreeMap();
        } else {
            attributes = this.crashlyticsCore.getAttributes();
            if (attributes != null && attributes.size() > 1) {
                attributes = new TreeMap<Object, Object>(attributes);
            }
        }
        this.sessionDataWriter.writeSessionEvent(cos, eventTime, thread, ex, eventType, threads, batteryLevel, batteryVelocity, proximityEnabled, orientation, usedRamBytes, diskUsedBytes, runningAppProcessInfo, stacks, exceptionStack, this.logFileManager, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriteNonFatal(Date time, Thread thread, Throwable ex) {
        block9: {
            block8: {
                String currentSessionId;
                block7: {
                    currentSessionId = this.getCurrentSessionId();
                    if (currentSessionId == null) break block8;
                    CrashlyticsCore.recordLoggedExceptionEvent(currentSessionId);
                    ClsFileOutputStream fos = null;
                    CodedOutputStream cos = null;
                    try {
                        Fabric.getLogger().d("Fabric", "Crashlytics is logging non-fatal exception \"" + ex + "\" from thread " + thread.getName());
                        String counterString = CommonUtils.padWithZerosToMaxIntWidth((int)this.eventCounter.getAndIncrement());
                        String nonFatalFileName = currentSessionId + SESSION_NON_FATAL_TAG + counterString;
                        fos = new ClsFileOutputStream(this.filesDir, nonFatalFileName);
                        cos = CodedOutputStream.newInstance(fos);
                        this.writeSessionEvent(cos, time, thread, ex, EVENT_TYPE_LOGGED, false);
                        CommonUtils.flushOrLog((Flushable)cos, (String)"Failed to flush to non-fatal file.");
                    }
                    catch (Exception e) {
                        Fabric.getLogger().e("Fabric", "An error occurred in the non-fatal exception logger", (Throwable)e);
                        ExceptionUtils.writeStackTraceIfNotNull(e, fos);
                        break block7;
                    }
                    finally {
                        CommonUtils.flushOrLog(cos, (String)"Failed to flush to non-fatal file.");
                        CommonUtils.closeOrLog(fos, (String)"Failed to close non-fatal file output stream.");
                    }
                    CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close non-fatal file output stream.");
                }
                try {
                    this.trimSessionEventFiles(currentSessionId, 64);
                }
                catch (Exception e) {
                    Fabric.getLogger().e("Fabric", "An error occurred when trimming non-fatal files.", (Throwable)e);
                }
                break block9;
            }
            Fabric.getLogger().e("Fabric", "Tried to write a non-fatal exception while no session was open.", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSessionPartsToSessionFile(File sessionBeginFile, String sessionId, int maxLoggedExceptionsCount) {
        block13: {
            block14: {
                Fabric.getLogger().d("Fabric", "Collecting session parts for ID " + sessionId);
                File[] fatalFiles = this.listFilesMatching(new FileNameContainsFilter(sessionId + SESSION_FATAL_TAG));
                boolean hasFatal = fatalFiles != null && fatalFiles.length > 0;
                Fabric.getLogger().d("Fabric", String.format(Locale.US, "Session %s has fatal exception: %s", sessionId, hasFatal));
                File[] nonFatalFiles = this.listFilesMatching(new FileNameContainsFilter(sessionId + SESSION_NON_FATAL_TAG));
                boolean hasNonFatal = nonFatalFiles != null && nonFatalFiles.length > 0;
                Fabric.getLogger().d("Fabric", String.format(Locale.US, "Session %s has non-fatal exceptions: %s", sessionId, hasNonFatal));
                if (!hasFatal && !hasNonFatal) break block14;
                ClsFileOutputStream fos = null;
                CodedOutputStream cos = null;
                boolean exceptionDuringWrite = false;
                try {
                    fos = new ClsFileOutputStream(this.filesDir, sessionId);
                    cos = CodedOutputStream.newInstance(fos);
                    Fabric.getLogger().d("Fabric", "Collecting SessionStart data for session ID " + sessionId);
                    this.writeToCosFromFile(cos, sessionBeginFile);
                    cos.writeUInt64(4, new Date().getTime() / 1000L);
                    cos.writeBool(5, hasFatal);
                    this.writeInitialPartsTo(cos, sessionId);
                    if (hasNonFatal) {
                        if (nonFatalFiles.length > maxLoggedExceptionsCount) {
                            Fabric.getLogger().d("Fabric", String.format(Locale.US, "Trimming down to %d logged exceptions.", maxLoggedExceptionsCount));
                            this.trimSessionEventFiles(sessionId, maxLoggedExceptionsCount);
                            nonFatalFiles = this.listFilesMatching(new FileNameContainsFilter(sessionId + SESSION_NON_FATAL_TAG));
                        }
                        this.writeNonFatalEventsTo(cos, nonFatalFiles, sessionId);
                    }
                    if (hasFatal) {
                        this.writeToCosFromFile(cos, fatalFiles[0]);
                    }
                    cos.writeUInt32(11, 1);
                    cos.writeEnum(12, 3);
                }
                catch (Exception e) {
                    try {
                        Fabric.getLogger().e("Fabric", "Failed to write session file for session ID: " + sessionId, (Throwable)e);
                        ExceptionUtils.writeStackTraceIfNotNull(e, fos);
                        exceptionDuringWrite = true;
                    }
                    catch (Throwable throwable) {
                        CommonUtils.flushOrLog(cos, (String)"Error flushing session file stream");
                        if (exceptionDuringWrite) {
                            this.closeWithoutRenamingOrLog(fos);
                        } else {
                            CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close CLS file");
                        }
                        throw throwable;
                    }
                    CommonUtils.flushOrLog((Flushable)cos, (String)"Error flushing session file stream");
                    if (exceptionDuringWrite) {
                        this.closeWithoutRenamingOrLog(fos);
                    } else {
                        CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close CLS file");
                    }
                    break block13;
                }
                CommonUtils.flushOrLog((Flushable)cos, (String)"Error flushing session file stream");
                if (exceptionDuringWrite) {
                    this.closeWithoutRenamingOrLog(fos);
                } else {
                    CommonUtils.closeOrLog((Closeable)fos, (String)"Failed to close CLS file");
                }
                break block13;
            }
            Fabric.getLogger().d("Fabric", "No events present for session ID " + sessionId);
        }
        Fabric.getLogger().d("Fabric", "Removing session part files for ID " + sessionId);
        this.deleteSessionPartFilesFor(sessionId);
    }

    private void writeNonFatalEventsTo(CodedOutputStream cos, File[] nonFatalFiles, String sessionId) {
        Arrays.sort(nonFatalFiles, CommonUtils.FILE_MODIFIED_COMPARATOR);
        for (File nonFatalFile : nonFatalFiles) {
            try {
                Fabric.getLogger().d("Fabric", String.format(Locale.US, "Found Non Fatal for session ID %s in %s ", sessionId, nonFatalFile.getName()));
                this.writeToCosFromFile(cos, nonFatalFile);
            }
            catch (Exception e) {
                Fabric.getLogger().e("Fabric", "Error writting non-fatal to session.", (Throwable)e);
            }
        }
    }

    private void writeInitialPartsTo(CodedOutputStream cos, String sessionId) throws IOException {
        String[] tags;
        for (String tag : tags = new String[]{SESSION_USER_TAG, SESSION_APP_TAG, SESSION_OS_TAG, SESSION_DEVICE_TAG}) {
            File[] sessionPartFiles = this.listFilesMatching(new FileNameContainsFilter(sessionId + tag));
            if (sessionPartFiles.length == 0) {
                Fabric.getLogger().e("Fabric", "Can't find " + tag + " data for session ID " + sessionId, null);
                continue;
            }
            Fabric.getLogger().d("Fabric", "Collecting " + tag + " data for session ID " + sessionId);
            this.writeToCosFromFile(cos, sessionPartFiles[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToCosFromFile(CodedOutputStream cos, File file) throws IOException {
        if (file.exists()) {
            long length = file.length();
            byte[] bytes = new byte[(int)length];
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                int numRead = 0;
                for (int offset = 0; offset < bytes.length && (numRead = fis.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
                }
            }
            finally {
                CommonUtils.closeOrLog((Closeable)fis, (String)"Failed to close file input stream.");
            }
            cos.writeRawBytes(bytes);
        } else {
            Fabric.getLogger().e("Fabric", "Tried to include a file that doesn't exist: " + file.getName(), null);
        }
    }

    private void sendSessionReports() {
        File[] arr$ = this.listCompleteSessionFiles();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            File finishedSessionFile;
            final File toSend = finishedSessionFile = arr$[i$];
            this.executorServiceWrapper.executeAsync(new Runnable(){

                @Override
                public void run() {
                    if (CommonUtils.canTryConnection((Context)CrashlyticsUncaughtExceptionHandler.this.crashlyticsCore.getContext())) {
                        Fabric.getLogger().d("Fabric", "Attempting to send crash report at time of crash...");
                        SettingsData settingsData = Settings.getInstance().awaitSettingsData();
                        CreateReportSpiCall call = CrashlyticsUncaughtExceptionHandler.this.crashlyticsCore.getCreateReportSpiCall(settingsData);
                        if (call != null) {
                            new ReportUploader(call).forceUpload(new SessionReport(toSend, SEND_AT_CRASHTIME_HEADER));
                        }
                    }
                }
            });
        }
    }

    private static class AnySessionPartFileFilter
    implements FilenameFilter {
        private AnySessionPartFileFilter() {
        }

        @Override
        public boolean accept(File file, String fileName) {
            return !SESSION_FILE_FILTER.accept(file, fileName) && SESSION_FILE_PATTERN.matcher(fileName).matches();
        }
    }

    static class SessionPartFileFilter
    implements FilenameFilter {
        private final String sessionId;

        public SessionPartFileFilter(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public boolean accept(File file, String fileName) {
            if (fileName.equals(this.sessionId + ".cls")) {
                return false;
            }
            return fileName.contains(this.sessionId) && !fileName.endsWith(".cls_temp");
        }
    }

    static class FileNameContainsFilter
    implements FilenameFilter {
        private final String string;

        public FileNameContainsFilter(String s) {
            this.string = s;
        }

        @Override
        public boolean accept(File dir, String filename) {
            return filename.contains(this.string) && !filename.endsWith(".cls_temp");
        }
    }
}

