/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import android.content.Context;
import com.crashlytics.android.core.ByteString;
import com.crashlytics.android.core.FileLogStore;
import com.crashlytics.android.core.QueueFileLogStore;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.CommonUtils;
import java.io.File;

class LogFileManager {
    private static final String LOGFILE_EXT = ".temp";
    private static final String LOGFILE_PREFIX = "crashlytics-userlog-";
    private static final String DIRECTORY_NAME = "log-files";
    private static final NoopLogStore NOOP_LOG_STORE = new NoopLogStore();
    static final int MAX_LOG_SIZE = 65536;
    private final Context context;
    private final File logFileDir;
    private FileLogStore currentLog;

    public LogFileManager(Context context, File filesDir) {
        this.context = context;
        this.logFileDir = new File(filesDir, DIRECTORY_NAME);
        this.currentLog = NOOP_LOG_STORE;
    }

    public void onSessionChange(String sessionId) {
        this.clearLog();
        if (!this.isLoggingEnabled()) {
            Fabric.getLogger().d("Fabric", "Preferences requested no custom logs. Aborting log file creation.");
            this.currentLog = NOOP_LOG_STORE;
            return;
        }
        this.setLogFile(this.getWorkingFileForSession(sessionId), 65536);
    }

    public void writeToLog(long timestamp, String msg) {
        this.currentLog.writeToLog(timestamp, msg);
    }

    public ByteString getByteStringForLog() {
        return this.currentLog.getLogAsByteString();
    }

    public void clearLog() {
        this.currentLog.deleteLogFile();
    }

    void setLogFile(File workingFile, int maxLogSize) {
        this.currentLog.closeLogFile();
        this.currentLog = new QueueFileLogStore(workingFile, maxLogSize);
    }

    private File getWorkingFileForSession(String sessionId) {
        this.ensureTargetDirectoryExists();
        String fileName = LOGFILE_PREFIX + sessionId + LOGFILE_EXT;
        return new File(this.logFileDir, fileName);
    }

    private void ensureTargetDirectoryExists() {
        if (!this.logFileDir.exists()) {
            this.logFileDir.mkdirs();
        }
    }

    private boolean isLoggingEnabled() {
        return CommonUtils.getBooleanResourceValue((Context)this.context, (String)"com.crashlytics.CollectCustomLogs", (boolean)true);
    }

    private static final class NoopLogStore
    implements FileLogStore {
        private NoopLogStore() {
        }

        @Override
        public void writeToLog(long timestamp, String msg) {
        }

        @Override
        public ByteString getLogAsByteString() {
            return null;
        }

        @Override
        public void closeLogFile() {
        }

        @Override
        public void deleteLogFile() {
        }
    }
}

