/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.persistence.FileStore;
import java.io.File;
import java.io.IOException;

class CrashlyticsFileMarker {
    private final String markerName;
    private final FileStore fileStore;

    public CrashlyticsFileMarker(String markerName, FileStore fileStore) {
        this.markerName = markerName;
        this.fileStore = fileStore;
    }

    public boolean create() {
        boolean wasCreated = false;
        try {
            wasCreated = this.getMarkerFile().createNewFile();
        }
        catch (IOException e) {
            Fabric.getLogger().e("CrashlyticsCore", "Error creating marker: " + this.markerName, (Throwable)e);
        }
        return wasCreated;
    }

    public boolean isPresent() {
        return this.getMarkerFile().exists();
    }

    public boolean remove() {
        return this.getMarkerFile().delete();
    }

    private File getMarkerFile() {
        return new File(this.fileStore.getFilesDir(), this.markerName);
    }
}

