/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import android.app.ActivityManager;
import android.os.Build;
import com.crashlytics.android.core.ByteString;
import com.crashlytics.android.core.CodedOutputStream;
import com.crashlytics.android.core.LogFileManager;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.IdManager;
import java.util.List;
import java.util.Map;

class SessionProtobufHelper {
    private static final String SIGNAL_DEFAULT = "0";
    private static final ByteString SIGNAL_DEFAULT_BYTE_STRING = ByteString.copyFromUtf8("0");
    private static final ByteString UNITY_PLATFORM_BYTE_STRING = ByteString.copyFromUtf8("Unity");

    private SessionProtobufHelper() {
    }

    public static void writeBeginSession(CodedOutputStream cos, String sessionId, String generator, long startedAtSeconds) throws Exception {
        cos.writeBytes(1, ByteString.copyFromUtf8(generator));
        cos.writeBytes(2, ByteString.copyFromUtf8(sessionId));
        cos.writeUInt64(3, startedAtSeconds);
    }

    public static void writeSessionApp(CodedOutputStream cos, String packageName, String apiKey, String versionCode, String versionName, String installUuid, int deliveryMechanism, String unityVersion) throws Exception {
        ByteString packageNameBytes = ByteString.copyFromUtf8(packageName);
        ByteString apiKeyBytes = ByteString.copyFromUtf8(apiKey);
        ByteString versionCodeBytes = ByteString.copyFromUtf8(versionCode);
        ByteString versionNameBytes = ByteString.copyFromUtf8(versionName);
        ByteString installIdBytes = ByteString.copyFromUtf8(installUuid);
        ByteString unityVersionBytes = unityVersion != null ? ByteString.copyFromUtf8(unityVersion) : null;
        cos.writeTag(7, 2);
        cos.writeRawVarint32(SessionProtobufHelper.getSessionAppSize(packageNameBytes, apiKeyBytes, versionCodeBytes, versionNameBytes, installIdBytes, deliveryMechanism, unityVersionBytes));
        cos.writeBytes(1, packageNameBytes);
        cos.writeBytes(2, versionCodeBytes);
        cos.writeBytes(3, versionNameBytes);
        cos.writeTag(5, 2);
        cos.writeRawVarint32(SessionProtobufHelper.getSessionAppOrgSize(apiKeyBytes));
        cos.writeBytes(1, apiKeyBytes);
        cos.writeBytes(6, installIdBytes);
        if (unityVersionBytes != null) {
            cos.writeBytes(8, UNITY_PLATFORM_BYTE_STRING);
            cos.writeBytes(9, unityVersionBytes);
        }
        cos.writeEnum(10, deliveryMechanism);
    }

    public static void writeSessionOS(CodedOutputStream cos, boolean isRooted) throws Exception {
        ByteString releaseBytes = ByteString.copyFromUtf8(Build.VERSION.RELEASE);
        ByteString codeNameBytes = ByteString.copyFromUtf8(Build.VERSION.CODENAME);
        cos.writeTag(8, 2);
        cos.writeRawVarint32(SessionProtobufHelper.getSessionOSSize(releaseBytes, codeNameBytes, isRooted));
        cos.writeEnum(1, 3);
        cos.writeBytes(2, releaseBytes);
        cos.writeBytes(3, codeNameBytes);
        cos.writeBool(4, isRooted);
    }

    public static void writeSessionDevice(CodedOutputStream cos, String clsDeviceId, int arch, String model, int availableProcessors, long totalRam, long diskSpace, boolean isEmulator, Map<IdManager.DeviceIdentifierType, String> ids, int state, String manufacturer, String modelClass) throws Exception {
        ByteString clsDeviceIDBytes = ByteString.copyFromUtf8(clsDeviceId);
        ByteString modelBytes = SessionProtobufHelper.stringToByteString(model);
        ByteString modelClassBytes = SessionProtobufHelper.stringToByteString(modelClass);
        ByteString manufacturerBytes = SessionProtobufHelper.stringToByteString(manufacturer);
        cos.writeTag(9, 2);
        cos.writeRawVarint32(SessionProtobufHelper.getSessionDeviceSize(arch, clsDeviceIDBytes, modelBytes, availableProcessors, totalRam, diskSpace, isEmulator, ids, state, manufacturerBytes, modelClassBytes));
        cos.writeBytes(1, clsDeviceIDBytes);
        cos.writeEnum(3, arch);
        cos.writeBytes(4, modelBytes);
        cos.writeUInt32(5, availableProcessors);
        cos.writeUInt64(6, totalRam);
        cos.writeUInt64(7, diskSpace);
        cos.writeBool(10, isEmulator);
        for (Map.Entry<IdManager.DeviceIdentifierType, String> id : ids.entrySet()) {
            cos.writeTag(11, 2);
            cos.writeRawVarint32(SessionProtobufHelper.getDeviceIdentifierSize(id.getKey(), id.getValue()));
            cos.writeEnum(1, id.getKey().protobufIndex);
            cos.writeBytes(2, ByteString.copyFromUtf8(id.getValue()));
        }
        cos.writeUInt32(12, state);
        if (manufacturerBytes != null) {
            cos.writeBytes(13, manufacturerBytes);
        }
        if (modelClassBytes != null) {
            cos.writeBytes(14, modelClassBytes);
        }
    }

    public static void writeSessionUser(CodedOutputStream cos, String id, String name, String email) throws Exception {
        ByteString idBytes = ByteString.copyFromUtf8(id == null ? "" : id);
        ByteString nameBytes = SessionProtobufHelper.stringToByteString(name);
        ByteString emailBytes = SessionProtobufHelper.stringToByteString(email);
        int size = 0;
        size += CodedOutputStream.computeBytesSize(1, idBytes);
        if (name != null) {
            size += CodedOutputStream.computeBytesSize(2, nameBytes);
        }
        if (email != null) {
            size += CodedOutputStream.computeBytesSize(3, emailBytes);
        }
        cos.writeTag(6, 2);
        cos.writeRawVarint32(size);
        cos.writeBytes(1, idBytes);
        if (name != null) {
            cos.writeBytes(2, nameBytes);
        }
        if (email != null) {
            cos.writeBytes(3, emailBytes);
        }
    }

    public static void writeSessionEvent(CodedOutputStream cos, long eventTime, String eventType, Throwable exception, Thread exceptionThread, StackTraceElement[] exceptionStack, Thread[] otherThreads, List<StackTraceElement[]> otherStacks, Map<String, String> customAttributes, LogFileManager logFileManager, ActivityManager.RunningAppProcessInfo runningAppProcessInfo, int orientation, String packageName, String buildId, float batteryLevel, int batteryVelocity, boolean proximityEnabled, long usedRamInBytes, long diskUsedInBytes) throws Exception {
        ByteString packageNameBytes = ByteString.copyFromUtf8(packageName);
        ByteString optionalBuildIdBytes = buildId == null ? null : ByteString.copyFromUtf8(buildId.replace("-", ""));
        ByteString logByteString = logFileManager.getByteStringForLog();
        if (logByteString == null) {
            Fabric.getLogger().d("CrashlyticsCore", "No log data to include with this event.");
        }
        logFileManager.clearLog();
        int maxChainedExceptionsDepth = 8;
        cos.writeTag(10, 2);
        cos.writeRawVarint32(SessionProtobufHelper.getSessionEventSize(eventTime, eventType, exception, exceptionThread, exceptionStack, otherThreads, otherStacks, 8, customAttributes, runningAppProcessInfo, orientation, packageNameBytes, optionalBuildIdBytes, batteryLevel, batteryVelocity, proximityEnabled, usedRamInBytes, diskUsedInBytes, logByteString));
        cos.writeUInt64(1, eventTime);
        cos.writeBytes(2, ByteString.copyFromUtf8(eventType));
        SessionProtobufHelper.writeSessionEventApp(cos, exception, exceptionThread, exceptionStack, otherThreads, otherStacks, 8, packageNameBytes, optionalBuildIdBytes, customAttributes, runningAppProcessInfo, orientation);
        SessionProtobufHelper.writeSessionEventDevice(cos, batteryLevel, batteryVelocity, proximityEnabled, orientation, usedRamInBytes, diskUsedInBytes);
        SessionProtobufHelper.writeSessionEventLog(cos, logByteString);
    }

    private static void writeSessionEventApp(CodedOutputStream cos, Throwable exception, Thread exceptionThread, StackTraceElement[] exceptionStack, Thread[] otherThreads, List<StackTraceElement[]> otherStacks, int maxChainedExceptionsDepth, ByteString packageNameBytes, ByteString optionalBuildIdBytes, Map<String, String> customAttributes, ActivityManager.RunningAppProcessInfo runningAppProcessInfo, int orientation) throws Exception {
        cos.writeTag(3, 2);
        cos.writeRawVarint32(SessionProtobufHelper.getEventAppSize(exception, exceptionThread, exceptionStack, otherThreads, otherStacks, maxChainedExceptionsDepth, packageNameBytes, optionalBuildIdBytes, customAttributes, runningAppProcessInfo, orientation));
        SessionProtobufHelper.writeSessionEventAppExecution(cos, exception, exceptionThread, exceptionStack, otherThreads, otherStacks, maxChainedExceptionsDepth, packageNameBytes, optionalBuildIdBytes);
        if (customAttributes != null && !customAttributes.isEmpty()) {
            SessionProtobufHelper.writeSessionEventAppCustomAttributes(cos, customAttributes);
        }
        if (runningAppProcessInfo != null) {
            cos.writeBool(3, runningAppProcessInfo.importance != 100);
        }
        cos.writeUInt32(4, orientation);
    }

    private static void writeSessionEventAppExecution(CodedOutputStream cos, Throwable exception, Thread exceptionThread, StackTraceElement[] exceptionStack, Thread[] otherThreads, List<StackTraceElement[]> otherStacks, int maxChainedExceptionsDepth, ByteString packageNameBytes, ByteString optionalBuildIdBytes) throws Exception {
        cos.writeTag(1, 2);
        cos.writeRawVarint32(SessionProtobufHelper.getEventAppExecutionSize(exception, exceptionThread, exceptionStack, otherThreads, otherStacks, maxChainedExceptionsDepth, packageNameBytes, optionalBuildIdBytes));
        SessionProtobufHelper.writeThread(cos, exceptionThread, exceptionStack, 4, true);
        int len = otherThreads.length;
        for (int i = 0; i < len; ++i) {
            Thread thread = otherThreads[i];
            SessionProtobufHelper.writeThread(cos, thread, otherStacks.get(i), 0, false);
        }
        SessionProtobufHelper.writeSessionEventAppExecutionException(cos, exception, 1, maxChainedExceptionsDepth, 2);
        cos.writeTag(3, 2);
        cos.writeRawVarint32(SessionProtobufHelper.getEventAppExecutionSignalSize());
        cos.writeBytes(1, SIGNAL_DEFAULT_BYTE_STRING);
        cos.writeBytes(2, SIGNAL_DEFAULT_BYTE_STRING);
        cos.writeUInt64(3, 0L);
        cos.writeTag(4, 2);
        cos.writeRawVarint32(SessionProtobufHelper.getBinaryImageSize(packageNameBytes, optionalBuildIdBytes));
        cos.writeUInt64(1, 0L);
        cos.writeUInt64(2, 0L);
        cos.writeBytes(3, packageNameBytes);
        if (optionalBuildIdBytes != null) {
            cos.writeBytes(4, optionalBuildIdBytes);
        }
    }

    private static void writeSessionEventAppCustomAttributes(CodedOutputStream cos, Map<String, String> customAttributes) throws Exception {
        for (Map.Entry<String, String> entry : customAttributes.entrySet()) {
            cos.writeTag(2, 2);
            cos.writeRawVarint32(SessionProtobufHelper.getEventAppCustomAttributeSize(entry.getKey(), entry.getValue()));
            cos.writeBytes(1, ByteString.copyFromUtf8(entry.getKey()));
            String value = entry.getValue();
            cos.writeBytes(2, ByteString.copyFromUtf8(value == null ? "" : value));
        }
    }

    private static void writeSessionEventAppExecutionException(CodedOutputStream cos, Throwable exception, int chainDepth, int maxChainedExceptionsDepth, int field) throws Exception {
        cos.writeTag(field, 2);
        cos.writeRawVarint32(SessionProtobufHelper.getEventAppExecutionExceptionSize(exception, 1, maxChainedExceptionsDepth));
        cos.writeBytes(1, ByteString.copyFromUtf8(exception.getClass().getName()));
        String message = exception.getLocalizedMessage();
        if (message != null) {
            cos.writeBytes(3, ByteString.copyFromUtf8(message));
        }
        for (StackTraceElement element : exception.getStackTrace()) {
            SessionProtobufHelper.writeFrame(cos, 4, element, true);
        }
        Throwable cause = exception.getCause();
        if (cause != null) {
            if (chainDepth < maxChainedExceptionsDepth) {
                SessionProtobufHelper.writeSessionEventAppExecutionException(cos, cause, chainDepth + 1, maxChainedExceptionsDepth, 6);
            } else {
                int overflowCount = 0;
                while (cause != null) {
                    cause = cause.getCause();
                    ++overflowCount;
                }
                cos.writeUInt32(7, overflowCount);
            }
        }
    }

    private static void writeThread(CodedOutputStream cos, Thread thread, StackTraceElement[] stackTraceElements, int importance, boolean isCrashedThread) throws Exception {
        cos.writeTag(1, 2);
        int s = SessionProtobufHelper.getThreadSize(thread, stackTraceElements, importance, isCrashedThread);
        cos.writeRawVarint32(s);
        cos.writeBytes(1, ByteString.copyFromUtf8(thread.getName()));
        cos.writeUInt32(2, importance);
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            SessionProtobufHelper.writeFrame(cos, 3, stackTraceElement, isCrashedThread);
        }
    }

    private static void writeFrame(CodedOutputStream cos, int fieldIndex, StackTraceElement element, boolean isCrashedThread) throws Exception {
        cos.writeTag(fieldIndex, 2);
        cos.writeRawVarint32(SessionProtobufHelper.getFrameSize(element, isCrashedThread));
        if (element.isNativeMethod()) {
            cos.writeUInt64(1, Math.max(element.getLineNumber(), 0));
        } else {
            cos.writeUInt64(1, 0L);
        }
        cos.writeBytes(2, ByteString.copyFromUtf8(element.getClassName() + "." + element.getMethodName()));
        if (element.getFileName() != null) {
            cos.writeBytes(3, ByteString.copyFromUtf8(element.getFileName()));
        }
        if (!element.isNativeMethod() && element.getLineNumber() > 0) {
            cos.writeUInt64(4, element.getLineNumber());
        }
        cos.writeUInt32(5, isCrashedThread ? 4 : 0);
    }

    private static void writeSessionEventDevice(CodedOutputStream cos, float batteryLevel, int batteryVelocity, boolean proximityEnabled, int orientation, long heapAllocatedSize, long diskUsed) throws Exception {
        cos.writeTag(5, 2);
        cos.writeRawVarint32(SessionProtobufHelper.getEventDeviceSize(batteryLevel, batteryVelocity, proximityEnabled, orientation, heapAllocatedSize, diskUsed));
        cos.writeFloat(1, batteryLevel);
        cos.writeSInt32(2, batteryVelocity);
        cos.writeBool(3, proximityEnabled);
        cos.writeUInt32(4, orientation);
        cos.writeUInt64(5, heapAllocatedSize);
        cos.writeUInt64(6, diskUsed);
    }

    private static void writeSessionEventLog(CodedOutputStream cos, ByteString log) throws Exception {
        if (log != null) {
            cos.writeTag(6, 2);
            cos.writeRawVarint32(SessionProtobufHelper.getEventLogSize(log));
            cos.writeBytes(1, log);
        }
    }

    private static int getSessionAppSize(ByteString packageName, ByteString apiKey, ByteString versionCode, ByteString versionName, ByteString installUuid, int deliveryMechanism, ByteString unityVersion) {
        int size = 0;
        size += CodedOutputStream.computeBytesSize(1, packageName);
        size += CodedOutputStream.computeBytesSize(2, versionCode);
        size += CodedOutputStream.computeBytesSize(3, versionName);
        int orgSize = SessionProtobufHelper.getSessionAppOrgSize(apiKey);
        size += CodedOutputStream.computeTagSize(5) + CodedOutputStream.computeRawVarint32Size(orgSize) + orgSize;
        size += CodedOutputStream.computeBytesSize(6, installUuid);
        if (unityVersion != null) {
            size += CodedOutputStream.computeBytesSize(8, UNITY_PLATFORM_BYTE_STRING);
            size += CodedOutputStream.computeBytesSize(9, unityVersion);
        }
        return size += CodedOutputStream.computeEnumSize(10, deliveryMechanism);
    }

    private static int getSessionAppOrgSize(ByteString apiKey) {
        int size = 0;
        return size += CodedOutputStream.computeBytesSize(1, apiKey);
    }

    private static int getSessionOSSize(ByteString release, ByteString codeName, boolean isRooted) {
        int size = 0;
        size += CodedOutputStream.computeEnumSize(1, 3);
        size += CodedOutputStream.computeBytesSize(2, release);
        size += CodedOutputStream.computeBytesSize(3, codeName);
        return size += CodedOutputStream.computeBoolSize(4, isRooted);
    }

    private static int getDeviceIdentifierSize(IdManager.DeviceIdentifierType type, String value) {
        int size = CodedOutputStream.computeEnumSize(1, type.protobufIndex);
        return size += CodedOutputStream.computeBytesSize(2, ByteString.copyFromUtf8(value));
    }

    private static int getSessionDeviceSize(int arch, ByteString clsDeviceID, ByteString model, int availableProcessors, long totalRam, long diskSpace, boolean isEmulator, Map<IdManager.DeviceIdentifierType, String> ids, int state, ByteString manufacturer, ByteString modelClass) {
        int size = 0;
        size += CodedOutputStream.computeBytesSize(1, clsDeviceID);
        size += CodedOutputStream.computeEnumSize(3, arch);
        size += model == null ? 0 : CodedOutputStream.computeBytesSize(4, model);
        size += CodedOutputStream.computeUInt32Size(5, availableProcessors);
        size += CodedOutputStream.computeUInt64Size(6, totalRam);
        size += CodedOutputStream.computeUInt64Size(7, diskSpace);
        size += CodedOutputStream.computeBoolSize(10, isEmulator);
        if (ids != null) {
            for (Map.Entry<IdManager.DeviceIdentifierType, String> id : ids.entrySet()) {
                int idSize = SessionProtobufHelper.getDeviceIdentifierSize(id.getKey(), id.getValue());
                size += CodedOutputStream.computeTagSize(11) + CodedOutputStream.computeRawVarint32Size(idSize) + idSize;
            }
        }
        size += CodedOutputStream.computeUInt32Size(12, state);
        size += manufacturer == null ? 0 : CodedOutputStream.computeBytesSize(13, manufacturer);
        return size += modelClass == null ? 0 : CodedOutputStream.computeBytesSize(14, modelClass);
    }

    private static int getBinaryImageSize(ByteString packageNameBytes, ByteString optionalBuildIdBytes) {
        int size = 0;
        size += CodedOutputStream.computeUInt64Size(1, 0L);
        size += CodedOutputStream.computeUInt64Size(2, 0L);
        size += CodedOutputStream.computeBytesSize(3, packageNameBytes);
        if (optionalBuildIdBytes != null) {
            size += CodedOutputStream.computeBytesSize(4, optionalBuildIdBytes);
        }
        return size;
    }

    private static int getSessionEventSize(long eventTime, String eventType, Throwable exception, Thread exceptionThread, StackTraceElement[] exceptionStack, Thread[] otherThreads, List<StackTraceElement[]> otherStacks, int maxChainedExceptionsDepth, Map<String, String> customAttributes, ActivityManager.RunningAppProcessInfo runningAppProcessInfo, int orientation, ByteString packageNameBytes, ByteString optionalBuildIdBytes, float batteryLevel, int batteryVelocity, boolean proximityEnabled, long heapAllocatedSize, long diskUsed, ByteString log) {
        int size = 0;
        size += CodedOutputStream.computeUInt64Size(1, eventTime);
        size += CodedOutputStream.computeBytesSize(2, ByteString.copyFromUtf8(eventType));
        int eventAppSize = SessionProtobufHelper.getEventAppSize(exception, exceptionThread, exceptionStack, otherThreads, otherStacks, maxChainedExceptionsDepth, packageNameBytes, optionalBuildIdBytes, customAttributes, runningAppProcessInfo, orientation);
        size += CodedOutputStream.computeTagSize(3) + CodedOutputStream.computeRawVarint32Size(eventAppSize) + eventAppSize;
        int eventDeviceSize = SessionProtobufHelper.getEventDeviceSize(batteryLevel, batteryVelocity, proximityEnabled, orientation, heapAllocatedSize, diskUsed);
        size += CodedOutputStream.computeTagSize(5) + CodedOutputStream.computeRawVarint32Size(eventDeviceSize) + eventDeviceSize;
        if (log != null) {
            int logSize = SessionProtobufHelper.getEventLogSize(log);
            size += CodedOutputStream.computeTagSize(6) + CodedOutputStream.computeRawVarint32Size(logSize) + logSize;
        }
        return size;
    }

    private static int getEventAppSize(Throwable exception, Thread exceptionThread, StackTraceElement[] exceptionStack, Thread[] otherThreads, List<StackTraceElement[]> otherStacks, int maxChainedExceptionsDepth, ByteString packageNameBytes, ByteString optionalBuildIdBytes, Map<String, String> customAttributes, ActivityManager.RunningAppProcessInfo runningAppProcessInfo, int orientation) {
        int size = 0;
        int executionSize = SessionProtobufHelper.getEventAppExecutionSize(exception, exceptionThread, exceptionStack, otherThreads, otherStacks, maxChainedExceptionsDepth, packageNameBytes, optionalBuildIdBytes);
        size += CodedOutputStream.computeTagSize(1) + CodedOutputStream.computeRawVarint32Size(executionSize) + executionSize;
        if (customAttributes != null) {
            for (Map.Entry<String, String> entry : customAttributes.entrySet()) {
                int entrySize = SessionProtobufHelper.getEventAppCustomAttributeSize(entry.getKey(), entry.getValue());
                size += CodedOutputStream.computeTagSize(2) + CodedOutputStream.computeRawVarint32Size(entrySize) + entrySize;
            }
        }
        if (runningAppProcessInfo != null) {
            size += CodedOutputStream.computeBoolSize(3, runningAppProcessInfo.importance != 100);
        }
        return size += CodedOutputStream.computeUInt32Size(4, orientation);
    }

    private static int getEventAppExecutionSize(Throwable exception, Thread exceptionThread, StackTraceElement[] exceptionStack, Thread[] otherThreads, List<StackTraceElement[]> otherStacks, int maxChainedExceptionDepth, ByteString packageNameBytes, ByteString optionalBuildIdBytes) {
        int size = 0;
        int threadSize = SessionProtobufHelper.getThreadSize(exceptionThread, exceptionStack, 4, true);
        size += CodedOutputStream.computeTagSize(1) + CodedOutputStream.computeRawVarint32Size(threadSize) + threadSize;
        int len = otherThreads.length;
        for (int i = 0; i < len; ++i) {
            Thread thread = otherThreads[i];
            threadSize = SessionProtobufHelper.getThreadSize(thread, otherStacks.get(i), 0, false);
            size += CodedOutputStream.computeTagSize(1) + CodedOutputStream.computeRawVarint32Size(threadSize) + threadSize;
        }
        int exceptionSize = SessionProtobufHelper.getEventAppExecutionExceptionSize(exception, 1, maxChainedExceptionDepth);
        size += CodedOutputStream.computeTagSize(2) + CodedOutputStream.computeRawVarint32Size(exceptionSize) + exceptionSize;
        int signalSize = SessionProtobufHelper.getEventAppExecutionSignalSize();
        size += CodedOutputStream.computeTagSize(3) + CodedOutputStream.computeRawVarint32Size(signalSize) + signalSize;
        int binaryImageSize = SessionProtobufHelper.getBinaryImageSize(packageNameBytes, optionalBuildIdBytes);
        return size += CodedOutputStream.computeTagSize(3) + CodedOutputStream.computeRawVarint32Size(binaryImageSize) + binaryImageSize;
    }

    private static int getEventAppCustomAttributeSize(String key, String value) {
        int size = CodedOutputStream.computeBytesSize(1, ByteString.copyFromUtf8(key));
        return size += CodedOutputStream.computeBytesSize(2, ByteString.copyFromUtf8(value == null ? "" : value));
    }

    private static int getEventDeviceSize(float batteryLevel, int batteryVelocity, boolean proximityEnabled, int orientation, long heapAllocatedSize, long diskUsed) {
        int size = 0;
        size += CodedOutputStream.computeFloatSize(1, batteryLevel);
        size += CodedOutputStream.computeSInt32Size(2, batteryVelocity);
        size += CodedOutputStream.computeBoolSize(3, proximityEnabled);
        size += CodedOutputStream.computeUInt32Size(4, orientation);
        size += CodedOutputStream.computeUInt64Size(5, heapAllocatedSize);
        return size += CodedOutputStream.computeUInt64Size(6, diskUsed);
    }

    private static int getEventLogSize(ByteString log) {
        return CodedOutputStream.computeBytesSize(1, log);
    }

    private static int getEventAppExecutionExceptionSize(Throwable ex, int chainDepth, int maxChainedExceptionsDepth) {
        int size = 0;
        size += CodedOutputStream.computeBytesSize(1, ByteString.copyFromUtf8(ex.getClass().getName()));
        String message = ex.getLocalizedMessage();
        if (message != null) {
            size += CodedOutputStream.computeBytesSize(3, ByteString.copyFromUtf8(message));
        }
        for (StackTraceElement element : ex.getStackTrace()) {
            int frameSize = SessionProtobufHelper.getFrameSize(element, true);
            size += CodedOutputStream.computeTagSize(4) + CodedOutputStream.computeRawVarint32Size(frameSize) + frameSize;
        }
        Throwable cause = ex.getCause();
        if (cause != null) {
            if (chainDepth < maxChainedExceptionsDepth) {
                int exceptionSize = SessionProtobufHelper.getEventAppExecutionExceptionSize(cause, chainDepth + 1, maxChainedExceptionsDepth);
                size += CodedOutputStream.computeTagSize(6) + CodedOutputStream.computeRawVarint32Size(exceptionSize) + exceptionSize;
            } else {
                int overflowCount = 0;
                while (cause != null) {
                    cause = cause.getCause();
                    ++overflowCount;
                }
                size += CodedOutputStream.computeUInt32Size(7, overflowCount);
            }
        }
        return size;
    }

    private static int getEventAppExecutionSignalSize() {
        int size = 0;
        size += CodedOutputStream.computeBytesSize(1, SIGNAL_DEFAULT_BYTE_STRING);
        size += CodedOutputStream.computeBytesSize(2, SIGNAL_DEFAULT_BYTE_STRING);
        return size += CodedOutputStream.computeUInt64Size(3, 0L);
    }

    private static int getFrameSize(StackTraceElement element, boolean isCrashedThread) {
        int size = 0;
        size = element.isNativeMethod() ? (size += CodedOutputStream.computeUInt64Size(1, Math.max(element.getLineNumber(), 0))) : (size += CodedOutputStream.computeUInt64Size(1, 0L));
        size += CodedOutputStream.computeBytesSize(2, ByteString.copyFromUtf8(element.getClassName() + "." + element.getMethodName()));
        if (element.getFileName() != null) {
            size += CodedOutputStream.computeBytesSize(3, ByteString.copyFromUtf8(element.getFileName()));
        }
        if (!element.isNativeMethod() && element.getLineNumber() > 0) {
            size += CodedOutputStream.computeUInt64Size(4, element.getLineNumber());
        }
        return size += CodedOutputStream.computeUInt32Size(5, isCrashedThread ? 2 : 0);
    }

    private static int getThreadSize(Thread thread, StackTraceElement[] stackTraceElements, int importance, boolean isCrashedThread) {
        int size = CodedOutputStream.computeBytesSize(1, ByteString.copyFromUtf8(thread.getName()));
        size += CodedOutputStream.computeUInt32Size(2, importance);
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            int frameSize = SessionProtobufHelper.getFrameSize(stackTraceElement, isCrashedThread);
            size += CodedOutputStream.computeTagSize(3) + CodedOutputStream.computeRawVarint32Size(frameSize) + frameSize;
        }
        return size;
    }

    private static ByteString stringToByteString(String s) {
        return s == null ? null : ByteString.copyFromUtf8(s);
    }
}

