/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.settings.SettingsData;
import java.util.concurrent.atomic.AtomicBoolean;

class CrashlyticsUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final CrashListener crashListener;
    private final SettingsDataProvider settingsDataProvider;
    private final boolean firebaseCrashlyticsClientFlag;
    private final Thread.UncaughtExceptionHandler defaultHandler;
    private final AtomicBoolean isHandlingException;

    public CrashlyticsUncaughtExceptionHandler(CrashListener crashListener, SettingsDataProvider settingsDataProvider, boolean firebaseCrashlyticsClientFlag, Thread.UncaughtExceptionHandler defaultHandler) {
        this.crashListener = crashListener;
        this.settingsDataProvider = settingsDataProvider;
        this.firebaseCrashlyticsClientFlag = firebaseCrashlyticsClientFlag;
        this.defaultHandler = defaultHandler;
        this.isHandlingException = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        this.isHandlingException.set(true);
        try {
            this.crashListener.onUncaughtException(this.settingsDataProvider, thread, ex, this.firebaseCrashlyticsClientFlag);
        }
        catch (Exception e) {
            Fabric.getLogger().e("CrashlyticsCore", "An error occurred in the uncaught exception handler", (Throwable)e);
        }
        finally {
            Fabric.getLogger().d("CrashlyticsCore", "Crashlytics completed exception processing. Invoking default exception handler.");
            this.defaultHandler.uncaughtException(thread, ex);
            this.isHandlingException.set(false);
        }
    }

    boolean isHandlingException() {
        return this.isHandlingException.get();
    }

    static interface SettingsDataProvider {
        public SettingsData getSettingsData();
    }

    static interface CrashListener {
        public void onUncaughtException(SettingsDataProvider var1, Thread var2, Throwable var3, boolean var4);
    }
}

