/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import com.crashlytics.android.core.ProcMapEntry;
import io.fabric.sdk.android.Fabric;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ProcMapEntryParser {
    private static final Pattern MAP_REGEX = Pattern.compile("\\s*(\\p{XDigit}+)-\\s*(\\p{XDigit}+)\\s+(.{4})\\s+\\p{XDigit}+\\s+.+\\s+\\d+\\s+(.*)");

    private ProcMapEntryParser() {
    }

    public static ProcMapEntry parse(String mapEntry) {
        Matcher m = MAP_REGEX.matcher(mapEntry);
        if (!m.matches()) {
            return null;
        }
        try {
            long address = Long.valueOf(m.group(1), 16);
            long size = Long.valueOf(m.group(2), 16) - address;
            String perms = m.group(3);
            String path = m.group(4);
            return new ProcMapEntry(address, size, perms, path);
        }
        catch (Exception e) {
            Fabric.getLogger().d("CrashlyticsCore", "Could not parse map entry: " + mapEntry);
            return null;
        }
    }
}

