/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import com.crashlytics.android.core.BinaryImagesConverter;
import io.fabric.sdk.android.services.common.CommonUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class Sha1FileIdStrategy
implements BinaryImagesConverter.FileIdStrategy {
    Sha1FileIdStrategy() {
    }

    @Override
    public String createId(File file) throws IOException {
        return Sha1FileIdStrategy.getFileSHA(file.getPath());
    }

    private static String getFileSHA(String path) throws IOException {
        String sha = null;
        BufferedInputStream data = null;
        try {
            data = new BufferedInputStream(new FileInputStream(path));
            sha = CommonUtils.sha1((InputStream)data);
        }
        catch (Throwable throwable) {
            CommonUtils.closeQuietly(data);
            throw throwable;
        }
        CommonUtils.closeQuietly((Closeable)data);
        return sha;
    }
}

